/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.manage.schema;

import org.gradle.model.ModelMap;
import org.gradle.model.ModelSet;
import org.gradle.model.collection.ManagedSet;
import org.gradle.model.internal.manage.schema.ModelSchema;
import org.gradle.model.internal.type.ModelType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelCollectionSchema<T>
extends ModelSchema<T> {
    private final ModelType<?> elementType;
    private boolean map;

    public ModelCollectionSchema(ModelType<T> type, ModelType<?> elementType) {
        super(type, ModelSchema.Kind.COLLECTION);
        this.elementType = elementType;
        if (type.getRawClass().equals(ModelMap.class)) {
            this.map = true;
        } else if (type.getRawClass().equals(ModelSet.class) || type.getRawClass().equals(ManagedSet.class)) {
            this.map = false;
        } else {
            throw new IllegalArgumentException("Expected type of either ModelMap or ModelSet");
        }
    }

    public ModelType<?> getElementType() {
        return this.elementType;
    }

    public boolean isMap() {
        return this.map;
    }
}

