/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.registry;

import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Supplier;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import java.util.EnumMap;
import java.util.List;
import java.util.Set;
import org.gradle.api.Nullable;
import org.gradle.model.internal.core.ModelAdapter;
import org.gradle.model.internal.core.ModelCreator;
import org.gradle.model.internal.core.ModelNode;
import org.gradle.model.internal.core.ModelPath;
import org.gradle.model.internal.core.ModelPromise;
import org.gradle.model.internal.core.ModelView;
import org.gradle.model.internal.core.MutableModelNode;
import org.gradle.model.internal.core.rule.describe.ModelRuleDescriptor;
import org.gradle.model.internal.registry.CreatorRuleBinder;
import org.gradle.model.internal.registry.ModelBinding;
import org.gradle.model.internal.registry.MutatorRuleBinder;
import org.gradle.model.internal.registry.RuleBinder;
import org.gradle.model.internal.type.ModelType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class ModelNodeInternal
implements MutableModelNode {
    private static final Supplier<List<MutatorRuleBinder<?>>> LIST_SUPPLIER = new Supplier<List<MutatorRuleBinder<?>>>(){

        public List<MutatorRuleBinder<?>> get() {
            return Lists.newArrayList();
        }
    };
    private static final Logger LOGGER = LoggerFactory.getLogger(ModelNodeInternal.class);
    private CreatorRuleBinder creatorBinder;
    private final Set<ModelNodeInternal> dependencies = Sets.newHashSet();
    private final Set<ModelNodeInternal> dependents = Sets.newHashSet();
    private ModelNode.State state = ModelNode.State.Known;
    private boolean hidden;

    public ModelNodeInternal(CreatorRuleBinder creatorBinder) {
        this.creatorBinder = creatorBinder;
    }

    public CreatorRuleBinder getCreatorBinder() {
        return this.creatorBinder;
    }

    public void replaceCreatorRuleBinder(CreatorRuleBinder newCreatorBinder) {
        if (this.getState() != ModelNode.State.Known) {
            throw new IllegalStateException("Cannot replace creator rule binder when not in known state (node: " + this + ", state: " + (Object)((Object)this.getState()) + ")");
        }
        ModelCreator newCreator = newCreatorBinder.getCreator();
        ModelCreator oldCreator = this.creatorBinder.getCreator();
        if (!oldCreator.getPromise().equals(newCreator.getPromise())) {
            throw new IllegalStateException("can not replace node " + this.getPath() + " with different promise (old: " + oldCreator.getPromise() + ", new: " + newCreator.getPromise() + ")");
        }
        if (!newCreator.getInputs().equals(oldCreator.getInputs())) {
            Joiner joiner = Joiner.on((String)", ");
            throw new IllegalStateException("can not replace node " + this.getPath() + " with creator with different input bindings (old: [" + joiner.join(oldCreator.getInputs()) + "], new: [" + joiner.join(newCreator.getInputs()) + "])");
        }
        this.creatorBinder = newCreatorBinder;
    }

    @Override
    public boolean isHidden() {
        return this.hidden;
    }

    @Override
    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    @Override
    public boolean isEphemeral() {
        return this.creatorBinder.getCreator().isEphemeral();
    }

    private static ListMultimap<ModelNode.State, MutatorRuleBinder<?>> createMutatorsMap() {
        return Multimaps.newListMultimap(new EnumMap(ModelNode.State.class), LIST_SUPPLIER);
    }

    public void notifyFired(RuleBinder binder) {
        assert (binder.isBound());
        for (ModelBinding inputBinding : binder.getInputBindings()) {
            ModelNodeInternal node = inputBinding.getNode();
            this.dependencies.add(node);
            node.dependents.add(this);
        }
    }

    public Iterable<? extends ModelNode> getDependencies() {
        return this.dependencies;
    }

    public Iterable<? extends ModelNode> getDependents() {
        return this.dependents;
    }

    @Override
    public ModelPath getPath() {
        return this.creatorBinder.getCreator().getPath();
    }

    @Override
    public ModelRuleDescriptor getDescriptor() {
        return this.creatorBinder.getDescriptor();
    }

    @Override
    public ModelNode.State getState() {
        return this.state;
    }

    public void setState(ModelNode.State state) {
        this.state = state;
    }

    @Override
    public boolean isMutable() {
        return this.state.mutable;
    }

    public boolean canApply(ModelNode.State targetState) {
        return this.state.compareTo(targetState) < 0;
    }

    public ModelPromise getPromise() {
        return this.creatorBinder.getCreator().getPromise();
    }

    public ModelAdapter getAdapter() {
        return this.creatorBinder.getCreator().getAdapter();
    }

    public String toString() {
        return this.getPath().toString();
    }

    @Override
    public abstract ModelNodeInternal getTarget();

    public abstract Iterable<? extends ModelNodeInternal> getLinks();

    public abstract ModelNodeInternal addLink(ModelNodeInternal var1);

    @Override
    public <T> ModelView<? extends T> asReadOnly(ModelType<T> type, @Nullable ModelRuleDescriptor ruleDescriptor) {
        ModelView<T> modelView = this.getAdapter().asReadOnly(type, this, ruleDescriptor);
        if (modelView == null) {
            throw new IllegalStateException("Model node " + this.getPath() + " cannot be expressed as a read-only view of type " + type);
        }
        return modelView;
    }

    @Override
    public <T> ModelView<? extends T> asWritable(ModelType<T> type, ModelRuleDescriptor ruleDescriptor, List<ModelView<?>> inputs) {
        ModelView<T> modelView = this.getAdapter().asWritable(type, this, ruleDescriptor, inputs);
        if (modelView == null) {
            throw new IllegalStateException("Model node " + this.getPath() + " cannot be expressed as a mutable view of type " + type);
        }
        return modelView;
    }

    public void reset() {
        if (this.getState() != ModelNode.State.Known) {
            this.setState(ModelNode.State.Known);
            this.setPrivateData(ModelType.untyped(), null);
            for (ModelNodeInternal modelNodeInternal : this.dependents) {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("resetting dependent node of {}: {}", (Object)this, (Object)modelNodeInternal);
                }
                modelNodeInternal.reset();
            }
            for (ModelNodeInternal modelNodeInternal : this.getLinks()) {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("resetting child node of {}: {}", (Object)this, (Object)modelNodeInternal);
                }
                modelNodeInternal.reset();
            }
        }
    }

    @Override
    @Nullable
    public Optional<String> getValueDescription() {
        this.ensureUsable();
        return this.getAdapter().getValueDescription(this);
    }
}

