/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.style.parameterToEntry;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.ui.ConflictsDialog;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.intentions.GroovyIntentionsBundle;
import org.jetbrains.plugins.groovy.intentions.base.Intention;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.intentions.style.parameterToEntry.GroovyMapParameterDialog;
import org.jetbrains.plugins.groovy.lang.psi.GrNamedElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.signatures.GrClosureSignature;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrParametersOwner;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameterList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrAccessorMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrMapType;
import org.jetbrains.plugins.groovy.lang.psi.impl.signatures.GrClosureSignatureUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.typedef.members.GrMethodImpl;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyPropertyUtils;
import org.jetbrains.plugins.groovy.refactoring.GroovyValidationUtil;

public class ConvertParameterToMapEntryIntention
extends Intention {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.plugins.groovy.intentions.style.ConvertParameterToMapEntryIntention");
    @NonNls
    private static final String CLOSURE_CAPTION = "closure";
    @NonNls
    private static final String CLOSURE_CAPTION_CAP = "Closure";
    @NonNls
    private static final String METHOD_CAPTION = "method";
    @NonNls
    private static final String METHOD_CAPTION_CAP = "Method";
    @NonNls
    private static final String REFACTORING_NAME = "Convert Parameter to Map Entry";
    @NonNls
    private static final String MAP_TYPE_TEXT = "Map";
    @NonNls
    private static final String[] MY_POSSIBLE_NAMES = new String[]{"attrs", "args", "params", "map"};

    @Override
    protected void processIntention(final @NotNull PsiElement element, final Project project, Editor editor) throws IncorrectOperationException {
        ArrayList<PsiElement> occurrences;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/groovy/intentions/style/parameterToEntry/ConvertParameterToMapEntryIntention", "processIntention"));
        }
        final GrParametersOwner owner = (GrParametersOwner)PsiTreeUtil.getParentOfType((PsiElement)element, GrParametersOwner.class);
        boolean success = ConvertParameterToMapEntryIntention.collectOwnerOccurrences(project, owner, occurrences = new ArrayList<PsiElement>());
        if (!success) {
            return;
        }
        final boolean isClosure = owner instanceof GrClosableBlock;
        if (!ConvertParameterToMapEntryIntention.checkOwnerOccurrences(project, occurrences, isClosure)) {
            return;
        }
        final GrParameter firstParam = ConvertParameterToMapEntryIntention.getFirstParameter(owner);
        switch (ConvertParameterToMapEntryIntention.analyzeForNamedArguments(owner, occurrences)) {
            case ERROR: {
                GrNamedElement namedElement = ConvertParameterToMapEntryIntention.getReferencedElement(owner);
                LOG.assertTrue(namedElement != null);
                String msg = GroovyIntentionsBundle.message("wrong.first.parameter.type", isClosure ? CLOSURE_CAPTION_CAP : METHOD_CAPTION_CAP, namedElement.getName(), firstParam.getName());
                ConvertParameterToMapEntryIntention.showErrorMessage(msg, project);
                return;
            }
            case MUST_BE_MAP: {
                if (firstParam == ConvertParameterToMapEntryIntention.getAppropriateParameter(element)) {
                    String msg = GroovyIntentionsBundle.message("convert.cannot.itself", new Object[0]);
                    ConvertParameterToMapEntryIntention.showErrorMessage(msg, project);
                    return;
                }
                ConvertParameterToMapEntryIntention.performRefactoring(element, owner, occurrences, false, null, false);
                break;
            }
            case IS_NOT_MAP: {
                if (!ApplicationManager.getApplication().isUnitTestMode()) {
                    final String[] possibleNames = ConvertParameterToMapEntryIntention.generateValidNames(MY_POSSIBLE_NAMES, firstParam);
                    ApplicationManager.getApplication().invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            GroovyMapParameterDialog dialog = new GroovyMapParameterDialog(project, possibleNames, true){

                                @Override
                                protected void doOKAction() {
                                    String name = this.getEnteredName();
                                    MultiMap conflicts = new MultiMap();
                                    assert (name != null);
                                    GroovyValidationUtil.validateNewParameterName(firstParam, (MultiMap<PsiElement, String>)conflicts, name);
                                    if (isClosure) {
                                        ConvertParameterToMapEntryIntention.findClosureConflictUsages((MultiMap<PsiElement, String>)conflicts, occurrences);
                                    }
                                    if (ConvertParameterToMapEntryIntention.reportConflicts((MultiMap<PsiElement, String>)conflicts, project)) {
                                        ConvertParameterToMapEntryIntention.performRefactoring(element, owner, occurrences, this.createNewFirst(), name, this.specifyTypeExplicitly());
                                    }
                                    super.doOKAction();
                                }
                            };
                            dialog.show();
                        }
                    });
                    break;
                }
                ConvertParameterToMapEntryIntention.performRefactoring(element, owner, occurrences, true, new GroovyValidationUtil.ParameterNameSuggester("attrs", firstParam).generateName(), true);
            }
        }
    }

    private static void findClosureConflictUsages(MultiMap<PsiElement, String> conflicts, Collection<PsiElement> occurrences) {
        Iterator<PsiElement> iterator = occurrences.iterator();
        while (iterator.hasNext()) {
            PsiElement occurrence;
            PsiElement origin = occurrence = iterator.next();
            while (occurrence instanceof GrReferenceExpression) {
                occurrence = occurrence.getParent();
            }
            if (!(occurrence instanceof GrArgumentList)) continue;
            conflicts.putValue((Object)origin, (Object)GroovyIntentionsBundle.message("closure.used.as.variable", new Object[0]));
        }
    }

    private static String[] generateValidNames(String[] names, final GrParameter param) {
        return (String[])ContainerUtil.map2Array((Object[])names, String.class, (Function)new Function<String, String>(){

            public String fun(String s) {
                return new GroovyValidationUtil.ParameterNameSuggester(s, param).generateName();
            }
        });
    }

    private static void performRefactoring(PsiElement element, final GrParametersOwner owner, final Collection<PsiElement> occurrences, final boolean createNewFirstParam, @Nullable String mapParamName, final boolean specifyMapType) {
        final GrParameter param = ConvertParameterToMapEntryIntention.getAppropriateParameter(element);
        assert (param != null);
        final String paramName = param.getName();
        final String mapName = createNewFirstParam ? mapParamName : ConvertParameterToMapEntryIntention.getFirstParameter(owner).getName();
        final Project project = element.getProject();
        final Runnable runnable = new Runnable(){

            @Override
            public void run() {
                GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(project);
                GrParameterList list = owner.getParameterList();
                assert (list != null);
                int index = list.getParameterNumber(param);
                if (!createNewFirstParam && index <= 0) {
                    return;
                }
                try {
                    for (Object occurrence : occurrences) {
                        GrNamedArgument namedArg;
                        GrClosureSignatureUtil.ArgInfo<PsiElement>[] argInfos;
                        GrCall call;
                        PsiElement parent;
                        GrClosureSignature signature;
                        GrReferenceExpression refExpr = null;
                        GroovyResolveResult resolveResult = null;
                        boolean isExplicitGetterCall = false;
                        if (occurrence instanceof GrReferenceExpression) {
                            PsiElement resolved;
                            PsiElement parent2 = occurrence.getParent();
                            if (parent2 instanceof GrCall) {
                                refExpr = (GrReferenceExpression)occurrence;
                                resolveResult = refExpr.advancedResolve();
                                resolved = resolveResult.getElement();
                                if (resolved instanceof PsiMethod && GroovyPropertyUtils.isSimplePropertyGetter((PsiMethod)resolved) && ((PsiMethod)resolved).getName().equals(refExpr.getReferenceName())) {
                                    isExplicitGetterCall = true;
                                }
                            } else if (parent2 instanceof GrReferenceExpression && (resolved = (resolveResult = ((GrReferenceExpression)parent2).advancedResolve()).getElement()) instanceof PsiMethod && "call".equals(((PsiMethod)resolved).getName())) {
                                refExpr = (GrReferenceExpression)parent2;
                            }
                        }
                        if (refExpr == null || (signature = ConvertParameterToMapEntryIntention.generateSignature(owner, refExpr)) == null) continue;
                        if (isExplicitGetterCall) {
                            parent = refExpr.getParent();
                            LOG.assertTrue(parent instanceof GrCall);
                            parent = parent.getParent();
                            if (parent instanceof GrReferenceExpression && "call".equals(((GrReferenceExpression)parent).getReferenceName())) {
                                parent = parent.getParent();
                            }
                            if (!(parent instanceof GrCall)) continue;
                            call = (GrCall)parent;
                        } else {
                            call = (GrCall)refExpr.getParent();
                        }
                        if (resolveResult.isInvokedOnProperty()) {
                            parent = call.getParent();
                            if (parent instanceof GrCall) {
                                call = (GrCall)parent;
                            } else if (parent instanceof GrReferenceExpression && parent.getParent() instanceof GrCall) {
                                PsiElement resolved = ((GrReferenceExpression)parent).resolve();
                                if (!(resolved instanceof PsiMethod) || !"call".equals(((PsiMethod)resolved).getName())) continue;
                                call = (GrCall)parent.getParent();
                            }
                        }
                        if ((argInfos = GrClosureSignatureUtil.mapParametersToArguments(signature, call)) == null) continue;
                        GrClosureSignatureUtil.ArgInfo<PsiElement> argInfo = argInfos[index];
                        if (argInfo.isMultiArg) {
                            if (argInfo.args.isEmpty()) continue;
                            String arg = "[" + StringUtil.join((Collection)ContainerUtil.map(argInfo.args, (Function)new Function<PsiElement, String>(){

                                public String fun(PsiElement element) {
                                    return element.getText();
                                }
                            }), (String)", ") + "]";
                            for (PsiElement psiElement : argInfo.args) {
                                psiElement.delete();
                            }
                            namedArg = factory.createNamedArgument(paramName, factory.createExpressionFromText(arg));
                        } else {
                            if (argInfo.args.isEmpty()) continue;
                            PsiElement argument = (PsiElement)argInfo.args.iterator().next();
                            assert (argument instanceof GrExpression);
                            namedArg = factory.createNamedArgument(paramName, (GrExpression)argument);
                            argument.delete();
                        }
                        call.addNamedArgument(namedArg);
                    }
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                }
                Collection references = ReferencesSearch.search((PsiElement)param).findAll();
                for (PsiReference ref : references) {
                    PsiElement elt = ref.getElement();
                    if (!(elt instanceof GrReferenceExpression)) continue;
                    GrReferenceExpression expr = (GrReferenceExpression)elt;
                    GrExpression newExpr = factory.createExpressionFromText(mapName + "." + paramName);
                    expr.replaceWithExpression(newExpr, true);
                }
                if (createNewFirstParam) {
                    try {
                        GrParameter newParam = factory.createParameter(mapName, specifyMapType ? ConvertParameterToMapEntryIntention.MAP_TYPE_TEXT : "", null);
                        list.addAfter(newParam, null);
                    }
                    catch (IncorrectOperationException e) {
                        LOG.error((Throwable)e);
                    }
                }
                param.delete();
            }
        };
        CommandProcessor.getInstance().executeCommand(project, new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().runWriteAction(runnable);
            }
        }, REFACTORING_NAME, null);
    }

    @Nullable
    private static GrParameter getAppropriateParameter(PsiElement element) {
        if (element instanceof GrParameter) {
            return (GrParameter)element;
        }
        if (element instanceof GrReferenceExpression) {
            GrReferenceExpression expr = (GrReferenceExpression)element;
            PsiElement resolved = expr.resolve();
            LOG.assertTrue(resolved instanceof GrParameter);
            return (GrParameter)resolved;
        }
        LOG.error("Selected expression is not resolved to method/closure parameter");
        return null;
    }

    @Nullable
    private static GrClosureSignature generateSignature(GrParametersOwner owner, GrReferenceExpression refExpr) {
        if (owner instanceof PsiMethod) {
            GroovyResolveResult resolveResult = refExpr.advancedResolve();
            PsiSubstitutor substitutor = resolveResult.getSubstitutor();
            return GrClosureSignatureUtil.createSignature((PsiMethod)owner, substitutor);
        }
        if (owner instanceof GrClosableBlock) {
            return GrClosureSignatureUtil.createSignature((GrClosableBlock)owner);
        }
        return null;
    }

    private static FIRST_PARAMETER_KIND analyzeForNamedArguments(GrParametersOwner owner, Collection<PsiElement> occurrences) {
        boolean thereAreNamedArguments = false;
        for (PsiElement occurrence : occurrences) {
            GrCall call;
            GrArgumentList args;
            if (occurrence instanceof GrReferenceExpression && occurrence.getParent() instanceof GrCall && (args = (call = (GrCall)occurrence.getParent()).getArgumentList()) != null && args.getNamedArguments().length > 0) {
                thereAreNamedArguments = true;
            }
            if (!thereAreNamedArguments) continue;
            break;
        }
        if (thereAreNamedArguments) {
            if (ConvertParameterToMapEntryIntention.firstOwnerParameterMustBeMap(owner)) {
                return FIRST_PARAMETER_KIND.MUST_BE_MAP;
            }
            return FIRST_PARAMETER_KIND.ERROR;
        }
        return FIRST_PARAMETER_KIND.IS_NOT_MAP;
    }

    private static boolean firstOwnerParameterMustBeMap(GrParametersOwner owner) {
        GrParameter first = ConvertParameterToMapEntryIntention.getFirstParameter(owner);
        PsiType type = first.getTypeGroovy();
        GrMapType mapType = GrMapType.create(GlobalSearchScope.allScope((Project)owner.getProject()));
        return type == null || type.isConvertibleFrom((PsiType)mapType);
    }

    @NotNull
    private static GrParameter getFirstParameter(GrParametersOwner owner) {
        GrParameter[] params = owner.getParameters();
        LOG.assertTrue(params.length > 0);
        GrParameter grParameter = params[0];
        if (grParameter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/intentions/style/parameterToEntry/ConvertParameterToMapEntryIntention", "getFirstParameter"));
        }
        return grParameter;
    }

    @Nullable
    private static GrNamedElement getReferencedElement(GrParametersOwner owner) {
        PsiElement parent;
        if (owner instanceof GrMethodImpl) {
            return (GrMethodImpl)owner;
        }
        if (owner instanceof GrClosableBlock && (parent = owner.getParent()) instanceof GrVariable && ((GrVariable)parent).getInitializerGroovy() == owner) {
            return (GrVariable)parent;
        }
        return null;
    }

    private static boolean checkOwnerOccurrences(Project project, Collection<PsiElement> occurrences, boolean isClosure) {
        boolean result = true;
        StringBuilder msg = new StringBuilder();
        msg.append(GroovyIntentionsBundle.message("conversion.not.allowed.in.non.groovy.files", isClosure ? CLOSURE_CAPTION : METHOD_CAPTION));
        for (PsiElement element : occurrences) {
            PsiFile file = element.getContainingFile();
            if (file instanceof GroovyFileBase) continue;
            result = false;
            msg.append("\n").append(file.getName());
        }
        if (!result) {
            ConvertParameterToMapEntryIntention.showErrorMessage(msg.toString(), project);
            return false;
        }
        return true;
    }

    private static boolean collectOwnerOccurrences(Project project, GrParametersOwner owner, final Collection<PsiElement> occurrences) {
        final GrNamedElement namedElem = ConvertParameterToMapEntryIntention.getReferencedElement(owner);
        if (namedElem == null) {
            return true;
        }
        final Ref result = new Ref((Object)true);
        Task.Modal task = new Task.Modal(project, GroovyIntentionsBundle.message("find.method.ro.closure.usages.0", owner instanceof GrClosableBlock ? CLOSURE_CAPTION : METHOD_CAPTION), true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/plugins/groovy/intentions/style/parameterToEntry/ConvertParameterToMapEntryIntention$5", "run"));
                }
                final Set<PsiReference> references = Collections.synchronizedSet(new HashSet());
                Processor<PsiReference> consumer = new Processor<PsiReference>(){

                    public boolean process(PsiReference psiReference) {
                        references.add(psiReference);
                        return true;
                    }
                };
                ReferencesSearch.search((PsiElement)namedElem).forEach((Processor)consumer);
                boolean isProperty = (Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

                    public Boolean compute() {
                        return namedElem instanceof GrField && ((GrField)namedElem).isProperty();
                    }
                });
                if (isProperty) {
                    GrAccessorMethod[] getters;
                    for (GrAccessorMethod getter : getters = (GrAccessorMethod[])ApplicationManager.getApplication().runReadAction((Computable)new Computable<GrAccessorMethod[]>(){

                        public GrAccessorMethod[] compute() {
                            return ((GrField)namedElem).getGetters();
                        }
                    })) {
                        MethodReferencesSearch.search((PsiMethod)getter).forEach((Processor)consumer);
                    }
                }
                for (final PsiReference reference : references) {
                    ApplicationManager.getApplication().runReadAction(new Runnable(){

                        @Override
                        public void run() {
                            PsiElement element = reference.getElement();
                            if (element != null) {
                                occurrences.add(element);
                            }
                        }
                    });
                }
            }

            public void onCancel() {
                result.set((Object)false);
            }

            public void onSuccess() {
                result.set((Object)true);
            }
        };
        ProgressManager.getInstance().run((Task)task);
        return (Boolean)result.get();
    }

    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        MyPsiElementPredicate myPsiElementPredicate = new MyPsiElementPredicate();
        if (myPsiElementPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/intentions/style/parameterToEntry/ConvertParameterToMapEntryIntention", "getElementPredicate"));
        }
        return myPsiElementPredicate;
    }

    private static boolean checkForMapParameters(GrParametersOwner owner) {
        GrParameter[] parameters = owner.getParameters();
        if (parameters.length != 1) {
            return true;
        }
        GrParameter parameter = parameters[0];
        PsiType type = parameter.getTypeGroovy();
        if (!(type instanceof PsiClassType)) {
            return true;
        }
        PsiClass psiClass = ((PsiClassType)type).resolve();
        return psiClass == null || !"java.util.Map".equals(psiClass.getQualifiedName());
    }

    private static void showErrorMessage(String message, Project project) {
        CommonRefactoringUtil.showErrorMessage((String)REFACTORING_NAME, (String)message, null, (Project)project);
    }

    private static boolean reportConflicts(MultiMap<PsiElement, String> conflicts, Project project) {
        if (conflicts.isEmpty()) {
            return true;
        }
        ConflictsDialog conflictsDialog = new ConflictsDialog(project, conflicts);
        return conflictsDialog.showAndGet();
    }

    private static class MyPsiElementPredicate
    implements PsiElementPredicate {
        private MyPsiElementPredicate() {
        }

        @Override
        public boolean satisfiedBy(PsiElement element) {
            GrParameter parameter = null;
            if (element instanceof GrParameter) {
                parameter = (GrParameter)element;
            } else if (element instanceof GrReferenceExpression) {
                GrReferenceExpression expr = (GrReferenceExpression)element;
                if (expr.getQualifierExpression() != null) {
                    return false;
                }
                PsiElement resolved = expr.resolve();
                if (resolved instanceof GrParameter) {
                    parameter = (GrParameter)resolved;
                }
            }
            if (parameter == null) {
                return false;
            }
            if (parameter.isOptional()) {
                return false;
            }
            GrParametersOwner owner = (GrParametersOwner)PsiTreeUtil.getParentOfType((PsiElement)element, GrParametersOwner.class);
            if (!(owner instanceof GrClosableBlock) && !(owner instanceof GrMethod)) {
                return false;
            }
            return ConvertParameterToMapEntryIntention.checkForMapParameters(owner);
        }
    }

    protected static enum FIRST_PARAMETER_KIND {
        IS_NOT_MAP,
        MUST_BE_MAP,
        ERROR;

    }
}

