/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.java.impl;

import com.intellij.util.Consumer;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.java.JpsAnnotationRootType;
import org.jetbrains.jps.model.java.JpsJavaDependenciesRootsEnumerator;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.java.JpsJavaModuleExtension;
import org.jetbrains.jps.model.java.impl.JpsJavaDependenciesEnumeratorImpl;
import org.jetbrains.jps.model.library.JpsOrderRootType;
import org.jetbrains.jps.model.module.JpsDependencyElement;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.model.module.JpsModuleDependency;
import org.jetbrains.jps.model.module.JpsModuleSourceRoot;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;
import org.jetbrains.jps.model.module.impl.JpsDependenciesRootsEnumeratorBase;

public class JpsJavaDependenciesRootsEnumeratorImpl
extends JpsDependenciesRootsEnumeratorBase<JpsJavaDependenciesEnumeratorImpl>
implements JpsJavaDependenciesRootsEnumerator {
    private boolean myWithoutSelfModuleOutput;

    public JpsJavaDependenciesRootsEnumeratorImpl(JpsJavaDependenciesEnumeratorImpl dependenciesEnumerator, JpsOrderRootType rootType) {
        super(dependenciesEnumerator, rootType);
    }

    public JpsJavaDependenciesRootsEnumerator withoutSelfModuleOutput() {
        this.myWithoutSelfModuleOutput = true;
        return this;
    }

    @Override
    protected boolean processModuleRootUrls(JpsModule module, JpsDependencyElement dependencyElement, Consumer<String> urlConsumer) {
        block7: {
            JpsJavaModuleExtension extension;
            block8: {
                String testsOutputUrl;
                JpsJavaExtensionService extensionService;
                boolean includeTests;
                boolean includeProduction;
                block9: {
                    String url;
                    block6: {
                        if (dependencyElement instanceof JpsModuleDependency) {
                            boolean productionOnTests = ((JpsJavaDependenciesEnumeratorImpl)this.myDependenciesEnumerator).isProductionOnTests(dependencyElement);
                            includeProduction = !productionOnTests;
                            includeTests = !((JpsJavaDependenciesEnumeratorImpl)this.myDependenciesEnumerator).isProductionOnly() && ((JpsJavaDependenciesEnumeratorImpl)this.myDependenciesEnumerator).shouldIncludeTestsFromDependentModulesToTestClasspath() || productionOnTests;
                        } else {
                            includeProduction = true;
                            boolean bl = includeTests = !((JpsJavaDependenciesEnumeratorImpl)this.myDependenciesEnumerator).isProductionOnly();
                        }
                        if (this.myRootType != JpsOrderRootType.SOURCES) break block6;
                        for (JpsModuleSourceRoot root : module.getSourceRoots()) {
                            JpsModuleSourceRootType type = root.getRootType();
                            if ((!type.equals(JavaSourceRootType.SOURCE) || !includeProduction) && (!type.equals(JavaSourceRootType.TEST_SOURCE) || !includeTests)) continue;
                            urlConsumer.consume((Object)root.getUrl());
                        }
                        break block7;
                    }
                    if (this.myRootType != JpsOrderRootType.COMPILED) break block8;
                    extensionService = JpsJavaExtensionService.getInstance();
                    if (!this.myWithoutSelfModuleOutput || !((JpsJavaDependenciesEnumeratorImpl)this.myDependenciesEnumerator).isEnumerationRootModule(module)) break block9;
                    if (!includeProduction || !includeTests || (url = extensionService.getOutputUrl(module, false)) == null) break block7;
                    urlConsumer.consume((Object)url);
                    break block7;
                }
                String outputUrl = extensionService.getOutputUrl(module, false);
                if (includeTests && (testsOutputUrl = extensionService.getOutputUrl(module, true)) != null && !testsOutputUrl.equals(outputUrl)) {
                    urlConsumer.consume((Object)testsOutputUrl);
                }
                if (!includeProduction || outputUrl == null) break block7;
                urlConsumer.consume((Object)outputUrl);
                break block7;
            }
            if (this.myRootType == JpsAnnotationRootType.INSTANCE && (extension = JpsJavaExtensionService.getInstance().getModuleExtension(module)) != null) {
                for (String url : extension.getAnnotationRoots().getUrls()) {
                    urlConsumer.consume((Object)url);
                }
            }
        }
        return true;
    }
}

