/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.jps.incremental.storage;

import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PersistentHashMap;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.jps.incremental.storage.LazyStorageKt$sam$ValueDataAppender$5847c6dd;

@KotlinClass(version={1, 0, 1}, abiVersion=32, data={"K\u0015\tA\"A\u0003\u0002\t\u0005)\u0011\u0001\u0003\u0001\u0006\u0001\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011!\u0002\u0001\u0006\u00031\tQ!\u0001\u0003\u0002\u000b\u0005Aq\"B\u0001\u0005\u0004\u0015\tA\"A\u0003\u0001\u000b\u0005A\u0011!\u0002\u0001\u0006\u00031\tQ!\u0001\u0007\u0002\u000b\u0005!!!B\u0001\t\f\u0015\tAQ\u0002\u0003\u0001\u0019\u0001)\"\u0001\u0002\u0001\t\u0002U\u0011A\u0011\u0001\u0005\u00023\u0005A\u001a!)\u000b\n\u0007!\u0011Q\"\u0001M\u0003\u0013\u0019A1!\u0004\u0003\n\u0005%\tA\u0004\u0001M\u0004\u0013\u0019AA!\u0004\u0003\n\u0005%\tA\u0014\u0001M\u0005#\u000e\t\u0001\"BS\u0014\u0011#i\u0011\u0001G\u0005\u001a\u0007!MQ\"\u0001\u000f\u00013%A\t\"D\u0004\n\u0005%\t\u0001TC\u0005\u0003\u0013\u0005A\u0012\u0002\u0007\u0006R\u0007\u0005A1\"\n\u0003\u0005\b!]Q\"\u0001\r\nK\u0011!9\u0001\u0003\u0007\u000e\u0003aIQe\u0003\u0003D\t!eQ\"\u0001\r\u000e3\rA\u0019\"D\u0001\u001d\u0001E\u001b\u0011\u0001c\u0007&\u0015\u0011\t\u0001BD\u0007\b\u0013\tI\u0011\u0001\b\u0001\n\u0005%\tA\u0014\u0001\r\tK!!9\u0001#\b\u000e\u0003aI\u0011d\u0001\u0005\u0010\u001b\u0005AR\"\n\u0007\u0005\u0007\u0012Ay\"\u0004\u0002\r\u0002q\u0005\u0011d\u0001E\n\u001b\u0005a\u0002!U\u0002\u0002\u0011A)3\u0002b\u0001\t\"5A\u0011BA\u0005\u00029\u0001I!!C\u0001\u001d\u00021\u0005\u0001\u0004C\u0013\u000b\t\u0007A\u0011#D\u0004\n\u0005%\tA\u0004A\u0005\u0003\u0013\u0005a\n\u0001\u0007\u0005&\u0014!\rR\"\u0001\r\n3\rA\u0019\"D\u0001\u001d\u0001E\u001b\u0011\u0001\u0003\n&\u001f\u0011\u0019E\u0001#\n\u000e\u0003aI\u0011d\u0001E\n\u001b\u0005a\u0002!G\u0002\t'5\tA\u0014A)\u0004\u0003!\u001d\u0012F\u0003\u0003B\u0011!\u0019Q\u0002B\u0005\u0003\u0013\u0005a\u0002\u0001g\u0002R\u0007\u0005)\u0001!K\u0007\u0005\u0007\"AY!\u0004\u0003\n\u0005%\tA\u0004\u0001\r\u00079\r\n6aA\u0007\u0003\t\u001bAq!\u000b\t\u0005\u0004rAy!\u0004\u0005\n\u0005%\tA\u0004A\u0005\u0003\u0013\u0005a\n\u0001$\u0001\u0019\u0011q\t\u0001%A)\u0004\u0003\u0015\u0001\u0011f\u0002\u0003B\u0011!\u0011Q\"\u0001M\u0003#\u000e\tQ\u0001A\u0015\u000b\t\u0005C\u0001\u0002B\u0007\u0005\u0013\tI\u0011\u0001(\u0001\u0019\nE\u001b\u0011!\u0002\u0001"}, strings={"Lorg/jetbrains/kotlin/jps/incremental/storage/LazyStorage;", "K", "V", "", "storageFile", "Ljava/io/File;", "keyDescriptor", "Lcom/intellij/util/io/KeyDescriptor;", "valueExternalizer", "Lcom/intellij/util/io/DataExternalizer;", "(Ljava/io/File;Lcom/intellij/util/io/KeyDescriptor;Lcom/intellij/util/io/DataExternalizer;)V", "keys", "", "getKeys", "()Ljava/util/Collection;", "storage", "Lcom/intellij/util/io/PersistentHashMap;", "append", "", "key", "Lkotlin/Function1;", "Ljava/io/DataOutput;", "(Ljava/lang/Object;Lkotlin/jvm/functions/Function1;)V", "clean", "close", "contains", "", "(Ljava/lang/Object;)Z", "createMap", "flush", "memoryCachesOnly", "get", "(Ljava/lang/Object;)Ljava/lang/Object;", "getStorageIfExists", "getStorageOrCreateNew", "remove", "(Ljava/lang/Object;)V", "set", "value", "(Ljava/lang/Object;Ljava/lang/Object;)V"}, moduleName="jps-plugin")
public final class LazyStorage<K, V> {
    private volatile PersistentHashMap<K, V> storage;
    private final File storageFile;
    private final KeyDescriptor<K> keyDescriptor;
    private final DataExternalizer<V> valueExternalizer;

    private final synchronized PersistentHashMap<K, V> getStorageIfExists() {
        if (this.storage != null) {
            return this.storage;
        }
        if (this.storageFile.exists()) {
            this.storage = this.createMap();
            return this.storage;
        }
        return null;
    }

    private final synchronized PersistentHashMap<K, V> getStorageOrCreateNew() {
        if (this.storage == null) {
            this.storage = this.createMap();
        }
        PersistentHashMap<K, V> persistentHashMap = this.storage;
        if (persistentHashMap == null) {
            Intrinsics.throwNpe();
        }
        return persistentHashMap;
    }

    @NotNull
    public final Collection<K> getKeys() {
        Object object = this.getStorageIfExists();
        if (object == null || (object = object.getAllKeysWithExistingMapping()) == null) {
            object = CollectionsKt.listOf();
        }
        return object;
    }

    public final boolean contains(K key) {
        PersistentHashMap<K, V> persistentHashMap = this.getStorageIfExists();
        return persistentHashMap != null ? persistentHashMap.containsMapping(key) : false;
    }

    @Nullable
    public final V get(K key) {
        PersistentHashMap<K, V> persistentHashMap = this.getStorageIfExists();
        return (V)(persistentHashMap != null ? persistentHashMap.get(key) : null);
    }

    public final void set(K key, V value) {
        this.getStorageOrCreateNew().put(key, value);
    }

    public final void remove(K key) {
        Unit unit;
        PersistentHashMap<K, V> persistentHashMap = this.getStorageIfExists();
        if (persistentHashMap != null) {
            persistentHashMap.remove(key);
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
    }

    public final void append(K key, @NotNull Function1<? super DataOutput, Unit> append) {
        Intrinsics.checkParameterIsNotNull(append, (String)"append");
        Function1<? super DataOutput, Unit> function1 = append;
        this.getStorageOrCreateNew().appendData(key, (PersistentHashMap.ValueDataAppender)(function1 == null ? null : new LazyStorageKt$sam$ValueDataAppender$5847c6dd(function1)));
    }

    public final synchronized void clean() {
        try {
            Unit unit;
            PersistentHashMap<K, V> persistentHashMap = this.storage;
            if (persistentHashMap != null) {
                persistentHashMap.close();
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        PersistentHashMap.deleteFilesStartingWith((File)this.storageFile);
        this.storage = null;
    }

    public final synchronized void flush(boolean memoryCachesOnly) {
        PersistentHashMap<K, V> persistentHashMap = this.storage;
        if (persistentHashMap == null) {
            return;
        }
        PersistentHashMap<K, V> existingStorage = persistentHashMap;
        if (memoryCachesOnly) {
            if (existingStorage.isDirty()) {
                existingStorage.dropMemoryCaches();
            }
        } else {
            existingStorage.force();
        }
    }

    public final synchronized void close() {
        Unit unit;
        PersistentHashMap<K, V> persistentHashMap = this.storage;
        if (persistentHashMap != null) {
            persistentHashMap.close();
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
    }

    private final PersistentHashMap<K, V> createMap() {
        return new PersistentHashMap(this.storageFile, this.keyDescriptor, this.valueExternalizer);
    }

    public LazyStorage(@NotNull File storageFile, @NotNull KeyDescriptor<K> keyDescriptor, @NotNull DataExternalizer<V> valueExternalizer) {
        Intrinsics.checkParameterIsNotNull((Object)storageFile, (String)"storageFile");
        Intrinsics.checkParameterIsNotNull(keyDescriptor, (String)"keyDescriptor");
        Intrinsics.checkParameterIsNotNull(valueExternalizer, (String)"valueExternalizer");
        this.storageFile = storageFile;
        this.keyDescriptor = keyDescriptor;
        this.valueExternalizer = valueExternalizer;
    }
}

