/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang;

import com.intellij.lang.ASTNode;
import com.intellij.lang.DefaultASTFactory;
import com.intellij.lang.LanguageASTFactory;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.source.CharTableImpl;
import com.intellij.psi.impl.source.CodeFragmentElement;
import com.intellij.psi.impl.source.DummyHolderElement;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.LazyParseableElement;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.PsiWhiteSpaceImpl;
import com.intellij.psi.tree.ICompositeElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.ILazyParseableElementType;
import com.intellij.psi.tree.ILeafElementType;
import com.intellij.util.CharTable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ASTFactory {
    private static final CharTable WHITESPACES = new CharTableImpl();

    @Nullable
    public LazyParseableElement createLazy(ILazyParseableElementType type2, CharSequence text) {
        return null;
    }

    @Nullable
    public CompositeElement createComposite(IElementType type2) {
        return null;
    }

    @Nullable
    public LeafElement createLeaf(@NotNull IElementType type2, @NotNull CharSequence text) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/ASTFactory", "createLeaf"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/lang/ASTFactory", "createLeaf"));
        }
        return null;
    }

    @NotNull
    public static LazyParseableElement lazy(@NotNull ILazyParseableElementType type2, CharSequence text) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/ASTFactory", "lazy"));
        }
        ASTNode node = type2.createNode(text);
        if (node != null) {
            LazyParseableElement lazyParseableElement = (LazyParseableElement)node;
            if (lazyParseableElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ASTFactory", "lazy"));
            }
            return lazyParseableElement;
        }
        if (type2 == TokenType.CODE_FRAGMENT) {
            CodeFragmentElement codeFragmentElement = new CodeFragmentElement(null);
            if (codeFragmentElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ASTFactory", "lazy"));
            }
            return codeFragmentElement;
        }
        if (type2 == TokenType.DUMMY_HOLDER) {
            DummyHolderElement dummyHolderElement = new DummyHolderElement(text);
            if (dummyHolderElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ASTFactory", "lazy"));
            }
            return dummyHolderElement;
        }
        LazyParseableElement customLazy = ASTFactory.factory(type2).createLazy(type2, text);
        LazyParseableElement lazyParseableElement = customLazy != null ? customLazy : DefaultFactoryHolder.DEFAULT.createLazy(type2, text);
        if (lazyParseableElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ASTFactory", "lazy"));
        }
        return lazyParseableElement;
    }

    @NotNull
    public static CompositeElement composite(@NotNull IElementType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/ASTFactory", "composite"));
        }
        if (type2 instanceof ICompositeElementType) {
            CompositeElement compositeElement = (CompositeElement)((ICompositeElementType)((Object)type2)).createCompositeNode();
            if (compositeElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ASTFactory", "composite"));
            }
            return compositeElement;
        }
        CompositeElement customComposite = ASTFactory.factory(type2).createComposite(type2);
        CompositeElement compositeElement = customComposite != null ? customComposite : DefaultFactoryHolder.DEFAULT.createComposite(type2);
        if (compositeElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ASTFactory", "composite"));
        }
        return compositeElement;
    }

    @NotNull
    public static LeafElement leaf(@NotNull IElementType type2, @NotNull CharSequence text) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/ASTFactory", "leaf"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/lang/ASTFactory", "leaf"));
        }
        if (type2 == TokenType.WHITE_SPACE) {
            PsiWhiteSpaceImpl psiWhiteSpaceImpl = new PsiWhiteSpaceImpl(text);
            if (psiWhiteSpaceImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ASTFactory", "leaf"));
            }
            return psiWhiteSpaceImpl;
        }
        if (type2 instanceof ILeafElementType) {
            LeafElement leafElement = (LeafElement)((ILeafElementType)((Object)type2)).createLeafNode(text);
            if (leafElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ASTFactory", "leaf"));
            }
            return leafElement;
        }
        LeafElement customLeaf = ASTFactory.factory(type2).createLeaf(type2, text);
        LeafElement leafElement = customLeaf != null ? customLeaf : DefaultFactoryHolder.DEFAULT.createLeaf(type2, text);
        if (leafElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ASTFactory", "leaf"));
        }
        return leafElement;
    }

    @Nullable
    private static ASTFactory factory(IElementType type2) {
        return (ASTFactory)LanguageASTFactory.INSTANCE.forLanguage(type2.getLanguage());
    }

    @NotNull
    public static LeafElement whitespace(CharSequence text) {
        PsiWhiteSpaceImpl w = new PsiWhiteSpaceImpl(WHITESPACES.intern(text));
        CodeEditUtil.setNodeGenerated(w, true);
        PsiWhiteSpaceImpl psiWhiteSpaceImpl = w;
        if (psiWhiteSpaceImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ASTFactory", "whitespace"));
        }
        return psiWhiteSpaceImpl;
    }

    public static class DefaultFactoryHolder {
        public static final ASTFactory DEFAULT = (ASTFactory)((Object)ServiceManager.getService(DefaultASTFactory.class));
    }
}

