/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.bridges.ImplKt;
import org.jetbrains.kotlin.codegen.ClassBuilder;
import org.jetbrains.kotlin.codegen.CodegenUtilKt;
import org.jetbrains.kotlin.codegen.MemberCodegen;
import org.jetbrains.kotlin.codegen.OwnerKind;
import org.jetbrains.kotlin.codegen.binding.CodegenBinding;
import org.jetbrains.kotlin.codegen.context.ClassContext;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorUtils;

public abstract class ClassBodyCodegen
extends MemberCodegen<KtClassOrObject> {
    protected final KtClassOrObject myClass;
    protected final OwnerKind kind;
    protected final ClassDescriptor descriptor;

    protected ClassBodyCodegen(@NotNull KtClassOrObject myClass, @NotNull ClassContext context, @NotNull ClassBuilder v, @NotNull GenerationState state2, @Nullable MemberCodegen<?> parentCodegen) {
        if (myClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "myClass", "org/jetbrains/kotlin/codegen/ClassBodyCodegen", "<init>"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/codegen/ClassBodyCodegen", "<init>"));
        }
        if (v == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/kotlin/codegen/ClassBodyCodegen", "<init>"));
        }
        if (state2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/kotlin/codegen/ClassBodyCodegen", "<init>"));
        }
        super(state2, parentCodegen, context, myClass, v);
        this.myClass = myClass;
        this.kind = context.getContextKind();
        this.descriptor = this.bindingContext.get(BindingContext.CLASS, myClass);
    }

    @Override
    protected void generateBody() {
        ArrayList<KtObjectDeclaration> companions = new ArrayList<KtObjectDeclaration>();
        if (this.kind != OwnerKind.DEFAULT_IMPLS) {
            for (KtDeclaration declaration : this.myClass.getDeclarations()) {
                if (!ClassBodyCodegen.shouldProcessFirst(declaration)) continue;
                if (declaration instanceof KtObjectDeclaration && ((KtObjectDeclaration)declaration).isCompanion()) {
                    companions.add((KtObjectDeclaration)declaration);
                    CodegenUtilKt.populateCompanionBackingFieldNamesToOuterContextIfNeeded((KtObjectDeclaration)declaration, this.context, this.state);
                    continue;
                }
                this.generateDeclaration(declaration);
            }
        }
        for (KtDeclaration declaration : this.myClass.getDeclarations()) {
            if (ClassBodyCodegen.shouldProcessFirst(declaration)) continue;
            this.generateDeclaration(declaration);
        }
        this.generatePrimaryConstructorProperties();
        this.generateConstructors();
        this.generateDefaultImplsIfNeeded();
        for (KtObjectDeclaration companion : companions) {
            this.generateDeclaration(companion);
        }
        if (!DescriptorUtils.isInterface(this.descriptor)) {
            for (DeclarationDescriptor memberDescriptor : DescriptorUtils.getAllDescriptors(this.descriptor.getDefaultType().getMemberScope())) {
                PropertySetterDescriptor setter;
                CallableMemberDescriptor member;
                if (!(memberDescriptor instanceof CallableMemberDescriptor) || (member = (CallableMemberDescriptor)memberDescriptor).getKind().isReal() || ImplKt.findTraitImplementation(member) != null) continue;
                if (member instanceof FunctionDescriptor) {
                    this.functionCodegen.generateBridges((FunctionDescriptor)member);
                    continue;
                }
                if (!(member instanceof PropertyDescriptor)) continue;
                PropertyGetterDescriptor getter = ((PropertyDescriptor)member).getGetter();
                if (getter != null) {
                    this.functionCodegen.generateBridges(getter);
                }
                if ((setter = ((PropertyDescriptor)member).getSetter()) == null) continue;
                this.functionCodegen.generateBridges(setter);
            }
        }
    }

    protected void generateConstructors() {
    }

    protected void generateDefaultImplsIfNeeded() {
    }

    private static boolean shouldProcessFirst(KtDeclaration declaration) {
        return !(declaration instanceof KtProperty) && !(declaration instanceof KtNamedFunction);
    }

    protected void generateDeclaration(KtDeclaration declaration) {
        if (declaration instanceof KtProperty || declaration instanceof KtNamedFunction) {
            this.genFunctionOrProperty(declaration);
        } else if (declaration instanceof KtClassOrObject) {
            if (declaration instanceof KtEnumEntry && !CodegenBinding.enumEntryNeedSubclass(this.bindingContext, (KtEnumEntry)declaration)) {
                return;
            }
            this.genClassOrObject((KtClassOrObject)declaration);
        }
    }

    private void generatePrimaryConstructorProperties() {
        boolean isAnnotation = this.descriptor.getKind() == ClassKind.ANNOTATION_CLASS;
        for (KtParameter p : this.getPrimaryConstructorParameters()) {
            PropertyDescriptor propertyDescriptor;
            if (!p.hasValOrVar() || (propertyDescriptor = this.bindingContext.get(BindingContext.PRIMARY_CONSTRUCTOR_PARAMETER, p)) == null) continue;
            if (!isAnnotation) {
                this.propertyCodegen.generatePrimaryConstructorProperty(p, propertyDescriptor);
                continue;
            }
            this.propertyCodegen.generateConstructorPropertyAsMethodForAnnotationClass(p, propertyDescriptor);
        }
    }

    @NotNull
    protected List<KtParameter> getPrimaryConstructorParameters() {
        if (this.myClass instanceof KtClass) {
            List<KtParameter> list = ((KtClass)this.myClass).getPrimaryConstructorParameters();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ClassBodyCodegen", "getPrimaryConstructorParameters"));
            }
            return list;
        }
        List<KtParameter> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ClassBodyCodegen", "getPrimaryConstructorParameters"));
        }
        return list;
    }

    @Override
    @Nullable
    protected ClassDescriptor classForInnerClassRecord() {
        return DescriptorUtils.isTopLevelDeclaration(this.descriptor) ? null : this.descriptor;
    }
}

