/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.gfxtrace.controllers;

import com.android.tools.idea.editors.gfxtrace.GfxTraceEditor;
import com.android.tools.idea.editors.gfxtrace.controllers.GfxController;
import com.android.tools.idea.editors.gfxtrace.controllers.ImageFetcher;
import com.android.tools.idea.editors.gfxtrace.controllers.modeldata.ScrubberLabelData;
import com.android.tools.idea.editors.gfxtrace.renderers.ScrubberCellRenderer;
import com.android.tools.idea.editors.gfxtrace.rpc.AtomGroup;
import com.android.tools.idea.editors.gfxtrace.rpc.Client;
import com.android.tools.idea.editors.gfxtrace.rpc.Hierarchy;
import com.android.tools.idea.editors.gfxtrace.schema.AtomReader;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.ui.StatusText;
import java.awt.Dimension;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScrubberController
implements ScrubberCellRenderer.DimensionChangeListener,
GfxController {
    @NotNull
    private static final Logger LOG = Logger.getInstance(ScrubberController.class);
    @NotNull
    private final GfxTraceEditor myEditor;
    @NotNull
    private final JBScrollPane myPane;
    @NotNull
    private final JBList myList;
    @NotNull
    private ScrubberCellRenderer myScrubberCellRenderer;
    @Nullable
    private List<ScrubberLabelData> myFrameData;

    public ScrubberController(@NotNull GfxTraceEditor editor, @NotNull JBScrollPane scrubberScrollPane, @NotNull JBList scrubberComponent) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/android/tools/idea/editors/gfxtrace/controllers/ScrubberController", "<init>"));
        }
        if (scrubberScrollPane == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scrubberScrollPane", "com/android/tools/idea/editors/gfxtrace/controllers/ScrubberController", "<init>"));
        }
        if (scrubberComponent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scrubberComponent", "com/android/tools/idea/editors/gfxtrace/controllers/ScrubberController", "<init>"));
        }
        this.myEditor = editor;
        this.myPane = scrubberScrollPane;
        this.myList = scrubberComponent;
        this.myScrubberCellRenderer = new ScrubberCellRenderer();
        this.myScrubberCellRenderer.addDimensionChangeListener(this);
        Dimension minCellDimension = this.myScrubberCellRenderer.getCellDimensions();
        this.myList.setExpandableItemsEnabled(false);
        this.myList.setMinimumSize(minCellDimension);
        this.myList.setVisibleRowCount(1);
        this.myList.getEmptyText().setText("Select a capture");
        this.resize(minCellDimension);
    }

    @Nullable
    public List<ScrubberLabelData> prepareData(@NotNull Hierarchy hierarchy, @NotNull AtomReader atomReader) {
        if (hierarchy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hierarchy", "com/android/tools/idea/editors/gfxtrace/controllers/ScrubberController", "prepareData"));
        }
        if (atomReader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "atomReader", "com/android/tools/idea/editors/gfxtrace/controllers/ScrubberController", "prepareData"));
        }
        try {
            AtomGroup root = hierarchy.getRoot();
            ArrayList<ScrubberLabelData> generatedList = new ArrayList<ScrubberLabelData>(root.getSubGroups().length);
            int frameCount = 0;
            for (AtomGroup frame : root.getSubGroups()) {
                assert (frame.getRange().getCount() > 0L);
                long atomId = frame.getRange().getFirst() + frame.getRange().getCount() - 1L;
                if (!atomReader.read((long)atomId).info.getIsEndOfFrame()) continue;
                ScrubberLabelData frameData = new ScrubberLabelData(atomId, frame, Integer.toString(frameCount++), this.myScrubberCellRenderer.getDefaultIcon());
                generatedList.add(frameData);
            }
            return generatedList;
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    @Override
    public void notifyDimensionChanged(@NotNull Dimension newDimension) {
        if (newDimension == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newDimension", "com/android/tools/idea/editors/gfxtrace/controllers/ScrubberController", "notifyDimensionChanged"));
        }
        this.resize(newDimension);
        this.myEditor.notifyDimensionChanged(newDimension);
    }

    @Override
    public void startLoad() {
        this.myList.getEmptyText().setText("");
    }

    @Override
    public void commitData(@NotNull GfxController.GfxContextChangeState state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/android/tools/idea/editors/gfxtrace/controllers/ScrubberController", "commitData"));
        }
        this.myFrameData = state.myScrubberList;
    }

    public void populateUi(@NotNull Client client) {
        if (client == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "client", "com/android/tools/idea/editors/gfxtrace/controllers/ScrubberController", "populateUi"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        assert (this.myFrameData != null);
        assert (this.myEditor.getContext() != null);
        assert (this.myEditor.getCaptureId() != null);
        if (this.myEditor.getDeviceId() == null) {
            return;
        }
        DefaultListModel<ScrubberLabelData> model = new DefaultListModel<ScrubberLabelData>();
        model.ensureCapacity(this.myFrameData.size());
        for (ScrubberLabelData data : this.myFrameData) {
            model.addElement(data);
        }
        this.setModel(model);
        if (this.myFrameData.size() == 0) {
            this.myList.getEmptyText().setText(StatusText.DEFAULT_EMPTY_TEXT);
        }
        ImageFetcher imageFetcher = new ImageFetcher(client);
        imageFetcher.prepareFetch(this.myEditor.getDeviceId(), this.myEditor.getCaptureId(), this.myEditor.getContext());
        this.myScrubberCellRenderer.setup(imageFetcher);
        this.myList.setCellRenderer((ListCellRenderer)this.myScrubberCellRenderer);
    }

    @Nullable
    public AtomGroup getFrameSelectionReference() {
        ScrubberLabelData data = this.getSelectedLabelData();
        if (data == null) {
            return null;
        }
        return data.getHierarchyReference();
    }

    public void selectFrame(long atomId) {
        assert (this.myFrameData != null);
        int i = 0;
        for (ScrubberLabelData data : this.myFrameData) {
            AtomGroup group = data.getHierarchyReference();
            if (atomId >= group.getRange().getFirst() && atomId < group.getRange().getFirst() + group.getRange().getCount()) {
                this.select(i);
                break;
            }
            ++i;
        }
    }

    @Override
    public void clear() {
        this.myScrubberCellRenderer.clearState();
        this.myList.setModel(new DefaultListModel());
        this.myList.setCellRenderer((ListCellRenderer)new DefaultListCellRenderer());
    }

    @Override
    public void clearCache() {
        this.myScrubberCellRenderer.clearCache();
        this.myList.clearSelection();
    }

    private void resize(@NotNull Dimension newDimensions) {
        if (newDimensions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newDimensions", "com/android/tools/idea/editors/gfxtrace/controllers/ScrubberController", "resize"));
        }
        this.myList.setFixedCellWidth(newDimensions.width);
        this.myList.setFixedCellHeight(newDimensions.height);
        newDimensions.height += this.myPane.getHorizontalScrollBar().getUI().getPreferredSize((JComponent)this.myPane).height;
        this.myPane.setMinimumSize(newDimensions);
    }

    private void setModel(@NotNull ListModel model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/android/tools/idea/editors/gfxtrace/controllers/ScrubberController", "setModel"));
        }
        this.myList.setModel(model);
    }

    @Nullable
    private ScrubberLabelData getSelectedLabelData() {
        Object selectedValue = this.myList.getSelectedValue();
        if (selectedValue != null) {
            return (ScrubberLabelData)selectedValue;
        }
        return null;
    }

    private void select(int index) {
        this.myList.setSelectedIndex(index);
        this.myList.scrollRectToVisible(this.myList.getCellBounds(index, index));
    }
}

