/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme.attributes;

import com.android.tools.idea.editors.theme.ThemeEditorContext;
import com.android.tools.idea.editors.theme.ThemeEditorUtils;
import com.android.tools.idea.editors.theme.datamodels.EditedStyleItem;
import com.intellij.codeInsight.documentation.DocumentationComponent;
import com.intellij.codeInsight.documentation.DocumentationManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.PsiElement;
import com.intellij.ui.awt.RelativePoint;
import java.awt.Component;
import java.awt.Point;
import javax.swing.JComponent;
import javax.swing.JTable;
import org.jetbrains.annotations.NotNull;

public class ShowJavadocAction
extends AnAction {
    private static final Point ORIGIN = new Point(0, 0);
    protected final JTable myAttributesTable;
    private final ThemeEditorContext myContext;

    public ShowJavadocAction(@NotNull JTable attributesTable, @NotNull ThemeEditorContext context) {
        if (attributesTable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributesTable", "com/android/tools/idea/editors/theme/attributes/ShowJavadocAction", "<init>"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/android/tools/idea/editors/theme/attributes/ShowJavadocAction", "<init>"));
        }
        this.myAttributesTable = attributesTable;
        this.myContext = context;
    }

    public void actionPerformed(AnActionEvent e) {
        int selectedColumn;
        int selectedRow = this.myAttributesTable.getSelectedRow();
        Object selectedItem = this.myAttributesTable.getValueAt(selectedRow, selectedColumn = this.myAttributesTable.getSelectedColumn());
        if (selectedItem == null || !(selectedItem instanceof EditedStyleItem)) {
            return;
        }
        EditedStyleItem item = (EditedStyleItem)selectedItem;
        Project project = e.getProject();
        DocumentationManager documentationManager = DocumentationManager.getInstance((Project)project);
        final DocumentationComponent docComponent = new DocumentationComponent(documentationManager);
        String tooltip = ThemeEditorUtils.generateToolTipText(item.getItemResourceValue(), this.myContext.getCurrentThemeModule(), this.myContext.getConfiguration());
        docComponent.setText(tooltip, (PsiElement)e.getData(CommonDataKeys.PSI_FILE), true);
        JBPopup hint = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)docComponent, (JComponent)docComponent).setProject(project).setDimensionServiceKey(project, "javadoc.popup", false).setResizable(true).setMovable(true).setRequestFocus(true).setTitle(item.getName()).setCancelCallback((Computable)new Computable<Boolean>(){

            public Boolean compute() {
                Disposer.dispose((Disposable)docComponent);
                return Boolean.TRUE;
            }
        }).createPopup();
        docComponent.setHint(hint);
        Disposer.register((Disposable)hint, (Disposable)docComponent);
        hint.show(new RelativePoint((Component)this.myAttributesTable.getParent(), ORIGIN));
    }
}

