/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.android.designer.inspection;

import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.TextFormat;
import com.intellij.android.designer.model.RadViewComponent;
import com.intellij.android.designer.propertyTable.IXmlAttributeLocator;
import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.SuppressQuickFix;
import com.intellij.codeInspection.ex.DisableInspectionToolAction;
import com.intellij.codeInspection.ex.EditInspectionToolsSettingsAction;
import com.intellij.designer.model.ErrorInfo;
import com.intellij.designer.model.Property;
import com.intellij.designer.model.QuickFix;
import com.intellij.designer.model.RadComponent;
import com.intellij.designer.model.RadComponentVisitor;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.android.inspections.lint.AndroidLintExternalAnnotator;
import org.jetbrains.android.inspections.lint.AndroidLintInspectionBase;
import org.jetbrains.android.inspections.lint.AndroidLintQuickFix;
import org.jetbrains.android.inspections.lint.AndroidLintUtil;
import org.jetbrains.android.inspections.lint.AndroidQuickfixContexts;
import org.jetbrains.android.inspections.lint.ProblemData;
import org.jetbrains.android.inspections.lint.State;

public final class ErrorAnalyzer {
    public static void load(final Project project, final XmlFile xmlFile, RadComponent rootComponent, ProgressIndicator progress) {
        RadComponent.clearErrors((RadComponent)rootComponent);
        AndroidLintExternalAnnotator annotator = new AndroidLintExternalAnnotator();
        State state = annotator.collectInformation((PsiFile)xmlFile);
        if (state != null) {
            state = annotator.doAnnotate(state);
            for (ProblemData problemData : state.getProblems()) {
                HighlightDisplayKey key;
                AndroidLintInspectionBase inspection;
                Pair<AndroidLintInspectionBase, HighlightDisplayLevel> pair;
                Issue issue = problemData.getIssue();
                String message = TextFormat.RAW.convertTo(problemData.getMessage(), TextFormat.TEXT);
                TextRange range = problemData.getTextRange();
                if (range.getStartOffset() == range.getEndOffset() || (pair = AndroidLintUtil.getHighlighLevelAndInspection(project, issue, (PsiElement)xmlFile)) == null || (inspection = (AndroidLintInspectionBase)((Object)pair.getFirst())) == null || (key = HighlightDisplayKey.find((String)inspection.getShortName())) == null) continue;
                final PsiElement startElement = xmlFile.findElementAt(range.getStartOffset());
                final PsiElement endElement = xmlFile.findElementAt(range.getEndOffset() - 1);
                if (startElement == null || endElement == null || inspection.isSuppressedFor(startElement)) continue;
                Pair<RadComponent, String> componentInfo = ErrorAnalyzer.findComponent(rootComponent, startElement);
                ErrorInfo errorInfo = new ErrorInfo(message, (String)componentInfo.second, (HighlightDisplayLevel)pair.getSecond());
                RadComponent.addError((RadComponent)((RadComponent)componentInfo.first), (ErrorInfo)errorInfo);
                Icon icon = errorInfo.getLevel() == HighlightDisplayLevel.ERROR ? AllIcons.Actions.QuickfixBulb : AllIcons.Actions.IntentionBulb;
                List designerFixes = errorInfo.getQuickFixes();
                for (final AndroidLintQuickFix androidLintQuickFix : inspection.getQuickFixes(startElement, endElement, message)) {
                    if (!androidLintQuickFix.isApplicable(startElement, endElement, AndroidQuickfixContexts.DesignerContext.TYPE)) continue;
                    designerFixes.add(new QuickFix(androidLintQuickFix.getName(), icon){

                        public void run() {
                            androidLintQuickFix.apply(startElement, endElement, AndroidQuickfixContexts.DesignerContext.getInstance());
                        }
                    });
                }
                for (AndroidLintQuickFix androidLintQuickFix : inspection.getIntentions(startElement, endElement)) {
                    designerFixes.add(new QuickFix(androidLintQuickFix.getText(), icon, (IntentionAction)androidLintQuickFix, project, xmlFile){
                        final /* synthetic */ IntentionAction val$intention;
                        final /* synthetic */ Project val$project;
                        final /* synthetic */ XmlFile val$xmlFile;
                        {
                            this.val$intention = intentionAction;
                            this.val$project = project;
                            this.val$xmlFile = xmlFile;
                            super(x0, x1);
                        }

                        public void run() {
                            this.val$intention.invoke(this.val$project, null, (PsiFile)this.val$xmlFile);
                        }
                    });
                }
                final DisableInspectionToolAction disableAction = new DisableInspectionToolAction(key);
                designerFixes.add(new QuickFix("Disable inspection", disableAction.getIcon(0)){

                    public void run() {
                        disableAction.invoke(project, null, (PsiFile)xmlFile);
                    }
                });
                final EditInspectionToolsSettingsAction editSettingsAction = new EditInspectionToolsSettingsAction(key);
                designerFixes.add(new QuickFix("Edit '" + inspection.getDisplayName() + "' inspection settings", editSettingsAction.getIcon(0)){

                    public void run() {
                        editSettingsAction.invoke(project, null, (PsiFile)xmlFile);
                    }
                });
                SuppressQuickFix[] suppressActions = inspection.getBatchSuppressActions(startElement);
                if (suppressActions == null) continue;
                for (final SuppressQuickFix action : suppressActions) {
                    Icon icon1 = action instanceof Iconable ? ((Iconable)action).getIcon(0) : null;
                    designerFixes.add(new QuickFix(action.getName(), icon1){

                        public void run() {
                            action.applyFix(project, (CommonProblemDescriptor)InspectionManager.getInstance((Project)project).createProblemDescriptor(startElement, "", (LocalQuickFix)null, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, false));
                        }
                    });
                }
            }
        }
    }

    private static Pair<RadComponent, String> findComponent(final RadComponent rootComponent, PsiElement element) {
        final Pair<XmlTag, XmlAttribute> tagInfo = ErrorAnalyzer.extractTag(element);
        if (tagInfo.first == null) {
            return new Pair((Object)rootComponent, null);
        }
        final RadComponent[] result = new RadComponent[]{rootComponent};
        rootComponent.accept(new RadComponentVisitor(){

            public boolean visit(RadComponent component) {
                if (tagInfo.first == ((RadViewComponent)component).getTag()) {
                    result[0] = component == rootComponent && rootComponent.getChildren().size() == 1 ? (RadComponent)rootComponent.getChildren().get(0) : component;
                    return false;
                }
                return true;
            }

            public void endVisit(RadComponent component) {
            }
        }, true);
        String propertyName = null;
        if (tagInfo.second != null && result[0] != rootComponent) {
            RadViewComponent component = (RadViewComponent)result[0];
            for (Property property : component.getProperties()) {
                if (!((IXmlAttributeLocator)property).checkAttribute(component, (XmlAttribute)tagInfo.second)) continue;
                propertyName = property.getName();
                break;
            }
        }
        return Pair.create((Object)result[0], propertyName);
    }

    private static Pair<XmlTag, XmlAttribute> extractTag(PsiElement element) {
        XmlTag tag = null;
        XmlAttribute attribute = null;
        while (element != null) {
            if (element instanceof XmlAttribute) {
                attribute = (XmlAttribute)element;
            }
            if (element instanceof XmlTag) {
                tag = (XmlTag)element;
                break;
            }
            element = element.getParent();
        }
        return Pair.create(tag, attribute);
    }
}

