/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.tools.idea.run.CloudConfiguration;
import com.google.common.collect.Maps;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import java.awt.Color;
import java.awt.Font;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.run.AndroidRunConfigurationBase;
import org.jetbrains.annotations.NotNull;

public class CloudProjectIdLabel
extends JBLabel {
    private static final String CLOUD_PROJECT_PROMPT = "Please select a project...";
    private final CloudConfiguration.Kind myConfigurationKind;
    private AndroidRunConfigurationBase myCurrentConfiguration;
    private Module myCurrentModule;
    private static Map<CloudConfiguration.Kind, String> myLastChosenProjectIdPerKind = Maps.newHashMapWithExpectedSize((int)5);
    private static Map<AndroidRunConfigurationBase, Map<Pair<CloudConfiguration.Kind, Module>, String>> myProjectByConfigurationAndModuleCache = Maps.newHashMapWithExpectedSize((int)5);

    public CloudProjectIdLabel(@NotNull CloudConfiguration.Kind configurationKind) {
        if (configurationKind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurationKind", "com/android/tools/idea/run/CloudProjectIdLabel", "<init>"));
        }
        this.myConfigurationKind = configurationKind;
        this.updateCloudProjectId(CLOUD_PROJECT_PROMPT);
    }

    public boolean isProjectSpecified() {
        return !this.getText().isEmpty() && !this.getText().equals(CLOUD_PROJECT_PROMPT);
    }

    public void updateCloudProjectId(@NotNull String cloudProjectId) {
        if (cloudProjectId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cloudProjectId", "com/android/tools/idea/run/CloudProjectIdLabel", "updateCloudProjectId"));
        }
        if (cloudProjectId.isEmpty() || cloudProjectId.equals(CLOUD_PROJECT_PROMPT)) {
            Font currentFont = this.getFont();
            this.setFont(new Font("Dialog", 1, currentFont.getSize()));
            this.setForeground((Color)JBColor.RED);
            this.setText(CLOUD_PROJECT_PROMPT);
        } else {
            Font currentFont = this.getFont();
            this.setFont(new Font("Dialog", 0, currentFont.getSize()));
            this.setForeground((Color)JBColor.BLACK);
            this.setText(cloudProjectId);
        }
        this.rememberChosenProjectId();
    }

    public void setFacet(@NotNull AndroidFacet facet) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/idea/run/CloudProjectIdLabel", "setFacet"));
        }
        this.myCurrentModule = facet.getModule();
        this.restoreChosenProjectId();
    }

    public void setConfiguration(@NotNull AndroidRunConfigurationBase configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/android/tools/idea/run/CloudProjectIdLabel", "setConfiguration"));
        }
        this.myCurrentConfiguration = configuration;
    }

    private void rememberChosenProjectId() {
        if (this.isProjectSpecified()) {
            myLastChosenProjectIdPerKind.put(this.myConfigurationKind, this.getText());
        }
        if (this.myCurrentConfiguration == null || this.myCurrentModule == null) {
            return;
        }
        HashMap projectByModuleCache = myProjectByConfigurationAndModuleCache.get((Object)this.myCurrentConfiguration);
        if (projectByModuleCache == null) {
            projectByModuleCache = Maps.newHashMapWithExpectedSize((int)5);
            myProjectByConfigurationAndModuleCache.put(this.myCurrentConfiguration, projectByModuleCache);
        }
        projectByModuleCache.put(Pair.create((Object)((Object)this.myConfigurationKind), (Object)this.myCurrentModule), this.getText());
    }

    public void restoreChosenProjectId() {
        String projectId;
        if (this.myCurrentConfiguration == null || this.myCurrentModule == null) {
            String lastChosenProjectId = myLastChosenProjectIdPerKind.get((Object)this.myConfigurationKind);
            if (lastChosenProjectId != null) {
                this.updateCloudProjectId(lastChosenProjectId);
            }
            return;
        }
        Map<Pair<CloudConfiguration.Kind, Module>, String> projectByModuleCache = myProjectByConfigurationAndModuleCache.get((Object)this.myCurrentConfiguration);
        if (projectByModuleCache != null && (projectId = projectByModuleCache.get(Pair.create((Object)((Object)this.myConfigurationKind), (Object)this.myCurrentModule))) != null) {
            this.updateCloudProjectId(projectId);
        }
    }
}

