/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sdk;

import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.repository.descriptors.PkgType;
import com.android.sdklib.repository.local.LocalPkgInfo;
import com.android.tools.idea.gradle.project.GradleProjectImporter;
import com.android.tools.idea.gradle.util.LocalProperties;
import com.android.tools.idea.gradle.util.Projects;
import com.android.tools.idea.sdk.Jdks;
import com.android.tools.idea.sdk.SdkPaths;
import com.android.tools.idea.startup.AndroidStudioSpecificInitializer;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.intellij.ide.impl.NewProjectUtil;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.ui.UIUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.android.actions.RunAndroidSdkManagerAction;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.android.sdk.AndroidSdkAdditionalData;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class IdeSdks {
    @NonNls
    public static final String MAC_JDK_CONTENT_PATH = "/Contents/Home";
    @NonNls
    private static final String ANDROID_SDK_PATH_KEY = "android.sdk.path";
    private static final Logger LOG = Logger.getInstance(IdeSdks.class);
    private static final String ERROR_DIALOG_TITLE = "Project SDK Update";

    private IdeSdks() {
    }

    @Nullable
    public static File getAndroidSdkPath() {
        File candidate;
        String sdkHome = null;
        Sdk sdk = IdeSdks.getFirstAndroidSdk();
        if (sdk != null) {
            sdkHome = sdk.getHomePath();
        }
        if (sdkHome != null) {
            return new File(FileUtil.toSystemDependentName((String)sdkHome));
        }
        PropertiesComponent component = PropertiesComponent.getInstance((Project)ProjectManager.getInstance().getDefaultProject());
        String sdkPath = component.getValue(ANDROID_SDK_PATH_KEY);
        if (sdkPath != null && IdeSdks.isValidAndroidSdkPath(candidate = new File(sdkPath))) {
            return candidate;
        }
        return null;
    }

    public static File getAndroidNdkPath() {
        AndroidSdkData data = AndroidSdkUtils.tryToChooseAndroidSdk();
        if (data == null) {
            return null;
        }
        LocalPkgInfo[] ndk = data.getLocalSdk().getPkgsInfos(PkgType.PKG_NDK);
        if (ndk.length == 0) {
            return null;
        }
        return ndk[0].getLocalDir();
    }

    @Nullable
    public static File getJdkPath() {
        List<Sdk> androidSdks = IdeSdks.getEligibleAndroidSdks();
        if (androidSdks.isEmpty()) {
            String jdkPath;
            Sdk jdk = Jdks.chooseOrCreateJavaSdk();
            if (jdk != null && (jdkPath = jdk.getHomePath()) != null) {
                return new File(FileUtil.toSystemDependentName((String)jdkPath));
            }
        } else {
            for (Sdk sdk : androidSdks) {
                String jdkHomePath;
                AndroidSdkAdditionalData data = AndroidSdkUtils.getAndroidSdkAdditionalData(sdk);
                assert (data != null);
                Sdk jdk = data.getJavaSdk();
                if (jdk == null || (jdkHomePath = jdk.getHomePath()) == null) continue;
                return new File(FileUtil.toSystemDependentName((String)jdkHomePath));
            }
        }
        return null;
    }

    @Nullable
    private static Sdk getFirstAndroidSdk() {
        List<Sdk> allAndroidSdks = IdeSdks.getEligibleAndroidSdks();
        if (!allAndroidSdks.isEmpty()) {
            return allAndroidSdks.get(0);
        }
        return null;
    }

    public static void setJdkPath(@NotNull File path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/android/tools/idea/sdk/IdeSdks", "setJdkPath"));
        }
        if (JavaSdk.checkForJdk((File)path)) {
            ApplicationManager.getApplication().assertWriteAccessAllowed();
            File canonicalPath = IdeSdks.resolvePath(path);
            Sdk chosenJdk = null;
            if (AndroidStudioSpecificInitializer.isAndroidStudio()) {
                List jdks = ProjectJdkTable.getInstance().getSdksOfType((SdkTypeId)JavaSdk.getInstance());
                Iterator iterator = jdks.iterator();
                while (iterator.hasNext()) {
                    Sdk jdk = (Sdk)iterator.next();
                    ProjectJdkTable.getInstance().removeJdk(jdk);
                }
            } else {
                for (Sdk jdk : ProjectJdkTable.getInstance().getSdksOfType((SdkTypeId)JavaSdk.getInstance())) {
                    if (!FileUtil.pathsEqual((String)jdk.getHomePath(), (String)canonicalPath.getPath())) continue;
                    chosenJdk = jdk;
                    break;
                }
            }
            if (chosenJdk == null) {
                if (canonicalPath.isDirectory()) {
                    Project[] openProjects;
                    chosenJdk = IdeSdks.createJdk(canonicalPath);
                    if (chosenJdk == null) {
                        throw new IllegalStateException("Failed to create IDEA JDK from '" + path.getPath() + "'");
                    }
                    IdeSdks.updateAndroidSdks(chosenJdk);
                    ProjectManager projectManager = (ProjectManager)ApplicationManager.getApplication().getComponent(ProjectManager.class);
                    for (Project project : openProjects = projectManager.getOpenProjects()) {
                        NewProjectUtil.applyJdkToProject((Project)project, (Sdk)chosenJdk);
                    }
                } else {
                    throw new IllegalStateException("The resolved path '" + canonicalPath.getPath() + "' was not found");
                }
            }
        }
    }

    @NotNull
    public static List<Sdk> setAndroidSdkPath(@NotNull File path, @Nullable Project currentProject) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/android/tools/idea/sdk/IdeSdks", "setAndroidSdkPath"));
        }
        List<Sdk> list = IdeSdks.setAndroidSdkPath(path, null, currentProject);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/sdk/IdeSdks", "setAndroidSdkPath"));
        }
        return list;
    }

    private static void updateAndroidSdks(@NotNull Sdk jdk) {
        if (jdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jdk", "com/android/tools/idea/sdk/IdeSdks", "updateAndroidSdks"));
        }
        for (Sdk sdk : AndroidSdkUtils.getAllAndroidSdks()) {
            AndroidSdkAdditionalData oldData = AndroidSdkUtils.getAndroidSdkAdditionalData(sdk);
            if (oldData == null) continue;
            oldData.setJavaSdk(jdk);
            SdkModificator modificator = sdk.getSdkModificator();
            modificator.setSdkAdditionalData((SdkAdditionalData)oldData);
            modificator.commitChanges();
        }
    }

    @NotNull
    public static List<Sdk> setAndroidSdkPath(@NotNull File path, @Nullable Sdk javaSdk, @Nullable Project currentProject) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/android/tools/idea/sdk/IdeSdks", "setAndroidSdkPath"));
        }
        if (IdeSdks.isValidAndroidSdkPath(path)) {
            ApplicationManager.getApplication().assertWriteAccessAllowed();
            if (currentProject != null && !currentProject.isDisposed()) {
                String sdkPath = FileUtil.toCanonicalPath((String)path.getAbsolutePath());
                PropertiesComponent.getInstance((Project)currentProject).setValue(ANDROID_SDK_PATH_KEY, sdkPath);
                if (!currentProject.isDefault()) {
                    PropertiesComponent component = PropertiesComponent.getInstance((Project)ProjectManager.getInstance().getDefaultProject());
                    component.setValue(ANDROID_SDK_PATH_KEY, sdkPath);
                }
            }
            AndroidSdkData oldSdkData = AndroidSdkData.getSdkData(path);
            AndroidSdkUtils.setSdkData(oldSdkData);
            ArrayList sdksToDelete = Lists.newArrayList();
            File resolved = IdeSdks.resolvePath(path);
            AndroidSdkData sdkData = AndroidSdkData.getSdkData(resolved, true);
            if (sdkData != null) {
                for (Sdk sdk : AndroidSdkUtils.getAllAndroidSdks()) {
                    if (!sdk.getName().startsWith("Android ")) continue;
                    sdksToDelete.add(sdk);
                }
            }
            for (Sdk sdk : sdksToDelete) {
                ProjectJdkTable.getInstance().removeJdk(sdk);
            }
            List<Sdk> sdks = IdeSdks.createAndroidSdkPerAndroidTarget(resolved, javaSdk);
            IdeSdks.updateLocalPropertiesAndSync(resolved, currentProject);
            List<Sdk> list = sdks;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/sdk/IdeSdks", "setAndroidSdkPath"));
            }
            return list;
        }
        List<Sdk> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/sdk/IdeSdks", "setAndroidSdkPath"));
        }
        return list;
    }

    public static boolean isValidAndroidSdkPath(@NotNull File path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/android/tools/idea/sdk/IdeSdks", "isValidAndroidSdkPath"));
        }
        return SdkPaths.validateAndroidSdk((File)path, (boolean)false).success;
    }

    @NotNull
    public static List<Sdk> createAndroidSdkPerAndroidTarget(@NotNull File androidSdkPath) {
        if (androidSdkPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "androidSdkPath", "com/android/tools/idea/sdk/IdeSdks", "createAndroidSdkPerAndroidTarget"));
        }
        List<Sdk> sdks = IdeSdks.createAndroidSdkPerAndroidTarget(androidSdkPath, null);
        RunAndroidSdkManagerAction.updateInWelcomePage(null);
        List<Sdk> list = sdks;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/sdk/IdeSdks", "createAndroidSdkPerAndroidTarget"));
        }
        return list;
    }

    @NotNull
    private static List<Sdk> createAndroidSdkPerAndroidTarget(@NotNull File androidSdkPath, @Nullable Sdk javaSdk) {
        if (androidSdkPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "androidSdkPath", "com/android/tools/idea/sdk/IdeSdks", "createAndroidSdkPerAndroidTarget"));
        }
        AndroidSdkData sdkData = AndroidSdkData.getSdkData(androidSdkPath);
        if (sdkData == null) {
            List<Sdk> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/sdk/IdeSdks", "createAndroidSdkPerAndroidTarget"));
            }
            return list;
        }
        IAndroidTarget[] targets = sdkData.getTargets();
        if (targets.length == 0) {
            List<Sdk> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/sdk/IdeSdks", "createAndroidSdkPerAndroidTarget"));
            }
            return list;
        }
        ArrayList sdks = Lists.newArrayList();
        Sdk ideSdk = javaSdk != null ? javaSdk : IdeSdks.getJdk();
        for (IAndroidTarget target : targets) {
            if (!target.isPlatform() || IdeSdks.doesIdeAndroidSdkExist(target)) continue;
            String name = AndroidSdkUtils.chooseNameForNewLibrary(target);
            Sdk sdk = AndroidSdkUtils.createNewAndroidPlatform(target, sdkData.getLocation().getPath(), name, ideSdk, true);
            sdks.add(sdk);
        }
        ArrayList arrayList = sdks;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/sdk/IdeSdks", "createAndroidSdkPerAndroidTarget"));
        }
        return arrayList;
    }

    private static boolean doesIdeAndroidSdkExist(@NotNull IAndroidTarget target) {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/android/tools/idea/sdk/IdeSdks", "doesIdeAndroidSdkExist"));
        }
        for (Sdk sdk : IdeSdks.getEligibleAndroidSdks()) {
            IAndroidTarget platformTarget = IdeSdks.getTarget(sdk);
            AndroidVersion version = target.getVersion();
            AndroidVersion existingVersion = platformTarget.getVersion();
            if (!existingVersion.equals((Object)version)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private static IAndroidTarget getTarget(@NotNull Sdk sdk) {
        if (sdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "com/android/tools/idea/sdk/IdeSdks", "getTarget"));
        }
        AndroidPlatform androidPlatform = AndroidPlatform.getInstance(sdk);
        assert (androidPlatform != null);
        IAndroidTarget iAndroidTarget = androidPlatform.getTarget();
        if (iAndroidTarget == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/sdk/IdeSdks", "getTarget"));
        }
        return iAndroidTarget;
    }

    private static void updateLocalPropertiesAndSync(final @NotNull File sdkHomePath, @Nullable Project currentProject) {
        LocalProperties localProperties;
        if (sdkHomePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdkHomePath", "com/android/tools/idea/sdk/IdeSdks", "updateLocalPropertiesAndSync"));
        }
        ProjectManager projectManager = (ProjectManager)ApplicationManager.getApplication().getComponent(ProjectManager.class);
        Project[] openProjects = projectManager.getOpenProjects();
        if (openProjects.length == 0) {
            return;
        }
        final ArrayList projectsToUpdateNames = Lists.newArrayList();
        ArrayList localPropertiesToUpdate = Lists.newArrayList();
        for (Project project : openProjects) {
            if (!Projects.isGradleProject(project)) continue;
            try {
                localProperties = new LocalProperties(project);
                if (FileUtil.filesEqual((File)sdkHomePath, (File)localProperties.getAndroidSdkPath())) continue;
                localPropertiesToUpdate.add(Pair.create((Object)project, (Object)localProperties));
                if (project.equals(currentProject)) continue;
                projectsToUpdateNames.add("'" + project.getName() + "'");
            }
            catch (IOException e) {
                IdeSdks.logAndShowErrorWhenUpdatingLocalProperties(project, e, "read", sdkHomePath);
            }
        }
        if (!localPropertiesToUpdate.isEmpty()) {
            if (!projectsToUpdateNames.isEmpty() && !ApplicationManager.getApplication().isUnitTestMode()) {
                UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        String msg = "The local.properties file(s) in the project(s)\n " + projectsToUpdateNames + "\nwill be modified with the path of Android Studio's Android SDK:\n'" + sdkHomePath + "'";
                        Messages.showErrorDialog((String)String.format(msg, projectsToUpdateNames, sdkHomePath), (String)"Sync Android SDKs");
                    }
                });
            }
            GradleProjectImporter projectImporter = GradleProjectImporter.getInstance();
            for (Pair toUpdate : localPropertiesToUpdate) {
                Project project;
                block10: {
                    project = (Project)toUpdate.getFirst();
                    try {
                        localProperties = (LocalProperties)toUpdate.getSecond();
                        if (FileUtil.filesEqual((File)sdkHomePath, (File)localProperties.getAndroidSdkPath())) break block10;
                        localProperties.setAndroidSdkPath(sdkHomePath);
                        localProperties.save();
                    }
                    catch (IOException e) {
                        IdeSdks.logAndShowErrorWhenUpdatingLocalProperties(project, e, "update", sdkHomePath);
                        continue;
                    }
                }
                if (ApplicationManager.getApplication().isUnitTestMode() || !Projects.isBuildWithGradle(project)) continue;
                projectImporter.requestProjectSync(project, null);
            }
        }
    }

    private static void logAndShowErrorWhenUpdatingLocalProperties(@NotNull Project project, @NotNull Exception error, @NotNull String action, @NotNull File sdkHomePath) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/sdk/IdeSdks", "logAndShowErrorWhenUpdatingLocalProperties"));
        }
        if (error == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "error", "com/android/tools/idea/sdk/IdeSdks", "logAndShowErrorWhenUpdatingLocalProperties"));
        }
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/android/tools/idea/sdk/IdeSdks", "logAndShowErrorWhenUpdatingLocalProperties"));
        }
        if (sdkHomePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdkHomePath", "com/android/tools/idea/sdk/IdeSdks", "logAndShowErrorWhenUpdatingLocalProperties"));
        }
        LOG.info((Throwable)error);
        String msg = String.format("Unable to %1$s local.properties file in project '%2$s'.\n\nCause: %3$s\n\nPlease manually update the file's '%4$s' property value to \n'%5$s'\nand sync the project with Gradle files.", action, project.getName(), IdeSdks.getMessage(error), "sdk.dir", sdkHomePath.getPath());
        Messages.showErrorDialog((Project)project, (String)msg, (String)ERROR_DIALOG_TITLE);
    }

    @NotNull
    private static String getMessage(@NotNull Exception e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/android/tools/idea/sdk/IdeSdks", "getMessage"));
        }
        String cause = e.getMessage();
        if (Strings.isNullOrEmpty((String)cause)) {
            cause = "[Unknown]";
        }
        String string = cause;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/sdk/IdeSdks", "getMessage"));
        }
        return string;
    }

    @NotNull
    private static File resolvePath(@NotNull File path) {
        File file;
        block4: {
            if (path == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/android/tools/idea/sdk/IdeSdks", "resolvePath"));
            }
            try {
                String resolvedPath = FileUtil.resolveShortWindowsName((String)path.getPath());
                file = new File(resolvedPath);
                if (file != null) break block4;
            }
            catch (IOException iOException) {
                File file2 = path;
                if (file2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/sdk/IdeSdks", "resolvePath"));
                }
                return file2;
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/sdk/IdeSdks", "resolvePath"));
        }
        return file;
    }

    @Nullable
    public static Sdk getJdk() {
        return IdeSdks.getJdk(null);
    }

    @Nullable
    public static Sdk getJdk(@Nullable JavaSdkVersion preferredVersion) {
        List<Sdk> androidSdks = IdeSdks.getEligibleAndroidSdks();
        if (!androidSdks.isEmpty()) {
            Sdk androidSdk = androidSdks.get(0);
            AndroidSdkAdditionalData data = AndroidSdkUtils.getAndroidSdkAdditionalData(androidSdk);
            assert (data != null);
            Sdk jdk = data.getJavaSdk();
            if (IdeSdks.isJdkCompatible(jdk, preferredVersion)) {
                return jdk;
            }
        }
        JavaSdk javaSdk = JavaSdk.getInstance();
        List jdks = ProjectJdkTable.getInstance().getSdksOfType((SdkTypeId)javaSdk);
        if (!jdks.isEmpty()) {
            for (Sdk jdk : jdks) {
                if (!IdeSdks.isJdkCompatible(jdk, preferredVersion)) continue;
                return jdk;
            }
        }
        List<File> jdkPaths = IdeSdks.getPotentialJdkPaths();
        for (File jdkPath : jdkPaths) {
            if (JavaSdk.checkForJdk((File)jdkPath)) {
                Sdk jdk = IdeSdks.createJdk(jdkPath);
                return IdeSdks.isJdkCompatible(jdk, preferredVersion) ? jdk : null;
            }
            if (!SystemInfo.isLinux) continue;
            for (File child : FileUtil.notNullize((File[])jdkPath.listFiles())) {
                Sdk jdk;
                if (!child.isDirectory() || !JavaSdk.checkForJdk((File)child) || !IdeSdks.isJdkCompatible(jdk = Jdks.createJdk(child.getPath()), preferredVersion)) continue;
                return jdk;
            }
        }
        return null;
    }

    @NotNull
    private static List<File> getPotentialJdkPaths() {
        JavaSdk javaSdk = JavaSdk.getInstance();
        ArrayList jdkPaths = Lists.newArrayList((Iterable)javaSdk.suggestHomePaths());
        jdkPaths.add(SystemProperties.getJavaHome());
        ArrayList virtualFiles = Lists.newArrayListWithCapacity((int)jdkPaths.size());
        for (String jdkPath : jdkPaths) {
            File javaHome;
            if (jdkPath == null || !(javaHome = new File(jdkPath)).isDirectory()) continue;
            virtualFiles.add(javaHome);
        }
        ArrayList arrayList = virtualFiles;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/sdk/IdeSdks", "getPotentialJdkPaths"));
        }
        return arrayList;
    }

    private static boolean isJdkCompatible(@Nullable Sdk jdk, @Nullable JavaSdkVersion preferredVersion) {
        if (jdk == null) {
            return false;
        }
        if (preferredVersion == null) {
            return true;
        }
        return JavaSdk.getInstance().isOfVersionOrHigher(jdk, preferredVersion);
    }

    @NotNull
    public static List<Sdk> getEligibleAndroidSdks() {
        ArrayList sdks = Lists.newArrayList();
        for (Sdk sdk : AndroidSdkUtils.getAllAndroidSdks()) {
            if (!sdk.getName().startsWith("Android ") || AndroidPlatform.getInstance(sdk) == null) continue;
            sdks.add(sdk);
        }
        ArrayList arrayList = sdks;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/sdk/IdeSdks", "getEligibleAndroidSdks"));
        }
        return arrayList;
    }

    @Nullable
    private static Sdk createJdk(@NotNull File homeDirectory) {
        if (homeDirectory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "homeDirectory", "com/android/tools/idea/sdk/IdeSdks", "createJdk"));
        }
        return Jdks.createJdk(homeDirectory.getPath());
    }
}

