/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.configuration;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.ide.actions.OpenFileAction;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.WritingAccessProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.DomElement;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.dom.MavenDomUtil;
import org.jetbrains.idea.maven.dom.model.MavenDomDependency;
import org.jetbrains.idea.maven.dom.model.MavenDomPlugin;
import org.jetbrains.idea.maven.dom.model.MavenDomPluginExecution;
import org.jetbrains.idea.maven.dom.model.MavenDomPluginRepositories;
import org.jetbrains.idea.maven.dom.model.MavenDomPlugins;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;
import org.jetbrains.idea.maven.dom.model.MavenDomRepositories;
import org.jetbrains.idea.maven.dom.model.MavenDomRepository;
import org.jetbrains.idea.maven.dom.model.MavenDomShortArtifactCoordinates;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.kotlin.idea.KotlinPluginUtil;
import org.jetbrains.kotlin.idea.configuration.ConfigureKotlinInProjectUtilsKt;
import org.jetbrains.kotlin.idea.configuration.KotlinProjectConfigurator;
import org.jetbrains.kotlin.idea.framework.ui.ConfigureDialogWithModulesAndVersion;

public abstract class KotlinMavenConfigurator
implements KotlinProjectConfigurator {
    private static final String[] KOTLIN_VERSIONS = new String[]{"1.0.0-release-IJ143-75"};
    public static final String NAME = "maven";
    private static final String GROUP_ID = "org.jetbrains.kotlin";
    private static final String MAVEN_PLUGIN_ID = "kotlin-maven-plugin";
    private static final String KOTLIN_VERSION_PROPERTY = "kotlin.version";
    private static final String SNAPSHOT_REPOSITORY_ID = "sonatype.oss.snapshots";
    private static final String PROCESS_TEST_SOURCES_PHASE = "process-test-sources";
    private static final String PROCESS_SOURCES_PHASE = "process-sources";
    private static final String TEST_COMPILE_PHASE = "test-compile";
    private static final String COMPILE_PHASE = "compile";
    private static final String TEST_COMPILE_GOAL = "test-compile";
    private static final String COMPILE_GOAL = "compile";
    private static final String TEST_COMPILE_EXECUTION_ID = "test-compile";
    private static final String COMPILE_EXECUTION_ID = "compile";
    private final String libraryId;
    private final String name;
    private final String presentableText;

    protected KotlinMavenConfigurator(@NotNull String libraryId, @NotNull String name2, @NotNull String presentableText) {
        if (libraryId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryId", "org/jetbrains/kotlin/idea/configuration/KotlinMavenConfigurator", "<init>"));
        }
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/idea/configuration/KotlinMavenConfigurator", "<init>"));
        }
        if (presentableText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentableText", "org/jetbrains/kotlin/idea/configuration/KotlinMavenConfigurator", "<init>"));
        }
        this.libraryId = libraryId;
        this.name = name2;
        this.presentableText = presentableText;
    }

    @Override
    public boolean isApplicable(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/kotlin/idea/configuration/KotlinMavenConfigurator", "isApplicable"));
        }
        return KotlinPluginUtil.isMavenModule(module);
    }

    @Override
    @NotNull
    public String getPresentableText() {
        String string = this.presentableText;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/configuration/KotlinMavenConfigurator", "getPresentableText"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.name;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/configuration/KotlinMavenConfigurator", "getName"));
        }
        return string;
    }

    @Override
    public boolean isConfigured(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/kotlin/idea/configuration/KotlinMavenConfigurator", "isConfigured"));
        }
        if (this.isKotlinModule(module)) {
            return true;
        }
        MavenDomProjectModel domProjectModel = KotlinMavenConfigurator.getMavenDomProjectModel(module);
        if (domProjectModel == null) {
            return false;
        }
        return KotlinMavenConfigurator.hasKotlinMavenPlugin(domProjectModel) && this.hasDependencyOnLibrary(domProjectModel);
    }

    @Override
    public void configure(@NotNull Project project, Collection<Module> excludeModules) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/configuration/KotlinMavenConfigurator", "configure"));
        }
        ConfigureDialogWithModulesAndVersion dialog2 = new ConfigureDialogWithModulesAndVersion(project, this, KOTLIN_VERSIONS, excludeModules);
        dialog2.show();
        if (!dialog2.isOK()) {
            return;
        }
        for (Module module : dialog2.getModulesToConfigure()) {
            PsiFile file = KotlinMavenConfigurator.findModulePomFile(module);
            if (file != null && KotlinMavenConfigurator.canConfigureFile(file)) {
                this.changePomFile(module, file, dialog2.getKotlinVersion());
                OpenFileAction.openFile((VirtualFile)file.getVirtualFile(), (Project)project);
                continue;
            }
            KotlinMavenConfigurator.showErrorMessage(project, "Cannot find pom.xml for module " + module.getName());
        }
    }

    protected abstract boolean isKotlinModule(@NotNull Module var1);

    protected abstract void createExecutions(VirtualFile var1, MavenDomPlugin var2, Module var3);

    @NotNull
    protected String getGoal(boolean isTest) {
        String string = isTest ? "test-compile" : "compile";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/configuration/KotlinMavenConfigurator", "getGoal"));
        }
        return string;
    }

    @NotNull
    protected String getExecutionId(boolean isTest) {
        String string = isTest ? "test-compile" : "compile";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/configuration/KotlinMavenConfigurator", "getExecutionId"));
        }
        return string;
    }

    protected void changePomFile(final @NotNull Module module, final @NotNull PsiFile file, final @NotNull String version) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/kotlin/idea/configuration/KotlinMavenConfigurator", "changePomFile"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/idea/configuration/KotlinMavenConfigurator", "changePomFile"));
        }
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "org/jetbrains/kotlin/idea/configuration/KotlinMavenConfigurator", "changePomFile"));
        }
        final VirtualFile virtualFile = file.getVirtualFile();
        assert (virtualFile != null) : "Virtual file should exists for psi file " + file.getName();
        final MavenDomProjectModel domModel = MavenDomUtil.getMavenDomProjectModel((Project)module.getProject(), (VirtualFile)virtualFile);
        if (domModel == null) {
            KotlinMavenConfigurator.showErrorMessage(module.getProject(), null);
            return;
        }
        new WriteCommandAction(file.getProject(), new PsiFile[0]){

            protected void run(@NotNull Result result2) {
                if (result2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/kotlin/idea/configuration/KotlinMavenConfigurator$1", "run"));
                }
                KotlinMavenConfigurator.addKotlinVersionPropertyIfNeeded(domModel, version);
                if (KotlinMavenConfigurator.isSnapshot(version)) {
                    KotlinMavenConfigurator.addPluginRepositoryIfNeeded(domModel);
                    KotlinMavenConfigurator.addLibraryRepositoryIfNeeded(domModel);
                }
                KotlinMavenConfigurator.this.addPluginIfNeeded(domModel, module, virtualFile);
                KotlinMavenConfigurator.this.addLibraryDependencyIfNeeded(domModel);
                CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement((PsiElement)file);
            }
        }.execute();
        ConfigureKotlinInProjectUtilsKt.showInfoNotification(module.getProject(), virtualFile.getPath() + " was modified");
    }

    protected void createExecution(@NotNull VirtualFile virtualFile, @NotNull MavenDomPlugin kotlinPlugin, @NotNull Module module, boolean isTest) {
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "org/jetbrains/kotlin/idea/configuration/KotlinMavenConfigurator", "createExecution"));
        }
        if (kotlinPlugin == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kotlinPlugin", "org/jetbrains/kotlin/idea/configuration/KotlinMavenConfigurator", "createExecution"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/kotlin/idea/configuration/KotlinMavenConfigurator", "createExecution"));
        }
        MavenDomPluginExecution execution = kotlinPlugin.getExecutions().addExecution();
        String tagValue = this.getExecutionId(isTest);
        execution.getId().setStringValue(tagValue);
        execution.getPhase().setStringValue(KotlinMavenConfigurator.getPhase(module, isTest));
        KotlinMavenConfigurator.createTagIfNeeded((DomElement)execution.getGoals(), "goal", this.getGoal(isTest));
        XmlTag sourcesTag = KotlinMavenConfigurator.createTagIfNeeded((DomElement)execution.getConfiguration(), "sourceDirs", "");
        for (ContentEntry contentEntry : ModuleRootManager.getInstance((Module)module).getContentEntries()) {
            SourceFolder[] folders;
            for (SourceFolder sourceFolder : folders = contentEntry.getSourceFolders()) {
                VirtualFile sourceFolderFile;
                if (!KotlinMavenConfigurator.isRelatedSourceRoot(isTest, sourceFolder) || (sourceFolderFile = sourceFolder.getFile()) == null) continue;
                String relativePath = VfsUtilCore.getRelativePath((VirtualFile)sourceFolderFile, (VirtualFile)virtualFile.getParent(), (char)'/');
                XmlTag newTag = sourcesTag.createChildTag("source", sourcesTag.getNamespace(), relativePath, false);
                sourcesTag.addSubTag(newTag, true);
            }
        }
    }

    private static boolean isRelatedSourceRoot(boolean isTest, SourceFolder folder) {
        return isTest && folder.getRootType() == JavaSourceRootType.TEST_SOURCE || !isTest && folder.getRootType() == JavaSourceRootType.SOURCE;
    }

    @Nullable
    private static MavenDomProjectModel getMavenDomProjectModel(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/kotlin/idea/configuration/KotlinMavenConfigurator", "getMavenDomProjectModel"));
        }
        PsiFile pomFile = KotlinMavenConfigurator.findModulePomFile(module);
        if (pomFile == null) {
            return null;
        }
        VirtualFile virtualFile = pomFile.getVirtualFile();
        assert (virtualFile != null) : "Virtual file should exists for psi file " + pomFile.getName();
        MavenDomProjectModel domModel = MavenDomUtil.getMavenDomProjectModel((Project)pomFile.getProject(), (VirtualFile)virtualFile);
        assert (domModel != null) : "maven dom model should not be null";
        return domModel;
    }

    private static boolean checkCoordinates(@NotNull MavenDomShortArtifactCoordinates mavenDomElement, @NotNull String groupId, @NotNull String artifactId) {
        if (mavenDomElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mavenDomElement", "org/jetbrains/kotlin/idea/configuration/KotlinMavenConfigurator", "checkCoordinates"));
        }
        if (groupId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groupId", "org/jetbrains/kotlin/idea/configuration/KotlinMavenConfigurator", "checkCoordinates"));
        }
        if (artifactId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifactId", "org/jetbrains/kotlin/idea/configuration/KotlinMavenConfigurator", "checkCoordinates"));
        }
        return groupId.equals(mavenDomElement.getGroupId().getRawText()) && artifactId.equals(mavenDomElement.getArtifactId().getRawText());
    }

    private static boolean hasKotlinMavenPlugin(@NotNull MavenDomProjectModel domModel) {
        if (domModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "domModel", "org/jetbrains/kotlin/idea/configuration/KotlinMavenConfigurator", "hasKotlinMavenPlugin"));
        }
        for (MavenDomPlugin mavenDomPlugin : domModel.getBuild().getPlugins().getPlugins()) {
            if (!KotlinMavenConfigurator.checkCoordinates((MavenDomShortArtifactCoordinates)mavenDomPlugin, GROUP_ID, MAVEN_PLUGIN_ID)) continue;
            return true;
        }
        return false;
    }

    private boolean hasDependencyOnLibrary(@NotNull MavenDomProjectModel domModel) {
        if (domModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "domModel", "org/jetbrains/kotlin/idea/configuration/KotlinMavenConfigurator", "hasDependencyOnLibrary"));
        }
        for (MavenDomDependency mavenDomDependency : domModel.getDependencies().getDependencies()) {
            if (!KotlinMavenConfigurator.checkCoordinates((MavenDomShortArtifactCoordinates)mavenDomDependency, GROUP_ID, this.libraryId)) continue;
            return true;
        }
        return false;
    }

    private static void addKotlinVersionPropertyIfNeeded(MavenDomProjectModel domModel, String version) {
        KotlinMavenConfigurator.createTagIfNeeded((DomElement)domModel.getProperties(), KOTLIN_VERSION_PROPERTY, version);
    }

    private static void addLibraryRepositoryIfNeeded(MavenDomProjectModel domModel) {
        MavenDomRepositories repositories = domModel.getRepositories();
        if (!KotlinMavenConfigurator.isRepositoryConfigured(repositories.getRepositories())) {
            MavenDomRepository newPluginRepository = repositories.addRepository();
            KotlinMavenConfigurator.configureRepository(newPluginRepository);
        }
    }

    private static void addPluginRepositoryIfNeeded(MavenDomProjectModel domModel) {
        MavenDomPluginRepositories pluginRepositories = domModel.getPluginRepositories();
        if (!KotlinMavenConfigurator.isRepositoryConfigured(pluginRepositories.getPluginRepositories())) {
            MavenDomRepository newPluginRepository = pluginRepositories.addPluginRepository();
            KotlinMavenConfigurator.configureRepository(newPluginRepository);
        }
    }

    private void addLibraryDependencyIfNeeded(MavenDomProjectModel domModel) {
        for (MavenDomDependency dependency : domModel.getDependencies().getDependencies()) {
            if (!this.libraryId.equals(dependency.getArtifactId().getStringValue())) continue;
            return;
        }
        MavenDomDependency dependency = MavenDomUtil.createDomDependency((MavenDomProjectModel)domModel, null);
        dependency.getGroupId().setStringValue(GROUP_ID);
        dependency.getArtifactId().setStringValue(this.libraryId);
        dependency.getVersion().setStringValue("${kotlin.version}");
    }

    private void addPluginIfNeeded(MavenDomProjectModel domModel, Module module, VirtualFile virtualFile) {
        MavenDomPlugins plugins = domModel.getBuild().getPlugins();
        for (MavenDomPlugin plugin : plugins.getPlugins()) {
            if (!MAVEN_PLUGIN_ID.equals(plugin.getArtifactId().getStringValue())) continue;
            return;
        }
        MavenDomPlugin kotlinPlugin = plugins.addPlugin();
        kotlinPlugin.getArtifactId().setStringValue(MAVEN_PLUGIN_ID);
        kotlinPlugin.getGroupId().setStringValue(GROUP_ID);
        kotlinPlugin.getVersion().setStringValue("${kotlin.version}");
        this.createExecutions(virtualFile, kotlinPlugin, module);
    }

    private static boolean isRepositoryConfigured(List<MavenDomRepository> pluginRepositories) {
        for (MavenDomRepository repository : pluginRepositories) {
            if (!SNAPSHOT_REPOSITORY_ID.equals(repository.getId().getStringValue())) continue;
            return true;
        }
        return false;
    }

    private static void configureRepository(@NotNull MavenDomRepository repository) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "org/jetbrains/kotlin/idea/configuration/KotlinMavenConfigurator", "configureRepository"));
        }
        repository.getId().setStringValue(SNAPSHOT_REPOSITORY_ID);
        repository.getName().setStringValue("Sonatype OSS Snapshot Repository");
        repository.getUrl().setStringValue("http://oss.sonatype.org/content/repositories/snapshots");
        KotlinMavenConfigurator.createTagIfNeeded((DomElement)repository.getReleases(), "enabled", "false");
        KotlinMavenConfigurator.createTagIfNeeded((DomElement)repository.getSnapshots(), "enabled", "true");
    }

    @NotNull
    private static String getPhase(@NotNull Module module, boolean isTest) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/kotlin/idea/configuration/KotlinMavenConfigurator", "getPhase"));
        }
        if (KotlinMavenConfigurator.hasJavaFiles(module)) {
            String string = isTest ? PROCESS_TEST_SOURCES_PHASE : PROCESS_SOURCES_PHASE;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/configuration/KotlinMavenConfigurator", "getPhase"));
            }
            return string;
        }
        String string = isTest ? "test-compile" : "compile";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/configuration/KotlinMavenConfigurator", "getPhase"));
        }
        return string;
    }

    private static boolean hasJavaFiles(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/kotlin/idea/configuration/KotlinMavenConfigurator", "hasJavaFiles"));
        }
        return !FileTypeIndex.getFiles((FileType)JavaFileType.INSTANCE, (GlobalSearchScope)GlobalSearchScope.moduleScope((Module)module)).isEmpty();
    }

    @Nullable
    private static PsiFile findModulePomFile(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/kotlin/idea/configuration/KotlinMavenConfigurator", "findModulePomFile"));
        }
        List files = MavenProjectsManager.getInstance((Project)module.getProject()).getProjectsFiles();
        for (VirtualFile file : files) {
            PsiFile psiFile;
            Module fileModule = ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)module.getProject());
            if (!module.equals(fileModule) || (psiFile = PsiManager.getInstance((Project)module.getProject()).findFile(file)) == null || !MavenDomUtil.isProjectFile((PsiFile)psiFile)) continue;
            return psiFile;
        }
        return null;
    }

    private static boolean isSnapshot(@NotNull String version) {
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "org/jetbrains/kotlin/idea/configuration/KotlinMavenConfigurator", "isSnapshot"));
        }
        return version.contains("SNAPSHOT");
    }

    @NotNull
    private static XmlTag createTagIfNeeded(@NotNull DomElement parent2, @NotNull String tagName, @NotNull String value2) {
        if (parent2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "org/jetbrains/kotlin/idea/configuration/KotlinMavenConfigurator", "createTagIfNeeded"));
        }
        if (tagName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tagName", "org/jetbrains/kotlin/idea/configuration/KotlinMavenConfigurator", "createTagIfNeeded"));
        }
        if (value2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/kotlin/idea/configuration/KotlinMavenConfigurator", "createTagIfNeeded"));
        }
        XmlTag parentTag = parent2.ensureTagExists();
        XmlTag tagWithGivenName = parentTag.findFirstSubTag(tagName);
        if (tagWithGivenName != null) {
            XmlTag xmlTag = tagWithGivenName;
            if (xmlTag == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/configuration/KotlinMavenConfigurator", "createTagIfNeeded"));
            }
            return xmlTag;
        }
        XmlTag newTag = parentTag.createChildTag(tagName, parentTag.getNamespace(), value2, false);
        XmlTag xmlTag = parentTag.addSubTag(newTag, true);
        if (xmlTag == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/configuration/KotlinMavenConfigurator", "createTagIfNeeded"));
        }
        return xmlTag;
    }

    private static boolean canConfigureFile(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/idea/configuration/KotlinMavenConfigurator", "canConfigureFile"));
        }
        return WritingAccessProvider.isPotentiallyWritable((VirtualFile)file.getVirtualFile(), null);
    }

    private static void showErrorMessage(@NotNull Project project, @Nullable String message2) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/configuration/KotlinMavenConfigurator", "showErrorMessage"));
        }
        Messages.showErrorDialog((Project)project, (String)("<html>Couldn't configure kotlin-maven plugin automatically.<br/>" + (message2 != null ? message2 : "") + "See manual installation instructions <a href=\"http://confluence.jetbrains.com/display/Kotlin/Kotlin+Build+Tools#KotlinBuildTools-Maven\">here</a></html>"), (String)"Configure Kotlin-Maven Plugin");
    }
}

