/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticWithParameters1;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.idea.quickfix.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.quickfix.KotlinSingleIntentionActionFactory;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00142\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0014B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\bH\u0016J\"\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014J\"\u0010\u0012\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0013H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ChangeVariableMutabilityFix;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "element", "makeVar", "", "(Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;Z)V", "getFamilyName", "", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "isAvailable", "Lcom/intellij/psi/PsiFile;", "Companion", "idea"})
public final class ChangeVariableMutabilityFix
extends KotlinQuickFixAction<KtNamedDeclaration> {
    private final boolean makeVar;
    @NotNull
    private static final KotlinSingleIntentionActionFactory VAL_WITH_SETTER_FACTORY;
    @NotNull
    private static final KotlinSingleIntentionActionFactory VAL_REASSIGNMENT_FACTORY;
    @NotNull
    private static final KotlinSingleIntentionActionFactory VAR_OVERRIDDEN_BY_VAL_FACTORY;
    public static final Companion Companion;

    @NotNull
    public String getText() {
        return this.makeVar ? "Make variable mutable" : "Make variable immutable";
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @NotNull PsiFile file) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        KtNamedDeclaration ktNamedDeclaration = (KtNamedDeclaration)this.getElement();
        if (ktNamedDeclaration instanceof KtProperty) {
            bl = ((KtProperty)this.getElement()).isVar() != this.makeVar;
        } else if (ktNamedDeclaration instanceof KtParameter) {
            void $receiver$iv;
            Object t = this.getElement();
            KtPrimaryConstructor ktPrimaryConstructor = (KtPrimaryConstructor)PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv, KtPrimaryConstructor.class, (boolean)true);
            bl = Intrinsics.areEqual((Object)(ktPrimaryConstructor != null ? ktPrimaryConstructor.getValueParameterList() : null), (Object)((KtParameter)this.getElement()).getParent()) && Intrinsics.areEqual((Object)((KtParameter)this.getElement()).getValOrVarKeyword(), (Object)((Object)KtTokens.VAR_KEYWORD)) != this.makeVar;
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    protected void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull KtFile file) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        KtPsiFactory factory2 = new KtPsiFactory(project);
        PsiElement newKeyword = this.makeVar ? factory2.createVarKeyword() : factory2.createValKeyword();
        KtNamedDeclaration ktNamedDeclaration = (KtNamedDeclaration)this.getElement();
        if (ktNamedDeclaration instanceof KtProperty) {
            ((KtProperty)this.getElement()).getValOrVarKeyword().replace(newKeyword);
        } else if (ktNamedDeclaration instanceof KtParameter) {
            PsiElement psiElement2 = ((KtParameter)this.getElement()).getValOrVarKeyword();
            if (psiElement2 == null) {
                Intrinsics.throwNpe();
            }
            psiElement2.replace(newKeyword);
        }
    }

    public ChangeVariableMutabilityFix(@NotNull KtNamedDeclaration element2, boolean makeVar) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        super((PsiElement)element2);
        this.makeVar = makeVar;
    }

    static {
        Companion = new Companion(null);
        VAL_WITH_SETTER_FACTORY = new KotlinSingleIntentionActionFactory(){

            @Nullable
            protected IntentionAction createAction(@NotNull Diagnostic diagnostic) {
                Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
                PsiElement psiElement2 = diagnostic.getPsiElement();
                if (psiElement2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtPropertyAccessor");
                }
                KtPropertyAccessor accessor = (KtPropertyAccessor)psiElement2;
                KtNamedDeclaration ktNamedDeclaration = accessor.getProperty();
                Intrinsics.checkExpressionValueIsNotNull((Object)ktNamedDeclaration, (String)"accessor.property");
                return new ChangeVariableMutabilityFix(ktNamedDeclaration, true);
            }
        };
        VAL_REASSIGNMENT_FACTORY = new KotlinSingleIntentionActionFactory(){

            @Nullable
            protected IntentionAction createAction(@NotNull Diagnostic diagnostic) {
                DeclarationDescriptor propertyDescriptor;
                Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
                DeclarationDescriptor declarationDescriptor = propertyDescriptor = (DeclarationDescriptor)((DiagnosticWithParameters1)Errors.VAL_REASSIGNMENT.cast(diagnostic)).getA();
                Intrinsics.checkExpressionValueIsNotNull((Object)declarationDescriptor, (String)"propertyDescriptor");
                PsiElement psiElement2 = DescriptorToSourceUtils.descriptorToDeclaration(declarationDescriptor);
                if (!(psiElement2 instanceof KtNamedDeclaration)) {
                    psiElement2 = null;
                }
                KtNamedDeclaration ktNamedDeclaration = (KtNamedDeclaration)psiElement2;
                if (ktNamedDeclaration == null) {
                    return null;
                }
                KtNamedDeclaration declaration = ktNamedDeclaration;
                return new ChangeVariableMutabilityFix(declaration, true);
            }
        };
        VAR_OVERRIDDEN_BY_VAL_FACTORY = new KotlinSingleIntentionActionFactory(){

            @Nullable
            protected IntentionAction createAction(@NotNull Diagnostic diagnostic) {
                IntentionAction intentionAction;
                PsiElement element2;
                Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
                PsiElement psiElement2 = element2 = diagnostic.getPsiElement();
                if (psiElement2 instanceof KtProperty || psiElement2 instanceof KtParameter) {
                    PsiElement psiElement3 = element2;
                    if (psiElement3 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtNamedDeclaration");
                    }
                    intentionAction = new ChangeVariableMutabilityFix((KtNamedDeclaration)psiElement3, true);
                } else {
                    intentionAction = null;
                }
                return intentionAction;
            }
        };
    }

    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ChangeVariableMutabilityFix$Companion;", "", "()V", "VAL_REASSIGNMENT_FACTORY", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "getVAL_REASSIGNMENT_FACTORY", "()Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "VAL_WITH_SETTER_FACTORY", "getVAL_WITH_SETTER_FACTORY", "VAR_OVERRIDDEN_BY_VAL_FACTORY", "getVAR_OVERRIDDEN_BY_VAL_FACTORY", "idea"})
    public static final class Companion {
        @NotNull
        public final KotlinSingleIntentionActionFactory getVAL_WITH_SETTER_FACTORY() {
            return VAL_WITH_SETTER_FACTORY;
        }

        @NotNull
        public final KotlinSingleIntentionActionFactory getVAL_REASSIGNMENT_FACTORY() {
            return VAL_REASSIGNMENT_FACTORY;
        }

        @NotNull
        public final KotlinSingleIntentionActionFactory getVAR_OVERRIDDEN_BY_VAL_FACTORY() {
            return VAR_OVERRIDDEN_BY_VAL_FACTORY;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

