/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.versions;

import com.intellij.ProjectTopics;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootAdapter;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.util.messages.MessageBusConnection;
import java.awt.Component;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.kotlin.idea.framework.JSLibraryStdPresentationProvider;
import org.jetbrains.kotlin.idea.framework.JavaRuntimePresentationProvider;
import org.jetbrains.kotlin.idea.versions.KotlinRuntimeLibraryUtilKt;
import org.jetbrains.kotlin.idea.versions.SuppressNotificationState;
import org.jetbrains.kotlin.idea.versions.UnsupportedAbiVersionNotificationPanelProvider;
import org.jetbrains.kotlin.idea.versions.UnsupportedAbiVersionNotificationPanelProviderKt;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001a2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0003\u001a\u001b\u001cB\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\b\u001a\u0004\u0018\u00010\u00022\u0006\u0010\t\u001a\u00020\nJ\u001a\u0010\u000b\u001a\u0004\u0018\u00010\u00022\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J \u0010\u0010\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u001e\u0010\u0015\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\r0\u0017H\u0002J\u000e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00020\u0019H\u0016J\b\u0010\u0006\u001a\u00020\u0011H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/idea/versions/UnsupportedAbiVersionNotificationPanelProvider;", "Lcom/intellij/ui/EditorNotifications$Provider;", "Lcom/intellij/ui/EditorNotificationPanel;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "updateNotifications", "Ljava/lang/Runnable;", "checkAndCreate", "module", "Lcom/intellij/openapi/module/Module;", "createNotificationPanel", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "fileEditor", "Lcom/intellij/openapi/fileEditor/FileEditor;", "createShowPathsActionLabel", "", "answer", "labelText", "", "doCreate", "badRoots", "", "getKey", "Lcom/intellij/openapi/util/Key;", "Companion", "ErrorNotificationPanel", "LibraryRootsPopupModel", "idea"})
public final class UnsupportedAbiVersionNotificationPanelProvider
extends EditorNotifications.Provider<EditorNotificationPanel> {
    private final Runnable updateNotifications;
    private final Project project;
    private static final Key<EditorNotificationPanel> KEY;
    public static final Companion Companion;

    /*
     * WARNING - void declaration
     */
    private final EditorNotificationPanel doCreate(Module module, Collection<? extends VirtualFile> badRoots) {
        void destination$iv$iv;
        void $receiver$iv$iv;
        void $receiver$iv;
        ErrorNotificationPanel answer = new ErrorNotificationPanel();
        Set kotlinLibraries = KotlinRuntimeLibraryUtilKt.findAllUsedLibraries(this.project).keySet();
        Iterable iterable = kotlinLibraries;
        void var7_7 = $receiver$iv;
        Collection collection = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            Library library = (Library)element$iv$iv;
            VirtualFile runtimeJar = KotlinRuntimeLibraryUtilKt.getLocalJar(JavaRuntimePresentationProvider.getRuntimeJar(library));
            VirtualFile jsLibJar = KotlinRuntimeLibraryUtilKt.getLocalJar(JSLibraryStdPresentationProvider.getJsStdLibJar(library));
            if (!(CollectionsKt.contains((Iterable)badRoots, (Object)runtimeJar) || CollectionsKt.contains((Iterable)badRoots, (Object)jsLibJar))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List badRuntimeLibraries = (List)destination$iv$iv;
        if (!badRuntimeLibraries.isEmpty()) {
            int otherBadRootsCount = badRoots.size() - badRuntimeLibraries.size();
            String text2 = MessageFormat.format("<html><b>{0,choice,0#|1#|1<Some }Kotlin runtime librar{0,choice,0#|1#y|1<ies}</b>" + "{1,choice,0#|1# and one other jar|1< and {1} other jars} " + "{1,choice,0#has|0<have} an unsupported format</html>", badRuntimeLibraries.size(), otherBadRootsCount);
            String actionLabelText = MessageFormat.format("Update {0,choice,0#|1#|1<all }Kotlin runtime librar{0,choice,0#|1#y|1<ies} ", badRuntimeLibraries.size());
            answer.setText(text2);
            answer.createActionLabel(actionLabelText, new Runnable(this, badRuntimeLibraries){
                final /* synthetic */ UnsupportedAbiVersionNotificationPanelProvider this$0;
                final /* synthetic */ List $badRuntimeLibraries;

                public final void run() {
                    KotlinRuntimeLibraryUtilKt.updateLibraries(UnsupportedAbiVersionNotificationPanelProvider.access$getProject$p(this.this$0), this.$badRuntimeLibraries);
                }
                {
                    this.this$0 = unsupportedAbiVersionNotificationPanelProvider;
                    this.$badRuntimeLibraries = list2;
                }
            });
            if (otherBadRootsCount > 0) {
                this.createShowPathsActionLabel(module, answer, "Show all");
            }
        } else if (badRoots.size() == 1) {
            VirtualFile root = badRoots.iterator().next();
            String presentableName = root.getPresentableName();
            answer.setText("<html>Kotlin library <b>'" + presentableName + "'</b> has an unsupported format. Please update the library or the plugin</html>");
            answer.createActionLabel("Go to " + presentableName, new Runnable(this, root){
                final /* synthetic */ UnsupportedAbiVersionNotificationPanelProvider this$0;
                final /* synthetic */ VirtualFile $root;

                public final void run() {
                    org.jetbrains.kotlin.idea.versions.UnsupportedAbiVersionNotificationPanelProvider$Companion.access$navigateToLibraryRoot(UnsupportedAbiVersionNotificationPanelProvider.Companion, UnsupportedAbiVersionNotificationPanelProvider.access$getProject$p(this.this$0), this.$root);
                }
                {
                    this.this$0 = unsupportedAbiVersionNotificationPanelProvider;
                    this.$root = virtualFile;
                }
            });
        } else {
            answer.setText("Some Kotlin libraries attached to this project have unsupported format. Please update the libraries or the plugin");
            this.createShowPathsActionLabel(module, answer, "Show paths");
        }
        return answer;
    }

    private final void createShowPathsActionLabel(Module module, EditorNotificationPanel answer, String labelText) {
        UnsupportedAbiVersionNotificationPanelProviderKt.createComponentActionLabel(answer, labelText, (Function1<? super HyperlinkLabel, Unit>)((Function1)new Function1<HyperlinkLabel, Unit>(this, module){
            final /* synthetic */ UnsupportedAbiVersionNotificationPanelProvider this$0;
            final /* synthetic */ Module $module;

            public final void invoke(@NotNull HyperlinkLabel label) {
                Intrinsics.checkParameterIsNotNull((Object)label, (String)"label");
                DumbService.getInstance((Project)UnsupportedAbiVersionNotificationPanelProvider.access$getProject$p(this.this$0)).tryRunReadActionInSmartMode((Computable)new Computable<T>(this, label){
                    final /* synthetic */ createShowPathsActionLabel.1 this$0;
                    final /* synthetic */ HyperlinkLabel $label;

                    @Nullable
                    public final Void compute() {
                        Unit unit;
                        Collection<VirtualFile> badRoots = UnsupportedAbiVersionNotificationPanelProvider.Companion.collectBadRoots(this.this$0.$module);
                        boolean value$iv = !badRoots.isEmpty();
                        if (_Assertions.ENABLED) {
                            if (!value$iv) {
                                String message$iv = "This action should only be called when bad roots are present";
                                throw (Throwable)((Object)new AssertionError((Object)message$iv));
                            }
                            unit = Unit.INSTANCE;
                        } else {
                            unit = Unit.INSTANCE;
                        }
                        LibraryRootsPopupModel listPopupModel = new LibraryRootsPopupModel("Unsupported format", UnsupportedAbiVersionNotificationPanelProvider.access$getProject$p(this.this$0.this$0), badRoots);
                        ListPopup popup = JBPopupFactory.getInstance().createListPopup((ListPopupStep)listPopupModel);
                        popup.showUnderneathOf((Component)this.$label);
                        return null;
                    }
                    {
                        this.this$0 = var1_1;
                        this.$label = hyperlinkLabel;
                    }
                }, "Can't show all paths during index update");
            }
            {
                this.this$0 = unsupportedAbiVersionNotificationPanelProvider;
                this.$module = module;
                super(1);
            }
        }));
    }

    @NotNull
    public Key<EditorNotificationPanel> getKey() {
        Key key = UnsupportedAbiVersionNotificationPanelProvider.Companion.getKEY();
        Intrinsics.checkExpressionValueIsNotNull((Object)key, (String)"KEY");
        return key;
    }

    @Nullable
    public EditorNotificationPanel createNotificationPanel(@NotNull VirtualFile file, @NotNull FileEditor fileEditor) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)fileEditor, (String)"fileEditor");
        try {
            Module module;
            if (DumbService.isDumb((Project)this.project)) {
                return null;
            }
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                return null;
            }
            if (file.getFileType() != KotlinFileType.INSTANCE) {
                return null;
            }
            if (CompilerManager.getInstance((Project)this.project).isExcludedFromCompilation(file)) {
                return null;
            }
            Module module2 = ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)this.project);
            if (module2 == null) {
                return null;
            }
            Module module3 = module = module2;
            Intrinsics.checkExpressionValueIsNotNull((Object)module3, (String)"module");
            return this.checkAndCreate(module3);
        }
        catch (ProcessCanceledException e) {
        }
        catch (IndexNotReadyException e) {
            DumbService.getInstance((Project)this.project).runWhenSmart(this.updateNotifications);
        }
        return null;
    }

    @Nullable
    public final EditorNotificationPanel checkAndCreate(@NotNull Module module) {
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        SuppressNotificationState state = ((SuppressNotificationState)ServiceManager.getService((Project)this.project, SuppressNotificationState.class)).getState();
        if (state != null && state.isSuppressed) {
            return null;
        }
        Collection<VirtualFile> badRoots = Companion.collectBadRoots(module);
        if (!badRoots.isEmpty()) {
            return this.doCreate(module, badRoots);
        }
        return null;
    }

    private final void updateNotifications() {
        ApplicationManager.getApplication().invokeLater(new Runnable(this){
            final /* synthetic */ UnsupportedAbiVersionNotificationPanelProvider this$0;

            public final void run() {
                if (!UnsupportedAbiVersionNotificationPanelProvider.access$getProject$p(this.this$0).isDisposed()) {
                    EditorNotifications.getInstance((Project)UnsupportedAbiVersionNotificationPanelProvider.access$getProject$p(this.this$0)).updateAllNotifications();
                }
            }
            {
                this.this$0 = unsupportedAbiVersionNotificationPanelProvider;
            }
        });
    }

    public UnsupportedAbiVersionNotificationPanelProvider(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        this.project = project;
        MessageBusConnection connection = this.project.getMessageBus().connect();
        connection.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootAdapter(){

            public void rootsChanged(@Nullable ModuleRootEvent event) {
                this.updateNotifications();
            }
        });
        connection.subscribe(DumbService.DUMB_MODE, (Object)new DumbService.DumbModeListener(){

            public void enteredDumbMode() {
            }

            public void exitDumbMode() {
                this.updateNotifications();
            }
        });
        this.updateNotifications = new Runnable(this){
            final /* synthetic */ UnsupportedAbiVersionNotificationPanelProvider this$0;

            public final void run() {
                UnsupportedAbiVersionNotificationPanelProvider.access$updateNotifications(this.this$0);
            }
            {
                this.this$0 = unsupportedAbiVersionNotificationPanelProvider;
            }
        };
    }

    static {
        Companion = new Companion(null);
        KEY = Key.create((String)"unsupported.abi.version");
    }

    @NotNull
    public static final /* synthetic */ Project access$getProject$p(UnsupportedAbiVersionNotificationPanelProvider $this) {
        return $this.project;
    }

    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B#\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\u0002H\u0016J\u0010\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0002H\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J \u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u00122\u0006\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u0010H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/idea/versions/UnsupportedAbiVersionNotificationPanelProvider$LibraryRootsPopupModel;", "Lcom/intellij/openapi/ui/popup/util/BaseListPopupStep;", "Lcom/intellij/openapi/vfs/VirtualFile;", "title", "", "project", "Lcom/intellij/openapi/project/Project;", "roots", "", "(Ljava/lang/String;Lcom/intellij/openapi/project/Project;Ljava/util/Collection;)V", "getIconFor", "Ljavax/swing/Icon;", "aValue", "getTextFor", "root", "isSpeedSearchEnabled", "", "onChosen", "Lcom/intellij/openapi/ui/popup/PopupStep;", "", "selectedValue", "finalChoice", "idea"})
    private static final class LibraryRootsPopupModel
    extends BaseListPopupStep<VirtualFile> {
        private final Project project;

        @NotNull
        public String getTextFor(@NotNull VirtualFile root) {
            Intrinsics.checkParameterIsNotNull((Object)root, (String)"root");
            String relativePath = VfsUtilCore.getRelativePath((VirtualFile)root, (VirtualFile)this.project.getBaseDir(), (char)'/');
            String string = relativePath;
            if (string == null) {
                String string2 = root.getPath();
                string = string2;
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"root.path");
            }
            return string;
        }

        @Nullable
        public Icon getIconFor(@NotNull VirtualFile aValue) {
            Intrinsics.checkParameterIsNotNull((Object)aValue, (String)"aValue");
            if (aValue.isDirectory()) {
                return AllIcons.Nodes.Folder;
            }
            return AllIcons.FileTypes.Archive;
        }

        @Nullable
        public PopupStep<Object> onChosen(@NotNull VirtualFile selectedValue, boolean finalChoice) {
            Intrinsics.checkParameterIsNotNull((Object)selectedValue, (String)"selectedValue");
            Companion.navigateToLibraryRoot(this.project, selectedValue);
            return PopupStep.FINAL_CHOICE;
        }

        public boolean isSpeedSearchEnabled() {
            return true;
        }

        /*
         * WARNING - void declaration
         */
        public LibraryRootsPopupModel(@NotNull String title, @NotNull Project project, @NotNull Collection<? extends VirtualFile> roots) {
            void $receiver$iv;
            Intrinsics.checkParameterIsNotNull((Object)title, (String)"title");
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull(roots, (String)"roots");
            Collection<? extends VirtualFile> collection = roots;
            String string = title;
            LibraryRootsPopupModel libraryRootsPopupModel = this;
            void v0 = $receiver$iv;
            if (v0 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
            }
            Collection thisCollection$iv = (Collection)v0;
            VirtualFile[] virtualFileArray = thisCollection$iv.toArray(new VirtualFile[thisCollection$iv.size()]);
            if (virtualFileArray == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            Object[] objectArray = virtualFileArray;
            VirtualFile[] virtualFileArray2 = (VirtualFile[])objectArray;
            super(string, (Object[])Arrays.copyOf(virtualFileArray2, virtualFileArray2.length));
            this.project = project;
        }
    }

    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/kotlin/idea/versions/UnsupportedAbiVersionNotificationPanelProvider$ErrorNotificationPanel;", "Lcom/intellij/ui/EditorNotificationPanel;", "()V", "idea"})
    private static final class ErrorNotificationPanel
    extends EditorNotificationPanel {
        public ErrorNotificationPanel() {
            this.myLabel.setIcon(AllIcons.General.Error);
        }
    }

    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rJ\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000bH\u0002R8\u0010\u0003\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005 \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/versions/UnsupportedAbiVersionNotificationPanelProvider$Companion;", "", "()V", "KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/ui/EditorNotificationPanel;", "kotlin.jvm.PlatformType", "getKEY", "()Lcom/intellij/openapi/util/Key;", "collectBadRoots", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "module", "Lcom/intellij/openapi/module/Module;", "navigateToLibraryRoot", "", "project", "Lcom/intellij/openapi/project/Project;", "root", "idea"})
    public static final class Companion {
        private final Key<EditorNotificationPanel> getKEY() {
            return KEY;
        }

        private final void navigateToLibraryRoot(Project project, VirtualFile root) {
            new OpenFileDescriptor(project, root).navigate(true);
        }

        @NotNull
        public final Collection<VirtualFile> collectBadRoots(@NotNull Module module) {
            Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
            Collection<VirtualFile> badJVMRoots = KotlinRuntimeLibraryUtilKt.getLibraryRootsWithAbiIncompatibleKotlinClasses(module);
            Collection<VirtualFile> badJSRoots = KotlinRuntimeLibraryUtilKt.getLibraryRootsWithAbiIncompatibleForKotlinJs(module);
            if (badJVMRoots.isEmpty() && badJSRoots.isEmpty()) {
                return CollectionsKt.emptyList();
            }
            return CollectionsKt.toHashSet((Iterable)CollectionsKt.plus(badJVMRoots, (Iterable)badJSRoots));
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

