/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.config;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.PathUtil;
import java.io.File;
import java.util.Collections;
import java.util.List;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.js.config.Config;
import org.jetbrains.kotlin.js.config.EcmaVersion;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.utils.KotlinJavascriptMetadata;
import org.jetbrains.kotlin.utils.KotlinJavascriptMetadataUtils;
import org.jetbrains.kotlin.utils.LibraryUtils;

public class LibrarySourcesConfig
extends Config {
    public static final List<String> JS_STDLIB = Collections.singletonList(org.jetbrains.kotlin.utils.PathUtil.getKotlinPathsForDistDirectory().getJsStdLibJarPath().getAbsolutePath());
    @NotNull
    public static final Key<String> EXTERNAL_MODULE_NAME = Key.create((String)"externalModule");
    @NotNull
    public static final String UNKNOWN_EXTERNAL_MODULE_NAME = "<unknown>";
    public static final String STDLIB_JS_MODULE_NAME = "stdlib";
    public static final String BUILTINS_JS_MODULE_NAME = "builtins";
    public static final String BUILTINS_JS_FILE_NAME = "builtins.js";
    public static final String STDLIB_JS_FILE_NAME = "stdlib.js";
    private final boolean isUnitTestConfig;
    @NotNull
    private final List<String> files;

    private LibrarySourcesConfig(@NotNull Project project, @NotNull String moduleId, @NotNull List<String> files, @NotNull EcmaVersion ecmaVersion, boolean sourceMap, boolean inlineEnabled, boolean isUnitTestConfig, boolean metaInfo, boolean kjsm) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/js/config/LibrarySourcesConfig", "<init>"));
        }
        if (moduleId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleId", "org/jetbrains/kotlin/js/config/LibrarySourcesConfig", "<init>"));
        }
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/jetbrains/kotlin/js/config/LibrarySourcesConfig", "<init>"));
        }
        if (ecmaVersion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ecmaVersion", "org/jetbrains/kotlin/js/config/LibrarySourcesConfig", "<init>"));
        }
        super(project, moduleId, ecmaVersion, sourceMap, inlineEnabled, metaInfo, kjsm);
        this.files = files;
        this.isUnitTestConfig = isUnitTestConfig;
    }

    @Override
    public boolean isTestConfig() {
        return this.isUnitTestConfig;
    }

    @NotNull
    public List<String> getLibraries() {
        List<String> list2 = this.files;
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/config/LibrarySourcesConfig", "getLibraries"));
        }
        return list2;
    }

    @Override
    protected void init(final @NotNull List<KtFile> sourceFilesInLibraries, final @NotNull List<KotlinJavascriptMetadata> metadata) {
        if (sourceFilesInLibraries == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceFilesInLibraries", "org/jetbrains/kotlin/js/config/LibrarySourcesConfig", "init"));
        }
        if (metadata == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "metadata", "org/jetbrains/kotlin/js/config/LibrarySourcesConfig", "init"));
        }
        if (this.files.isEmpty()) {
            return;
        }
        final PsiManager psiManager = PsiManager.getInstance((Project)this.getProject());
        Function1<String, Unit> report2 = new Function1<String, Unit>(){

            public Unit invoke(String message2) {
                throw new IllegalStateException(message2);
            }
        };
        Function2<String, VirtualFile, Unit> action2 = new Function2<String, VirtualFile, Unit>(){

            public Unit invoke(String moduleName, VirtualFile file) {
                if (moduleName != null) {
                    JetFileCollector jetFileCollector = new JetFileCollector(sourceFilesInLibraries, moduleName, psiManager);
                    VfsUtilCore.visitChildrenRecursively((VirtualFile)file, (VirtualFileVisitor)jetFileCollector);
                } else {
                    String libraryPath = PathUtil.getLocalPath((VirtualFile)file);
                    assert (libraryPath != null) : "libraryPath for " + file + " should not be null";
                    metadata.addAll(KotlinJavascriptMetadataUtils.loadMetadata(libraryPath));
                }
                return Unit.INSTANCE;
            }
        };
        boolean hasErrors = this.checkLibFilesAndReportErrors(report2, action2);
        assert (!hasErrors) : "hasErrors should be false";
    }

    @Override
    public boolean checkLibFilesAndReportErrors(@NotNull Function1<String, Unit> report2) {
        if (report2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "report", "org/jetbrains/kotlin/js/config/LibrarySourcesConfig", "checkLibFilesAndReportErrors"));
        }
        return this.checkLibFilesAndReportErrors(report2, null);
    }

    private boolean checkLibFilesAndReportErrors(@NotNull Function1<String, Unit> report2, @Nullable Function2<String, VirtualFile, Unit> action2) {
        if (report2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "report", "org/jetbrains/kotlin/js/config/LibrarySourcesConfig", "checkLibFilesAndReportErrors"));
        }
        if (this.files.isEmpty()) {
            return false;
        }
        VirtualFileSystem fileSystem = VirtualFileManager.getInstance().getFileSystem("file");
        VirtualFileSystem jarFileSystem = VirtualFileManager.getInstance().getFileSystem("jar");
        for (String path : this.files) {
            String moduleName;
            File filePath = new File(path);
            if (!filePath.exists()) {
                report2.invoke((Object)("Path '" + path + "' does not exist"));
                return true;
            }
            VirtualFile file = path.endsWith(".jar") || path.endsWith(".zip") ? jarFileSystem.findFileByPath(path + "!/") : fileSystem.findFileByPath(path);
            if (file == null) {
                report2.invoke((Object)("File '" + path + "' does not exist or could not be read"));
                return true;
            }
            if (LibraryUtils.isOldKotlinJavascriptLibrary(filePath)) {
                moduleName = LibraryUtils.getKotlinJsModuleName(filePath);
            } else {
                List<KotlinJavascriptMetadata> metadataList = KotlinJavascriptMetadataUtils.loadMetadata(filePath);
                if (metadataList.isEmpty()) {
                    report2.invoke((Object)("'" + path + "' is not a valid Kotlin Javascript library"));
                    return true;
                }
                for (KotlinJavascriptMetadata metadata : metadataList) {
                    if (metadata.isAbiVersionCompatible()) continue;
                    report2.invoke((Object)("File '" + path + "' was compiled with an incompatible version of Kotlin. " + "Its ABI version is " + metadata.getAbiVersion() + ", expected ABI version is " + KotlinJavascriptMetadataUtils.ABI_VERSION));
                    return true;
                }
                moduleName = null;
            }
            if (action2 == null) continue;
            action2.invoke((Object)moduleName, (Object)file);
        }
        return false;
    }

    protected static KtFile getJetFileByVirtualFile(VirtualFile file, String moduleName, PsiManager psiManager) {
        PsiFile psiFile = psiManager.findFile(file);
        assert (psiFile != null);
        LibrarySourcesConfig.setupPsiFile(psiFile, moduleName);
        return (KtFile)psiFile;
    }

    protected static void setupPsiFile(PsiFile psiFile, String moduleName) {
        psiFile.putUserData(EXTERNAL_MODULE_NAME, (Object)moduleName);
    }

    private static class JetFileCollector
    extends VirtualFileVisitor {
        private final List<KtFile> jetFiles;
        private final String moduleName;
        private final PsiManager psiManager;

        private JetFileCollector(List<KtFile> files, String name2, PsiManager manager) {
            super(new VirtualFileVisitor.Option[0]);
            this.moduleName = name2;
            this.psiManager = manager;
            this.jetFiles = files;
        }

        public boolean visitFile(@NotNull VirtualFile file) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/js/config/LibrarySourcesConfig$JetFileCollector", "visitFile"));
            }
            if (!file.isDirectory() && StringUtil.notNullize((String)file.getExtension()).equalsIgnoreCase("kt")) {
                this.jetFiles.add(LibrarySourcesConfig.getJetFileByVirtualFile(file, this.moduleName, this.psiManager));
            }
            return true;
        }
    }

    public static class Builder {
        Project project;
        String moduleId;
        List<String> files;
        @NotNull
        EcmaVersion ecmaVersion;
        boolean sourceMap;
        boolean inlineEnabled;
        boolean isUnitTestConfig;
        boolean metaInfo;
        boolean kjsm;

        public Builder(@NotNull Project project, @NotNull String moduleId, @NotNull List<String> files) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/js/config/LibrarySourcesConfig$Builder", "<init>"));
            }
            if (moduleId == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleId", "org/jetbrains/kotlin/js/config/LibrarySourcesConfig$Builder", "<init>"));
            }
            if (files == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/jetbrains/kotlin/js/config/LibrarySourcesConfig$Builder", "<init>"));
            }
            this.ecmaVersion = EcmaVersion.defaultVersion();
            this.sourceMap = false;
            this.inlineEnabled = true;
            this.isUnitTestConfig = false;
            this.metaInfo = false;
            this.kjsm = false;
            this.project = project;
            this.moduleId = moduleId;
            this.files = files;
        }

        public Builder ecmaVersion(@NotNull EcmaVersion ecmaVersion) {
            if (ecmaVersion == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ecmaVersion", "org/jetbrains/kotlin/js/config/LibrarySourcesConfig$Builder", "ecmaVersion"));
            }
            this.ecmaVersion = ecmaVersion;
            return this;
        }

        public Builder sourceMap(boolean sourceMap) {
            this.sourceMap = sourceMap;
            return this;
        }

        public Builder inlineEnabled(boolean inlineEnabled) {
            this.inlineEnabled = inlineEnabled;
            return this;
        }

        public Builder isUnitTestConfig(boolean isUnitTestConfig) {
            this.isUnitTestConfig = isUnitTestConfig;
            return this;
        }

        public Builder metaInfo(boolean metaInfo) {
            this.metaInfo = metaInfo;
            return this;
        }

        public Builder kjsm(boolean kjsm) {
            this.kjsm = kjsm;
            return this;
        }

        public Config build() {
            return new LibrarySourcesConfig(this.project, this.moduleId, this.files, this.ecmaVersion, this.sourceMap, this.inlineEnabled, this.isUnitTestConfig, this.metaInfo, this.kjsm);
        }
    }
}

