/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.process;

import com.intellij.execution.TaskExecutor;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.process.ProcessWaitFor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.Consumer;
import com.intellij.util.io.BaseDataReader;
import com.intellij.util.io.BaseInputStreamReader;
import com.intellij.util.io.BaseOutputReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BaseOSProcessHandler
extends ProcessHandler
implements TaskExecutor {
    private static final Logger LOG = Logger.getInstance(BaseOSProcessHandler.class);
    protected final Process myProcess;
    protected final String myCommandLine;
    protected final Charset myCharset;
    protected final ProcessWaitFor myWaitFor;

    public BaseOSProcessHandler(@NotNull Process process, @Nullable String commandLine, @Nullable Charset charset) {
        if (process == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "com/intellij/execution/process/BaseOSProcessHandler", "<init>"));
        }
        this.myProcess = process;
        this.myCommandLine = commandLine;
        this.myCharset = charset;
        this.myWaitFor = new ProcessWaitFor(process, this);
    }

    protected Future<?> executeOnPooledThread(Runnable task) {
        return ExecutorServiceHolder.ourThreadExecutorsService.submit(task);
    }

    @Override
    public Future<?> executeTask(Runnable task) {
        return this.executeOnPooledThread(task);
    }

    @NotNull
    public Process getProcess() {
        Process process = this.myProcess;
        if (process == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/process/BaseOSProcessHandler", "getProcess"));
        }
        return process;
    }

    protected boolean useAdaptiveSleepingPolicyWhenReadingOutput() {
        return false;
    }

    protected boolean useNonBlockingRead() {
        return !Registry.is("output.reader.blocking.mode", false);
    }

    protected boolean processHasSeparateErrorStream() {
        return true;
    }

    @Override
    public void startNotify() {
        if (this.myCommandLine != null) {
            this.notifyTextAvailable(this.myCommandLine + '\n', ProcessOutputTypes.SYSTEM);
        }
        this.addProcessListener(new ProcessAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startNotified(ProcessEvent event) {
                try {
                    final BaseDataReader stdOutReader = BaseOSProcessHandler.this.createOutputDataReader(BaseOSProcessHandler.this.getPolicy());
                    final BaseDataReader stdErrReader = BaseOSProcessHandler.this.processHasSeparateErrorStream() ? BaseOSProcessHandler.this.createErrorDataReader(BaseOSProcessHandler.this.getPolicy()) : null;
                    BaseOSProcessHandler.this.myWaitFor.setTerminationCallback(new Consumer<Integer>(){

                        @Override
                        public void consume(Integer exitCode) {
                            try {
                                if (stdErrReader != null) {
                                    stdErrReader.stop();
                                }
                                stdOutReader.stop();
                                try {
                                    if (stdErrReader != null) {
                                        stdErrReader.waitFor();
                                    }
                                    stdOutReader.waitFor();
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                }
                            }
                            finally {
                                BaseOSProcessHandler.this.onOSProcessTerminated(exitCode);
                            }
                        }
                    });
                }
                finally {
                    BaseOSProcessHandler.this.removeProcessListener(this);
                }
            }
        });
        super.startNotify();
    }

    private BaseDataReader.SleepingPolicy getPolicy() {
        if (this.useNonBlockingRead()) {
            return this.useAdaptiveSleepingPolicyWhenReadingOutput() ? new BaseDataReader.AdaptiveSleepingPolicy() : BaseDataReader.SleepingPolicy.SIMPLE;
        }
        return BaseDataReader.SleepingPolicy.BLOCKING;
    }

    @NotNull
    protected BaseDataReader createErrorDataReader(BaseDataReader.SleepingPolicy sleepingPolicy) {
        SimpleOutputReader simpleOutputReader = new SimpleOutputReader(this.createProcessErrReader(), ProcessOutputTypes.STDERR, sleepingPolicy);
        if (simpleOutputReader == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/process/BaseOSProcessHandler", "createErrorDataReader"));
        }
        return simpleOutputReader;
    }

    @NotNull
    protected BaseDataReader createOutputDataReader(BaseDataReader.SleepingPolicy sleepingPolicy) {
        SimpleOutputReader simpleOutputReader = new SimpleOutputReader(this.createProcessOutReader(), ProcessOutputTypes.STDOUT, sleepingPolicy);
        if (simpleOutputReader == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/process/BaseOSProcessHandler", "createOutputDataReader"));
        }
        return simpleOutputReader;
    }

    protected void onOSProcessTerminated(int exitCode) {
        this.notifyProcessTerminated(exitCode);
    }

    protected Reader createProcessOutReader() {
        return this.createInputStreamReader(this.myProcess.getInputStream());
    }

    protected Reader createProcessErrReader() {
        return this.createInputStreamReader(this.myProcess.getErrorStream());
    }

    private Reader createInputStreamReader(InputStream streamToRead) {
        Charset charset = this.charsetNotNull();
        return new BaseInputStreamReader(streamToRead, charset);
    }

    private Charset charsetNotNull() {
        Charset charset = this.getCharset();
        if (charset == null) {
            charset = Charset.defaultCharset();
        }
        return charset;
    }

    @Override
    protected void destroyProcessImpl() {
        try {
            this.closeStreams();
        }
        finally {
            this.doDestroyProcess();
        }
    }

    protected void doDestroyProcess() {
        this.getProcess().destroy();
    }

    @Override
    protected void detachProcessImpl() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                BaseOSProcessHandler.this.closeStreams();
                BaseOSProcessHandler.this.myWaitFor.detach();
                BaseOSProcessHandler.this.notifyProcessDetached();
            }
        };
        this.executeOnPooledThread(runnable);
    }

    protected void closeStreams() {
        try {
            this.myProcess.getOutputStream().close();
        }
        catch (IOException e) {
            LOG.warn(e);
        }
    }

    @Override
    public boolean detachIsDefault() {
        return false;
    }

    @Override
    public OutputStream getProcessInput() {
        return this.myProcess.getOutputStream();
    }

    @Nullable
    public String getCommandLine() {
        return this.myCommandLine;
    }

    @Nullable
    public Charset getCharset() {
        return this.myCharset;
    }

    private class SimpleOutputReader
    extends BaseOutputReader {
        private final Key myProcessOutputType;

        private SimpleOutputReader(@NotNull Reader reader, Key processOutputType, BaseDataReader.SleepingPolicy sleepingPolicy) {
            if (reader == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "com/intellij/execution/process/BaseOSProcessHandler$SimpleOutputReader", "<init>"));
            }
            if (processOutputType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processOutputType", "com/intellij/execution/process/BaseOSProcessHandler$SimpleOutputReader", "<init>"));
            }
            super(reader, sleepingPolicy);
            this.myProcessOutputType = processOutputType;
            this.start();
        }

        @Override
        protected Future<?> executeOnPooledThread(Runnable runnable) {
            return BaseOSProcessHandler.this.executeOnPooledThread(runnable);
        }

        @Override
        protected void onTextAvailable(@NotNull String text) {
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/execution/process/BaseOSProcessHandler$SimpleOutputReader", "onTextAvailable"));
            }
            BaseOSProcessHandler.this.notifyTextAvailable(text, this.myProcessOutputType);
        }
    }

    public static class ExecutorServiceHolder {
        private static final ExecutorService ourThreadExecutorsService = ExecutorServiceHolder.createServiceImpl();

        private static ThreadPoolExecutor createServiceImpl() {
            ThreadFactory factory = ConcurrencyUtil.newNamedThreadFactory("OSProcessHandler pooled thread");
            return new ThreadPoolExecutor(10, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), factory);
        }

        public static Future<?> submit(Runnable task) {
            return ourThreadExecutorsService.submit(task);
        }
    }
}

