/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.kotlin;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.load.java.JvmAbi;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtScript;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004H\u0003J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\u000eH\u0007J\u0018\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\u000eH\u0007J\u0010\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0004H\u0007J\u001c\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\n0\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\n0\u0016H\u0007J\u0018\u0010\u0017\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0004H\u0007J\u0010\u0010\u0017\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0007J\u0010\u0010\u0018\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nH\u0007J\u0010\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004H\u0007J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\t\u001a\u00020\u000eH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/load/kotlin/PackagePartClassUtils;", "", "()V", "PART_CLASS_NAME_SUFFIX", "", "capitalizeAsJavaClassName", "str", "fileHasTopLevelCallables", "", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "getDefaultFileClassFqName", "Lorg/jetbrains/kotlin/name/FqName;", "packageFqName", "Lcom/intellij/openapi/vfs/VirtualFile;", "getDefaultPartFqName", "facadeClassFqName", "getFilePartShortName", "fileName", "getFilesWithCallables", "", "files", "", "getPackagePartFqName", "getPackagePartInternalName", "getPartClassName", "getPathHashCode", "", "kotlin-compiler"})
public final class PackagePartClassUtils {
    private static final String PART_CLASS_NAME_SUFFIX = "Kt";
    public static final PackagePartClassUtils INSTANCE;

    @JvmStatic
    public static final int getPathHashCode(@NotNull VirtualFile file) {
        Intrinsics.checkParameterIsNotNull(file, "file");
        String $receiver$iv = file.getPath();
        String string = $receiver$iv;
        if (string == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string2 = string.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull(string2, "(this as java.lang.String).toLowerCase()");
        return string2.hashCode();
    }

    @JvmStatic
    @NotNull
    public static final String getPartClassName(@NotNull String str) {
        String string;
        Intrinsics.checkParameterIsNotNull(str, "str");
        CharSequence $receiver$iv = str;
        if ($receiver$iv.length() == 0) {
            string = "_" + PART_CLASS_NAME_SUFFIX;
        } else {
            StringBuilder stringBuilder = new StringBuilder();
            String string2 = JvmAbi.sanitizeAsJavaIdentifier(str);
            Intrinsics.checkExpressionValueIsNotNull(string2, "JvmAbi.sanitizeAsJavaIdentifier(str)");
            string = stringBuilder.append(PackagePartClassUtils.capitalizeAsJavaClassName(string2)).append(PART_CLASS_NAME_SUFFIX).toString();
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    private static final String capitalizeAsJavaClassName(String str) {
        String string;
        if (Character.isJavaIdentifierStart(str.charAt(0))) {
            void startIndex$iv;
            void locale$iv22;
            String string2;
            void endIndex$iv;
            void startIndex$iv22;
            String $receiver$iv;
            String string3 = str;
            boolean bl = false;
            boolean bl2 = true;
            StringBuilder stringBuilder = new StringBuilder();
            void v0 = $receiver$iv;
            if (v0 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string4 = ((String)v0).substring((int)startIndex$iv22, (int)endIndex$iv);
            Intrinsics.checkExpressionValueIsNotNull(string4, "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            $receiver$iv = string2 = string4;
            Locale locale = Locale.ENGLISH;
            Intrinsics.checkExpressionValueIsNotNull(locale, "Locale.ENGLISH");
            Locale startIndex$iv22 = locale;
            String string5 = $receiver$iv;
            if (string5 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string6 = string5.toUpperCase((Locale)locale$iv22);
            Intrinsics.checkExpressionValueIsNotNull(string6, "(this as java.lang.String).toUpperCase(locale)");
            string2 = string6;
            $receiver$iv = str;
            boolean locale$iv22 = true;
            stringBuilder = stringBuilder.append(string2);
            String string7 = $receiver$iv;
            if (string7 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string8 = string7.substring((int)startIndex$iv);
            Intrinsics.checkExpressionValueIsNotNull(string8, "(this as java.lang.String).substring(startIndex)");
            string2 = string8;
            string = stringBuilder.append(string2).toString();
        } else {
            string = "_" + str;
        }
        return string;
    }

    @JvmStatic
    @NotNull
    public static final FqName getDefaultFileClassFqName(@NotNull FqName packageFqName, @NotNull VirtualFile file) {
        Intrinsics.checkParameterIsNotNull(packageFqName, "packageFqName");
        Intrinsics.checkParameterIsNotNull(file, "file");
        String string = file.getName();
        Intrinsics.checkExpressionValueIsNotNull(string, "file.name");
        return PackagePartClassUtils.getPackagePartFqName(packageFqName, string);
    }

    @JvmStatic
    @NotNull
    public static final FqName getDefaultPartFqName(@NotNull FqName facadeClassFqName, @NotNull VirtualFile file) {
        Intrinsics.checkParameterIsNotNull(facadeClassFqName, "facadeClassFqName");
        Intrinsics.checkParameterIsNotNull(file, "file");
        FqName fqName2 = facadeClassFqName.parent();
        Intrinsics.checkExpressionValueIsNotNull(fqName2, "facadeClassFqName.parent()");
        String string = file.getName();
        Intrinsics.checkExpressionValueIsNotNull(string, "file.name");
        return PackagePartClassUtils.getPackagePartFqName(fqName2, string);
    }

    @JvmStatic
    @NotNull
    public static final FqName getPackagePartFqName(@NotNull FqName packageFqName, @NotNull String fileName) {
        Intrinsics.checkParameterIsNotNull(packageFqName, "packageFqName");
        Intrinsics.checkParameterIsNotNull(fileName, "fileName");
        String partClassName = PackagePartClassUtils.getFilePartShortName(fileName);
        FqName fqName2 = packageFqName.child(Name.identifier(partClassName));
        Intrinsics.checkExpressionValueIsNotNull(fqName2, "packageFqName.child(Name\u2026dentifier(partClassName))");
        return fqName2;
    }

    @Deprecated(message="Migrate to JvmFileClassesProvider")
    @JvmStatic
    @NotNull
    public static final String getPackagePartInternalName(@NotNull KtFile file) {
        Intrinsics.checkParameterIsNotNull(file, "file");
        String string = JvmClassName.byFqNameWithoutInnerClasses(PackagePartClassUtils.getPackagePartFqName(file)).getInternalName();
        Intrinsics.checkExpressionValueIsNotNull(string, "JvmClassName.byFqNameWit\u2026qName(file)).internalName");
        return string;
    }

    @Deprecated(message="Migrate to JvmFileClassesProvider")
    @JvmStatic
    @NotNull
    public static final FqName getPackagePartFqName(@NotNull KtFile file) {
        Intrinsics.checkParameterIsNotNull(file, "file");
        FqName fqName2 = file.getPackageFqName();
        Intrinsics.checkExpressionValueIsNotNull(fqName2, "file.packageFqName");
        String string = file.getName();
        Intrinsics.checkExpressionValueIsNotNull(string, "file.name");
        return PackagePartClassUtils.getPackagePartFqName(fqName2, string);
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final List<KtFile> getFilesWithCallables(@NotNull Collection<? extends KtFile> files) {
        void var3_3;
        void $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull(files, "files");
        Iterable $receiver$iv = files;
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            KtFile it = (KtFile)element$iv$iv;
            if (!PackagePartClassUtils.fileHasTopLevelCallables(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)var3_3;
    }

    @JvmStatic
    public static final boolean fileHasTopLevelCallables(@NotNull KtFile file) {
        boolean bl;
        block1: {
            Intrinsics.checkParameterIsNotNull(file, "file");
            Iterable $receiver$iv = file.getDeclarations();
            for (Object element$iv : $receiver$iv) {
                KtDeclaration it = (KtDeclaration)element$iv;
                if (!(it instanceof KtProperty || it instanceof KtNamedFunction || it instanceof KtScript)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    @JvmStatic
    @NotNull
    public static final String getFilePartShortName(@NotNull String fileName) {
        Intrinsics.checkParameterIsNotNull(fileName, "fileName");
        String string = FileUtil.getNameWithoutExtension(fileName);
        Intrinsics.checkExpressionValueIsNotNull(string, "FileUtil.getNameWithoutExtension(fileName)");
        return PackagePartClassUtils.getPartClassName(string);
    }

    private PackagePartClassUtils() {
        INSTANCE = this;
        PART_CLASS_NAME_SUFFIX = PART_CLASS_NAME_SUFFIX;
    }

    static {
        new PackagePartClassUtils();
    }
}

