/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.registry;

import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.SetMultimap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.api.Nullable;
import org.gradle.model.internal.core.ModelNode;
import org.gradle.model.internal.core.ModelPath;
import org.gradle.model.internal.registry.ModelCreationListener;
import org.gradle.model.internal.registry.ModelNodeInternal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ModelGraph {
    private final ModelNodeInternal root;
    private final Map<ModelPath, ModelNodeInternal> flattened = Maps.newTreeMap();
    private final SetMultimap<ModelPath, ModelCreationListener> pathListeners = LinkedHashMultimap.create();
    private final SetMultimap<ModelPath, ModelCreationListener> parentListeners = LinkedHashMultimap.create();
    private final SetMultimap<ModelPath, ModelCreationListener> ancestorListeners = LinkedHashMultimap.create();
    private final Set<ModelCreationListener> listeners = new LinkedHashSet<ModelCreationListener>();
    private boolean notifying;
    private final List<ModelCreationListener> pendingListeners = new ArrayList<ModelCreationListener>();
    private final List<ModelNodeInternal> pendingNodes = new ArrayList<ModelNodeInternal>();

    public ModelGraph(ModelNodeInternal rootNode) {
        this.root = rootNode;
        this.flattened.put(this.root.getPath(), this.root);
    }

    public ModelNodeInternal getRoot() {
        return this.root;
    }

    public Map<ModelPath, ModelNodeInternal> getFlattened() {
        return Collections.unmodifiableMap(this.flattened);
    }

    public void add(ModelNodeInternal node) {
        if (this.notifying) {
            this.pendingNodes.add(node);
            return;
        }
        this.doAdd(node);
        this.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doAdd(ModelNodeInternal node) {
        this.flattened.put(node.getPath(), node);
        this.notifying = true;
        try {
            this.notifyListeners(node, this.pathListeners.get((Object)node.getPath()));
            this.notifyListeners(node, this.parentListeners.get((Object)node.getPath().getParent()));
            this.notifyListeners(node, this.listeners);
            if (!this.ancestorListeners.isEmpty()) {
                for (ModelPath path = node.getPath().getParent(); path != null; path = path.getParent()) {
                    this.notifyListeners(node, this.ancestorListeners.get((Object)path));
                }
            }
        }
        finally {
            this.notifying = false;
        }
    }

    private void notifyListeners(ModelNodeInternal node, Iterable<ModelCreationListener> listeners) {
        Iterator<ModelCreationListener> iterator = listeners.iterator();
        while (iterator.hasNext()) {
            ModelCreationListener listener = iterator.next();
            if (!this.maybeNotify(node, listener)) continue;
            iterator.remove();
        }
    }

    public void addListener(ModelCreationListener listener) {
        if (this.notifying) {
            this.pendingListeners.add(listener);
            return;
        }
        this.doAddListener(listener);
        this.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doAddListener(ModelCreationListener listener) {
        this.notifying = true;
        try {
            if (listener.getPath() != null) {
                this.addPathListener(listener);
                return;
            }
            if (listener.getParent() != null) {
                this.addParentListener(listener);
                return;
            }
            if (listener.getAncestor() != null) {
                this.addAncestorListener(listener);
                return;
            }
            this.addEverythingListener(listener);
        }
        finally {
            this.notifying = false;
        }
    }

    private void addEverythingListener(ModelCreationListener listener) {
        for (ModelNodeInternal node : this.flattened.values()) {
            if (!this.maybeNotify(node, listener)) continue;
            return;
        }
        this.listeners.add(listener);
    }

    private void addAncestorListener(ModelCreationListener listener) {
        if (listener.getAncestor().equals(ModelPath.ROOT)) {
            this.addEverythingListener(listener);
            return;
        }
        ModelNodeInternal ancestor = this.flattened.get(listener.getAncestor());
        if (ancestor != null) {
            LinkedList<ModelNodeInternal> queue = new LinkedList<ModelNodeInternal>();
            queue.add(ancestor);
            while (!queue.isEmpty()) {
                ModelNodeInternal parent = (ModelNodeInternal)queue.removeFirst();
                for (ModelNodeInternal modelNodeInternal : parent.getLinks()) {
                    if (this.maybeNotify(modelNodeInternal, listener)) {
                        return;
                    }
                    queue.addFirst(modelNodeInternal);
                }
            }
        }
        this.ancestorListeners.put((Object)listener.getAncestor(), (Object)listener);
    }

    private void addParentListener(ModelCreationListener listener) {
        ModelNodeInternal parent = this.flattened.get(listener.getParent());
        if (parent != null) {
            for (ModelNodeInternal modelNodeInternal : parent.getLinks()) {
                if (!this.maybeNotify(modelNodeInternal, listener)) continue;
                return;
            }
        }
        this.parentListeners.put((Object)listener.getParent(), (Object)listener);
    }

    private void addPathListener(ModelCreationListener listener) {
        ModelNodeInternal node = this.flattened.get(listener.getPath());
        if (node != null && this.maybeNotify(node, listener)) {
            return;
        }
        this.pathListeners.put((Object)listener.getPath(), (Object)listener);
    }

    private void flush() {
        while (!this.pendingListeners.isEmpty()) {
            this.doAddListener(this.pendingListeners.remove(0));
        }
        while (!this.pendingNodes.isEmpty()) {
            this.doAdd(this.pendingNodes.remove(0));
        }
    }

    private boolean maybeNotify(ModelNodeInternal node, ModelCreationListener listener) {
        if (listener.getType() != null && !node.getPromise().canBeViewedAsWritable(listener.getType()) && !node.getPromise().canBeViewedAsReadOnly(listener.getType())) {
            return false;
        }
        return listener.onCreate(node);
    }

    @Nullable
    public ModelNodeInternal find(ModelPath path) {
        return this.flattened.get(path);
    }

    public ModelNodeInternal get(ModelPath path) {
        ModelNodeInternal found = this.find(path);
        if (found == null) {
            throw new IllegalStateException("Expected model node @ '" + path + "' but none was found");
        }
        return found;
    }

    public Iterable<ModelNodeInternal> findAllInScope(ModelPath scope) {
        ModelNodeInternal node = this.flattened.get(scope);
        if (node == null) {
            return Collections.emptyList();
        }
        return Iterables.concat(Collections.singleton(node), node.getLinks());
    }

    @Nullable
    public ModelNodeInternal remove(ModelNode node) {
        ModelNodeInternal parentNode = this.find(node.getPath().getParent());
        if (parentNode != null) {
            parentNode.removeLink(node.getPath().getName());
        }
        return this.flattened.remove(node.getPath());
    }
}

