/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.settingsRepository;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.settingsRepository.BaseRepositoryManagerKt;
import org.jetbrains.settingsRepository.IcsManagerKt;
import org.jetbrains.settingsRepository.RepositoryManager;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J(\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H$J\u0018\u0010\u0014\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0014\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0015\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u0017H$J\b\u0010\u0018\u001a\u00020\fH\u0016J\u0010\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J>\u0010\u001b\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00170\u001d2\u0018\u0010\u001e\u001a\u0014\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020\u00170\u001fH\u0016J\u0012\u0010!\u001a\u0004\u0018\u00010 2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J \u0010\"\u001a\u00020\u00172\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006#"}, d2={"Lorg/jetbrains/settingsRepository/BaseRepositoryManager;", "Lorg/jetbrains/settingsRepository/RepositoryManager;", "dir", "Ljava/io/File;", "(Ljava/io/File;)V", "getDir", "()Ljava/io/File;", "lock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "getLock", "()Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "addToIndex", "", "file", "path", "", "content", "", "size", "", "delete", "deleteFromIndex", "isFile", "", "deleteRepository", "has", "isPathIgnored", "processChildren", "filter", "Lkotlin/Function1;", "processor", "Lkotlin/Function2;", "Ljava/io/InputStream;", "read", "write", "settings-repository"})
public abstract class BaseRepositoryManager
implements RepositoryManager {
    @NotNull
    private final ReentrantReadWriteLock lock;
    @NotNull
    private final File dir;

    @NotNull
    protected final ReentrantReadWriteLock getLock() {
        return this.lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void processChildren(@NotNull String path, @NotNull Function1<? super String, Boolean> filter, @NotNull Function2<? super String, ? super InputStream, Boolean> processor) {
        Object files2;
        block14: {
            block13: {
                Object[] $receiver$iv;
                Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
                Intrinsics.checkParameterIsNotNull(filter, (String)"filter");
                Intrinsics.checkParameterIsNotNull(processor, (String)"processor");
                Ref.ObjectRef objectRef = new Ref.ObjectRef();
                objectRef.element = null;
                ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
                ReentrantReadWriteLock.ReadLock rl$iv = $receiver$iv.readLock();
                rl$iv.lock();
                try {
                    files2.element = new File(this.dir, path).listFiles(new FilenameFilter(this, files2, path, filter){
                        final /* synthetic */ BaseRepositoryManager this$0;
                        final /* synthetic */ Ref.ObjectRef $files$inlined;
                        final /* synthetic */ String $path$inlined;
                        final /* synthetic */ Function1 $filter$inlined;

                        public final boolean accept(File file, String name) {
                            String string = name;
                            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"name");
                            return (Boolean)this.$filter$inlined.invoke((Object)string);
                        }
                        {
                            this.this$0 = baseRepositoryManager;
                            this.$files$inlined = objectRef;
                            this.$path$inlined = string;
                            this.$filter$inlined = function1;
                        }
                    });
                    Unit unit = Unit.INSTANCE;
                }
                finally {
                    rl$iv.unlock();
                }
                if ((File[])files2.element == null) break block13;
                File[] fileArray = (File[])files2.element;
                if (fileArray == null) {
                    Intrinsics.throwNpe();
                }
                $receiver$iv = fileArray;
                if (!($receiver$iv.length == 0)) break block14;
            }
            return;
        }
        File[] fileArray = (File[])files2.element;
        if (fileArray == null) {
            Intrinsics.throwNpe();
        }
        File[] fileArray2 = fileArray;
        for (int i = 0; i < fileArray2.length; ++i) {
            String string;
            void $receiver$iv;
            File file = fileArray2[i];
            if (file.isDirectory() || file.isHidden()) continue;
            if (file.length() == 0L) {
                if (!file.exists()) continue;
                try {
                    IcsManagerKt.getLOG().warn("File " + path + " is empty (length 0), will be removed");
                    this.delete(file, path);
                }
                catch (Exception e) {
                    IcsManagerKt.getLOG().error((Throwable)e);
                }
                continue;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)file.getName(), (String)"file.name");
            File e = file;
            Function2<? super String, ? super InputStream, Boolean> function2 = processor;
            FileInputStream fileInputStream = new FileInputStream((File)$receiver$iv);
            if (!((Boolean)function2.invoke((Object)string, (Object)fileInputStream)).booleanValue()) break;
        }
        files2 = null;
    }

    @Override
    public void deleteRepository() {
        FileUtil.delete((File)this.dir);
    }

    protected boolean isPathIgnored(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public InputStream read(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        if (this.isPathIgnored(path)) {
            Logger $receiver$iv = IcsManagerKt.getLOG();
            if ($receiver$iv.isDebugEnabled()) {
                Logger logger = $receiver$iv;
                String string = path + " is ignored";
                logger.debug(string);
            }
            return null;
        }
        Ref.ObjectRef $receiver$iv = new Ref.ObjectRef();
        $receiver$iv.element = null;
        ReentrantReadWriteLock $receiver$iv2 = this.lock;
        ReentrantReadWriteLock.ReadLock rl$iv = $receiver$iv2.readLock();
        rl$iv.lock();
        try {
            File file = new File(this.dir, path);
            if (file.length() != 0L) {
                InputStream inputStream = new FileInputStream(file);
                return inputStream;
            }
            fileToDelete.element = file;
            Unit unit = Unit.INSTANCE;
        }
        finally {
            rl$iv.unlock();
        }
        try {
            int index$iv$iv;
            int it$iv;
            $receiver$iv2 = this.lock;
            rl$iv = $receiver$iv2.readLock();
            int readCount$iv = $receiver$iv2.getWriteHoldCount() == 0 ? $receiver$iv2.getReadHoldCount() : 0;
            int $i$a$2 = 0;
            int n = readCount$iv - 1;
            if ($i$a$2 <= n) {
                void index$iv$iv2;
                do {
                    it$iv = ++index$iv$iv2;
                    rl$iv.unlock();
                } while (index$iv$iv2 != n);
            }
            ReentrantReadWriteLock.WriteLock wl$iv = $receiver$iv2.writeLock();
            wl$iv.lock();
            try {
                void fileToDelete;
                File file = (File)fileToDelete.element;
                if (file == null) {
                    Intrinsics.throwNpe();
                }
                if (file.exists()) {
                    File file2 = (File)fileToDelete.element;
                    if (file2 == null) {
                        Intrinsics.throwNpe();
                    }
                    if (file2.length() == 0L) {
                        IcsManagerKt.getLOG().warn("File " + path + " is empty (length 0), will be removed");
                        File file3 = (File)fileToDelete.element;
                        if (file3 == null) {
                            Intrinsics.throwNpe();
                        }
                        this.delete(file3, path);
                    }
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable) {
                index$iv$iv = 0;
                int n2 = readCount$iv - 1;
                if (index$iv$iv <= n2) {
                    do {
                        int it$iv2 = ++index$iv$iv;
                        rl$iv.lock();
                    } while (index$iv$iv != n2);
                }
                wl$iv.unlock();
                throw throwable;
            }
            it$iv = 0;
            int n3 = readCount$iv - 1;
            if (it$iv <= n3) {
                do {
                    int it$iv3 = ++index$iv$iv;
                    rl$iv.lock();
                } while (index$iv$iv != n3);
            }
            wl$iv.unlock();
        }
        catch (Exception e) {
            IcsManagerKt.getLOG().error((Throwable)e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public boolean write(@NotNull String path, @NotNull byte[] content, int size) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Intrinsics.checkParameterIsNotNull((Object)content, (String)"content");
        if (this.isPathIgnored(path)) {
            void $receiver$iv;
            Logger logger = IcsManagerKt.getLOG();
            if ($receiver$iv.isDebugEnabled()) {
                void var17_7 = $receiver$iv;
                String string = path + " is ignored";
                var17_7.debug(string);
            }
            return false;
        }
        Object $receiver$iv = IcsManagerKt.getLOG();
        if ($receiver$iv.isDebugEnabled()) {
            Logger logger = $receiver$iv;
            String string = "Write " + path;
            logger.debug(string);
        }
        try {
            int index$iv$iv;
            int it$iv;
            $receiver$iv = this.lock;
            ReentrantReadWriteLock.ReadLock rl$iv = ((ReentrantReadWriteLock)$receiver$iv).readLock();
            int readCount$iv = ((ReentrantReadWriteLock)$receiver$iv).getWriteHoldCount() == 0 ? ((ReentrantReadWriteLock)$receiver$iv).getReadHoldCount() : 0;
            int n = 0;
            int n2 = readCount$iv - 1;
            if (n <= n2) {
                void index$iv$iv2;
                do {
                    it$iv = ++index$iv$iv2;
                    rl$iv.unlock();
                } while (index$iv$iv2 != n2);
            }
            ReentrantReadWriteLock.WriteLock wl$iv = ((ReentrantReadWriteLock)$receiver$iv).writeLock();
            wl$iv.lock();
            try {
                File file = new File(this.dir, path);
                FileUtil.writeToFile((File)file, (byte[])content, (int)0, (int)size);
                this.addToIndex(file, path, content, size);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable) {
                index$iv$iv = 0;
                int n3 = readCount$iv - 1;
                if (index$iv$iv <= n3) {
                    do {
                        int it$iv2 = ++index$iv$iv;
                        rl$iv.lock();
                    } while (index$iv$iv != n3);
                }
                wl$iv.unlock();
                throw throwable;
            }
            it$iv = 0;
            int n4 = readCount$iv - 1;
            if (it$iv <= n4) {
                do {
                    int it$iv3 = ++index$iv$iv;
                    rl$iv.lock();
                } while (index$iv$iv != n4);
            }
            wl$iv.unlock();
        }
        catch (Exception e) {
            IcsManagerKt.getLOG().error((Throwable)e);
            return false;
        }
        return true;
    }

    protected abstract void addToIndex(@NotNull File var1, @NotNull String var2, @NotNull byte[] var3, int var4);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void delete(@NotNull String path) {
        int index$iv$iv;
        int it$iv;
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Object $receiver$iv = IcsManagerKt.getLOG();
        if ($receiver$iv.isDebugEnabled()) {
            Logger logger = $receiver$iv;
            String string = "Remove " + path;
            logger.debug(string);
        }
        $receiver$iv = this.lock;
        ReentrantReadWriteLock.ReadLock rl$iv = ((ReentrantReadWriteLock)$receiver$iv).readLock();
        int readCount$iv = ((ReentrantReadWriteLock)$receiver$iv).getWriteHoldCount() == 0 ? ((ReentrantReadWriteLock)$receiver$iv).getReadHoldCount() : 0;
        int n = 0;
        int n2 = readCount$iv - 1;
        if (n <= n2) {
            void index$iv$iv2;
            do {
                it$iv = ++index$iv$iv2;
                rl$iv.unlock();
            } while (index$iv$iv2 != n2);
        }
        ReentrantReadWriteLock.WriteLock wl$iv = ((ReentrantReadWriteLock)$receiver$iv).writeLock();
        wl$iv.lock();
        try {
            File file = new File(this.dir, path);
            if (file.exists()) {
                this.delete(file, path);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            index$iv$iv = 0;
            int n3 = readCount$iv - 1;
            if (index$iv$iv <= n3) {
                do {
                    int it$iv2 = ++index$iv$iv;
                    rl$iv.lock();
                } while (index$iv$iv != n3);
            }
            wl$iv.unlock();
            throw throwable;
        }
        it$iv = 0;
        int n4 = readCount$iv - 1;
        if (it$iv <= n4) {
            do {
                int it$iv3 = ++index$iv$iv;
                rl$iv.lock();
            } while (index$iv$iv != n4);
        }
        wl$iv.unlock();
    }

    private final void delete(File file, String path) {
        boolean isFile = file.isFile();
        BaseRepositoryManagerKt.removeWithParentsIfEmpty(file, this.dir, isFile);
        this.deleteFromIndex(path, isFile);
    }

    protected abstract void deleteFromIndex(@NotNull String var1, boolean var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean has(@NotNull String path) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        ReentrantReadWriteLock $receiver$iv = this.lock;
        ReentrantReadWriteLock.ReadLock rl$iv = $receiver$iv.readLock();
        rl$iv.lock();
        try {
            bl = new File(this.dir, path).exists();
        }
        finally {
            rl$iv.unlock();
        }
        return bl;
    }

    @NotNull
    protected final File getDir() {
        return this.dir;
    }

    public BaseRepositoryManager(@NotNull File dir) {
        Intrinsics.checkParameterIsNotNull((Object)dir, (String)"dir");
        this.dir = dir;
        this.lock = new ReentrantReadWriteLock();
    }
}

