/*
 * Decompiled with CFR 0.152.
 */
package com.android.assetstudiolib;

import com.android.assetstudiolib.GraphicGenerator;
import com.android.assetstudiolib.GraphicGeneratorContext;
import com.android.assetstudiolib.Util;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;

public class MenuIconGenerator
extends GraphicGenerator {
    @Override
    public BufferedImage generate(GraphicGeneratorContext context, GraphicGenerator.Options options) {
        Rectangle imageSizeHdpi = new Rectangle(0, 0, 48, 48);
        Rectangle targetRectHdpi = new Rectangle(8, 8, 32, 32);
        float scaleFactor = GraphicGenerator.getMdpiScaleFactor(options.density);
        Rectangle imageRect = Util.scaleRectangle(imageSizeHdpi, scaleFactor);
        Rectangle targetRect = Util.scaleRectangle(targetRectHdpi, scaleFactor);
        BufferedImage outImage = Util.newArgbBufferedImage(imageRect.width, imageRect.height);
        Graphics2D g = (Graphics2D)outImage.getGraphics();
        BufferedImage tempImage = Util.newArgbBufferedImage(imageRect.width, imageRect.height);
        Graphics2D g2 = (Graphics2D)tempImage.getGraphics();
        Util.drawCenterInside(g2, options.sourceImage, targetRect);
        Util.drawEffects(g, tempImage, 0, 0, new Util.Effect[]{new Util.FillEffect(new GradientPaint(0.0f, 0.0f, new Color(0xA3A3A3), 0.0f, imageRect.height, new Color(0x787878))), new Util.ShadowEffect(0.0, 2.0f * scaleFactor, 2.0f * scaleFactor, Color.BLACK, 0.2, true), new Util.ShadowEffect(0.0, 1.0, 0.0, Color.BLACK, 0.35, true), new Util.ShadowEffect(0.0, -1.0, 0.0, Color.WHITE, 0.35, true)});
        g.dispose();
        g2.dispose();
        return outImage;
    }
}

