/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.service;

import com.android.tools.idea.gradle.AndroidProjectKeys;
import com.android.tools.idea.gradle.ImportedModule;
import com.android.tools.idea.startup.AndroidStudioSpecificInitializer;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractProjectDataService;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectCleanupDataService
extends AbstractProjectDataService<ImportedModule, Void> {
    @NotNull
    public Key<ImportedModule> getTargetDataKey() {
        Key<ImportedModule> key = AndroidProjectKeys.IMPORTED_MODULE;
        if (key == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/service/ProjectCleanupDataService", "getTargetDataKey"));
        }
        return key;
    }

    public void importData(@NotNull Collection<DataNode<ImportedModule>> toImport, @Nullable ProjectData projectData, @NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider) {
        if (toImport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toImport", "com/android/tools/idea/gradle/service/ProjectCleanupDataService", "importData"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/service/ProjectCleanupDataService", "importData"));
        }
        if (modelsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelsProvider", "com/android/tools/idea/gradle/service/ProjectCleanupDataService", "importData"));
        }
        if (!AndroidStudioSpecificInitializer.isAndroidStudio()) {
            return;
        }
        final ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
        Module[] modules = moduleManager.getModules();
        if (modules.length != toImport.size()) {
            final HashMap modulesByName = Maps.newHashMap();
            for (Module module : modules) {
                modulesByName.put(module.getName(), module);
            }
            for (DataNode dataNode : toImport) {
                String importedModuleName = ((ImportedModule)dataNode.getData()).getName();
                modulesByName.remove(importedModuleName);
            }
            if (!modulesByName.isEmpty()) {
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        ArrayList imlFilesToRemove = Lists.newArrayList();
                        ModifiableModuleModel moduleModel = moduleManager.getModifiableModel();
                        try {
                            for (Module module : modulesByName.values()) {
                                File imlFile = new File(FileUtil.toSystemDependentName((String)module.getModuleFilePath()));
                                imlFilesToRemove.add(imlFile);
                                moduleModel.disposeModule(module);
                            }
                        }
                        finally {
                            moduleModel.commit();
                        }
                        for (File imlFile : imlFilesToRemove) {
                            if (!imlFile.isFile()) continue;
                            FileUtil.delete((File)imlFile);
                        }
                    }
                });
            }
        }
    }
}

