/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.tools.idea.run.CloudConfiguration;
import com.android.tools.idea.run.CloudConfigurationComboBox;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.openapi.module.Module;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CloudConfigurationCoordinator {
    private static Map<CloudConfiguration.Kind, CloudConfigurationCoordinator> ourInstances = Maps.newHashMap();
    private final Set<CloudConfigurationComboBox> myComboBoxes = Sets.newHashSet();

    private CloudConfigurationCoordinator() {
    }

    public static CloudConfigurationCoordinator getInstance(CloudConfiguration.Kind kind) {
        CloudConfigurationCoordinator instance = ourInstances.get((Object)kind);
        if (instance == null) {
            instance = new CloudConfigurationCoordinator();
            ourInstances.put(kind, instance);
        }
        return instance;
    }

    public void addComboBox(CloudConfigurationComboBox comboBox) {
        this.myComboBoxes.add(comboBox);
    }

    public void removeComboBox(CloudConfigurationComboBox comboBox) {
        this.myComboBoxes.remove((Object)comboBox);
    }

    public void updateComboBoxesWithNewCloudConfigurations(List<? extends CloudConfiguration> cloudConfigurations, Module module) {
        for (CloudConfigurationComboBox comboBox : this.myComboBoxes) {
            comboBox.updateCloudConfigurations(cloudConfigurations, module);
        }
    }
}

