/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.wizard;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileTreeModel
implements TreeModel {
    private File myRoot;
    private Node myRootNode;
    private boolean myHideIrrelevantFiles;

    public FileTreeModel(@NotNull File root, boolean hideIrrelevantFiles) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/android/tools/idea/wizard/FileTreeModel", "<init>"));
        }
        this(root);
        this.myHideIrrelevantFiles = hideIrrelevantFiles;
    }

    public FileTreeModel(@NotNull File root) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/android/tools/idea/wizard/FileTreeModel", "<init>"));
        }
        this.myRoot = root;
        this.myRootNode = FileTreeModel.makeTree(root);
    }

    @Override
    public Object getRoot() {
        if (this.myHideIrrelevantFiles && !this.myRootNode.isProposedFile) {
            return null;
        }
        return this.myRootNode;
    }

    @Override
    public Object getChild(Object parent, int index) {
        Node n = (Node)parent;
        if (!this.myHideIrrelevantFiles) {
            return n.children.get(index);
        }
        for (int i = 0; i < n.children.size(); ++i) {
            Node child = n.children.get(i);
            if (child.isProposedFile && index == 0) {
                return child;
            }
            if (!child.isProposedFile) continue;
            --index;
        }
        return null;
    }

    @Override
    public int getChildCount(Object parent) {
        if (!this.myHideIrrelevantFiles) {
            return ((Node)parent).children.size();
        }
        int count = 0;
        for (Node n : ((Node)parent).children) {
            if (!n.isProposedFile) continue;
            ++count;
        }
        return count;
    }

    @Override
    public boolean isLeaf(Object node) {
        if (!this.myHideIrrelevantFiles) {
            return ((Node)node).children.isEmpty();
        }
        for (Node n : ((Node)node).children) {
            if (!n.isProposedFile) continue;
            return false;
        }
        return true;
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        if (!this.myHideIrrelevantFiles) {
            return ((Node)parent).children.indexOf(child);
        }
        Node n = (Node)parent;
        int index = 0;
        for (int i = 0; i < n.children.size(); ++i) {
            Node candidate = n.children.get(i);
            if (candidate.equals(child)) {
                return index;
            }
            if (!candidate.isProposedFile) continue;
            ++index;
        }
        return -1;
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
    }

    public boolean hasConflicts() {
        if (this.myRootNode == null) {
            return false;
        }
        return FileTreeModel.treeHasConflicts(this.myRootNode);
    }

    private static boolean treeHasConflicts(Node root) {
        if (root.isConflicted) {
            return true;
        }
        for (Node n : root.children) {
            if (!FileTreeModel.treeHasConflicts(n)) continue;
            return true;
        }
        return false;
    }

    public void addFile(@NotNull File f) {
        if (f == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "f", "com/android/tools/idea/wizard/FileTreeModel", "addFile"));
        }
        this.addFile(f, null);
    }

    public void addFile(@NotNull File f, @Nullable Icon ic) {
        String s;
        if (f == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "f", "com/android/tools/idea/wizard/FileTreeModel", "addFile"));
        }
        String string = s = f.isAbsolute() ? FileUtil.getRelativePath((File)this.myRoot, (File)f) : f.getPath();
        if (s != null) {
            LinkedList parts = Lists.newLinkedList((Iterable)Splitter.on((char)File.separatorChar).split((CharSequence)s));
            FileTreeModel.makeNode(this.myRootNode, parts, ic, false);
        }
    }

    public void forceAddFile(@NotNull File f, @Nullable Icon ic) {
        String s;
        if (f == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "f", "com/android/tools/idea/wizard/FileTreeModel", "forceAddFile"));
        }
        String string = s = f.isAbsolute() ? FileUtil.getRelativePath((File)this.myRoot, (File)f) : f.getPath();
        if (s != null) {
            LinkedList parts = Lists.newLinkedList((Iterable)Splitter.on((char)File.separatorChar).split((CharSequence)s));
            FileTreeModel.makeNode(this.myRootNode, parts, ic, true);
        }
    }

    private static void makeNode(@NotNull Node root, @NotNull List<String> path, @Nullable Icon ic, boolean markConflict) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/android/tools/idea/wizard/FileTreeModel", "makeNode"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/android/tools/idea/wizard/FileTreeModel", "makeNode"));
        }
        root.isProposedFile = true;
        if (path.isEmpty()) {
            return;
        }
        String name = path.get(0);
        if (markConflict && path.size() == 1 && root.name.equals(name)) {
            root.isConflicted = true;
            return;
        }
        if (root.name.equals(name)) {
            FileTreeModel.makeNode(root, FileTreeModel.rest(path), ic, markConflict);
        } else if (root.hasChild(name)) {
            if (markConflict && path.size() == 1) {
                Node targetNode = root.getChild(name);
                targetNode.isConflicted = true;
                targetNode.icon = ic;
                targetNode.isProposedFile = true;
                return;
            }
            FileTreeModel.makeNode(root.getChild(name), FileTreeModel.rest(path), ic, markConflict);
        } else {
            Node n = new Node();
            n.name = name;
            root.children.add(n);
            if (path.size() == 1) {
                n.icon = ic;
                n.isProposedFile = true;
            } else {
                FileTreeModel.makeNode(n, FileTreeModel.rest(path), ic, markConflict);
            }
        }
    }

    private static Node makeTree(@NotNull File root) {
        File[] children;
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/android/tools/idea/wizard/FileTreeModel", "makeTree"));
        }
        Node n = new Node();
        n.name = root.getName();
        n.existsOnDisk = root.exists();
        if (root.isDirectory() && (children = root.listFiles()) != null) {
            for (File f : children) {
                if (f.isHidden()) continue;
                n.children.add(FileTreeModel.makeTree(f));
            }
        }
        return n;
    }

    private static <T> List<T> rest(List<T> list) {
        return list.subList(1, list.size());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.toString(sb, this.myRootNode);
        return sb.toString();
    }

    private void toString(StringBuilder sb, Node root) {
        sb.append('(');
        sb.append(root.name);
        if (!this.isLeaf(root)) {
            sb.append(' ');
        }
        for (Node child : root.children) {
            this.toString(sb, child);
        }
        sb.append(')');
    }

    protected static class Node {
        public String name;
        public List<Node> children = Lists.newLinkedList();
        public boolean existsOnDisk;
        public boolean isConflicted;
        public boolean isProposedFile;
        public Icon icon;

        protected Node() {
        }

        public String toString() {
            return this.name;
        }

        public boolean hasChild(String name) {
            for (Node child : this.children) {
                if (!child.name.equals(name)) continue;
                return true;
            }
            return false;
        }

        @Nullable
        public Node getChild(String name) {
            for (Node child : this.children) {
                if (!child.name.equals(name)) continue;
                return child;
            }
            return null;
        }
    }
}

