/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.coverage.report.impl;

import com.intellij.openapi.diagnostic.Logger;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IOUtil {
    private static final Logger LOG = Logger.getInstance((String)IOUtil.class.getName());
    private static final String FIX_DIRECTORY_NAME_PATTERN = "[^A-Za-z0-9_ &#.@$%\\[\\]\\(\\){}\\-+=]";

    public static File createDir(File dir) throws IOException {
        if (!dir.exists() && !dir.mkdirs()) {
            throw new IOException("Failed to create directory: " + dir.getAbsolutePath());
        }
        return dir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyResource(@NotNull Class<?> clazz, @NotNull String resourceName, @NotNull File outputFile) throws IOException {
        if (clazz == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/coverage/report/impl/IOUtil.copyResource must not be null");
        }
        if (resourceName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of jetbrains/coverage/report/impl/IOUtil.copyResource must not be null");
        }
        if (outputFile == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of jetbrains/coverage/report/impl/IOUtil.copyResource must not be null");
        }
        InputStream asStream = null;
        FileOutputStream outputStream = null;
        try {
            asStream = clazz.getResourceAsStream(resourceName);
            if (asStream != null) {
                outputStream = new FileOutputStream(outputFile);
                IOUtil.copyStreamContent(asStream, outputStream);
            }
        }
        finally {
            IOUtil.close(asStream);
            IOUtil.close(outputStream);
        }
    }

    public static void close(@Nullable Closeable e) {
        if (e != null) {
            try {
                e.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static int copyStreamContent(InputStream inputStream, OutputStream outputStream) throws IOException {
        int count;
        byte[] buffer = new byte[10240];
        int total = 0;
        while ((count = inputStream.read(buffer)) > 0) {
            outputStream.write(buffer, 0, count);
            total += count;
        }
        return total;
    }

    public static void writeFile(File file, String text) {
        try {
            IOUtil.writeFileAndReportErrors(file, text);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeFileAndReportErrors(File file, String text) throws IOException {
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(file);
            fileWriter.write(text);
        }
        finally {
            if (fileWriter != null) {
                try {
                    fileWriter.close();
                }
                catch (IOException e) {
                    LOG.error((Throwable)e);
                }
            }
        }
    }

    @NotNull
    public static String fixFileName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/coverage/report/impl/IOUtil.fixFileName must not be null");
        }
        String string = name.replaceAll(FIX_DIRECTORY_NAME_PATTERN, "_");
        if (string == null) {
            throw new IllegalStateException("@NotNull method jetbrains/coverage/report/impl/IOUtil.fixFileName must not return null");
        }
        return string;
    }
}

