/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme.attributes.editors;

import com.android.tools.idea.configurations.ThemeSelectionDialog;
import com.android.tools.idea.editors.theme.ParentThemesListModel;
import com.android.tools.idea.editors.theme.ThemeEditorContext;
import com.android.tools.idea.editors.theme.ThemeEditorUtils;
import com.android.tools.idea.editors.theme.ThemeResolver;
import com.android.tools.idea.editors.theme.attributes.editors.AttributeEditorValue;
import com.android.tools.idea.editors.theme.attributes.editors.StyleListCellRenderer;
import com.android.tools.idea.editors.theme.attributes.editors.TypedCellEditor;
import com.android.tools.idea.editors.theme.datamodels.ThemeEditorStyle;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.ui.ComboBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ComboBoxModel;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ParentRendererEditor
extends TypedCellEditor<ThemeEditorStyle, AttributeEditorValue>
implements TableCellRenderer {
    private final ComboBox myComboBox;
    @Nullable
    private AttributeEditorValue myResultValue;
    private final ThemeEditorContext myContext;

    public ParentRendererEditor(@NotNull ThemeEditorContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/android/tools/idea/editors/theme/attributes/editors/ParentRendererEditor", "<init>"));
        }
        this.myContext = context;
        this.myComboBox = new ComboBox();
        this.myComboBox.setRenderer((ListCellRenderer)new StyleListCellRenderer(context));
        this.myComboBox.addActionListener((ActionListener)new ParentChoiceListener());
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.myComboBox.removeAllItems();
        this.myComboBox.addItem(value);
        ComboBox component = this.myComboBox;
        return component;
    }

    @Override
    public Component getEditorComponent(JTable table, ThemeEditorStyle value, boolean isSelected, int row, int column) {
        ImmutableList<ThemeEditorStyle> defaultThemes = ThemeEditorUtils.getDefaultThemes(new ThemeResolver(this.myContext.getConfiguration()));
        this.myComboBox.setModel((ComboBoxModel)new ParentThemesListModel(defaultThemes, value));
        this.myResultValue = new AttributeEditorValue(value.getName(), false);
        return this.myComboBox;
    }

    @Override
    public AttributeEditorValue getEditorValue() {
        return this.myResultValue;
    }

    private class ParentChoiceListener
    implements ActionListener {
        private ParentChoiceListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object selectedValue = ParentRendererEditor.this.myComboBox.getSelectedItem();
            if ("Show all themes".equals(selectedValue)) {
                ParentRendererEditor.this.myComboBox.hidePopup();
                ThemeSelectionDialog dialog = new ThemeSelectionDialog(ParentRendererEditor.this.myContext.getConfiguration());
                dialog.show();
                if (dialog.isOK()) {
                    String theme = dialog.getTheme();
                    ParentRendererEditor.this.myResultValue = theme == null ? null : new AttributeEditorValue(theme, false);
                    ParentRendererEditor.this.stopCellEditing();
                } else {
                    ParentRendererEditor.this.myResultValue = null;
                    ParentRendererEditor.this.cancelCellEditing();
                }
            } else {
                if (selectedValue instanceof ThemeEditorStyle) {
                    ParentRendererEditor.this.myResultValue = new AttributeEditorValue(((ThemeEditorStyle)selectedValue).getName(), false);
                }
                ParentRendererEditor.this.stopCellEditing();
            }
        }
    }
}

