/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.deadCode;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInsight.daemon.ImplicitUsageProvider;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.GlobalInspectionTool;
import com.intellij.codeInspection.GlobalJavaInspectionContext;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ProblemDescriptionsProcessor;
import com.intellij.codeInspection.deadCode.RefUnreachableFilter;
import com.intellij.codeInspection.deadCode.UnreferencedFilter;
import com.intellij.codeInspection.ex.EntryPointsManager;
import com.intellij.codeInspection.ex.GlobalInspectionContextBase;
import com.intellij.codeInspection.ex.JobDescriptor;
import com.intellij.codeInspection.reference.EntryPoint;
import com.intellij.codeInspection.reference.RefClass;
import com.intellij.codeInspection.reference.RefClassImpl;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefElementImpl;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefField;
import com.intellij.codeInspection.reference.RefImplicitConstructor;
import com.intellij.codeInspection.reference.RefJavaElement;
import com.intellij.codeInspection.reference.RefJavaElementImpl;
import com.intellij.codeInspection.reference.RefJavaVisitor;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefMethod;
import com.intellij.codeInspection.reference.RefUtil;
import com.intellij.codeInspection.reference.RefVisitor;
import com.intellij.codeInspection.unusedSymbol.UnusedSymbolLocalInspectionBase;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.PsiClassImplUtil;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiNonJavaFileReferenceProcessor;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiMethodUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnusedDeclarationInspectionBase
extends GlobalInspectionTool {
    public boolean ADD_MAINS_TO_ENTRIES = true;
    public boolean ADD_APPLET_TO_ENTRIES = true;
    public boolean ADD_SERVLET_TO_ENTRIES = true;
    public boolean ADD_NONJAVA_TO_ENTRIES = true;
    private Set<RefElement> myProcessedSuspicious = null;
    private int myPhase;
    public static final String DISPLAY_NAME = InspectionsBundle.message((String)"inspection.dead.code.display.name", (Object[])new Object[0]);
    @NonNls
    public static final String SHORT_NAME = "unused";
    @NonNls
    public static final String ALTERNATIVE_ID = "UnusedDeclaration";
    final List<EntryPoint> myExtensions = ContainerUtil.createLockFreeCopyOnWriteList();
    private static final Logger LOG = Logger.getInstance((String)("#" + UnusedDeclarationInspectionBase.class.getName()));
    private GlobalInspectionContext myContext;
    final UnusedSymbolLocalInspectionBase myLocalInspectionBase = this.createUnusedSymbolLocalInspection();
    private final boolean myEnabledInEditor;

    public UnusedDeclarationInspectionBase(boolean enabledInEditor) {
        ExtensionPoint point = Extensions.getRootArea().getExtensionPoint("com.intellij.deadCode");
        EntryPoint[] extensions = (EntryPoint[])point.getExtensions();
        ArrayList<EntryPoint> deadCodeAddins = new ArrayList<EntryPoint>(extensions.length);
        for (EntryPoint entryPoint : extensions) {
            try {
                deadCodeAddins.add(entryPoint);
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }
        Collections.sort(deadCodeAddins, new Comparator<EntryPoint>(){

            @Override
            public int compare(EntryPoint o1, EntryPoint o2) {
                return o1.getDisplayName().compareToIgnoreCase(o2.getDisplayName());
            }
        });
        this.myExtensions.addAll(deadCodeAddins);
        this.myEnabledInEditor = enabledInEditor;
    }

    public UnusedDeclarationInspectionBase() {
        this(!ApplicationManager.getApplication().isUnitTestMode());
    }

    protected UnusedSymbolLocalInspectionBase createUnusedSymbolLocalInspection() {
        return new UnusedSymbolLocalInspectionBase();
    }

    @Nullable
    public UnusedSymbolLocalInspectionBase getSharedLocalInspectionTool() {
        return this.myLocalInspectionBase;
    }

    protected GlobalInspectionContext getContext() {
        return this.myContext;
    }

    private boolean isAddMainsEnabled() {
        return this.ADD_MAINS_TO_ENTRIES;
    }

    private boolean isAddAppletEnabled() {
        return this.ADD_APPLET_TO_ENTRIES;
    }

    private boolean isAddServletEnabled() {
        return this.ADD_SERVLET_TO_ENTRIES;
    }

    private boolean isAddNonJavaUsedEnabled() {
        return this.ADD_NONJAVA_TO_ENTRIES;
    }

    @NotNull
    public String getDisplayName() {
        String string = DISPLAY_NAME;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/deadCode/UnusedDeclarationInspectionBase", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = GroupNames.DECLARATION_REDUNDANCY;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/deadCode/UnusedDeclarationInspectionBase", "getGroupDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        if (SHORT_NAME == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/deadCode/UnusedDeclarationInspectionBase", "getShortName"));
        }
        return SHORT_NAME;
    }

    public void readSettings(@NotNull Element node) throws InvalidDataException {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/codeInspection/deadCode/UnusedDeclarationInspectionBase", "readSettings"));
        }
        super.readSettings(node);
        this.myLocalInspectionBase.readSettings(node);
        for (EntryPoint extension : this.myExtensions) {
            extension.readExternal(node);
        }
    }

    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/codeInspection/deadCode/UnusedDeclarationInspectionBase", "writeSettings"));
        }
        this.myLocalInspectionBase.writeSettings(node);
        this.writeUnusedDeclarationSettings(node);
    }

    protected void writeUnusedDeclarationSettings(Element node) throws WriteExternalException {
        super.writeSettings(node);
        for (EntryPoint extension : this.myExtensions) {
            extension.writeExternal(node);
        }
    }

    private static boolean isExternalizableNoParameterConstructor(@NotNull PsiMethod method, RefClass refClass) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInspection/deadCode/UnusedDeclarationInspectionBase", "isExternalizableNoParameterConstructor"));
        }
        if (!method.isConstructor()) {
            return false;
        }
        if (!method.hasModifierProperty("public")) {
            return false;
        }
        PsiParameterList parameterList = method.getParameterList();
        if (parameterList.getParametersCount() != 0) {
            return false;
        }
        PsiClass aClass = method.getContainingClass();
        return aClass == null || UnusedDeclarationInspectionBase.isExternalizable(aClass, refClass);
    }

    private static boolean isSerializationImplicitlyUsedField(@NotNull PsiField field) {
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/intellij/codeInspection/deadCode/UnusedDeclarationInspectionBase", "isSerializationImplicitlyUsedField"));
        }
        String name = field.getName();
        if (!"serialVersionUID".equals(name) && !"serialPersistentFields".equals(name)) {
            return false;
        }
        if (!field.hasModifierProperty("static")) {
            return false;
        }
        PsiClass aClass = field.getContainingClass();
        return aClass == null || UnusedDeclarationInspectionBase.isSerializable(aClass, null);
    }

    private static boolean isWriteObjectMethod(@NotNull PsiMethod method, RefClass refClass) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInspection/deadCode/UnusedDeclarationInspectionBase", "isWriteObjectMethod"));
        }
        String name = method.getName();
        if (!"writeObject".equals(name)) {
            return false;
        }
        PsiParameter[] parameters = method.getParameterList().getParameters();
        if (parameters.length != 1) {
            return false;
        }
        if (!parameters[0].getType().equalsToText("java.io.ObjectOutputStream")) {
            return false;
        }
        if (method.hasModifierProperty("static")) {
            return false;
        }
        PsiClass aClass = method.getContainingClass();
        return aClass == null || UnusedDeclarationInspectionBase.isSerializable(aClass, refClass);
    }

    private static boolean isReadObjectMethod(@NotNull PsiMethod method, RefClass refClass) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInspection/deadCode/UnusedDeclarationInspectionBase", "isReadObjectMethod"));
        }
        String name = method.getName();
        if (!"readObject".equals(name)) {
            return false;
        }
        PsiParameter[] parameters = method.getParameterList().getParameters();
        if (parameters.length != 1) {
            return false;
        }
        if (!parameters[0].getType().equalsToText("java.io.ObjectInputStream")) {
            return false;
        }
        if (method.hasModifierProperty("static")) {
            return false;
        }
        PsiClass aClass = method.getContainingClass();
        return aClass == null || UnusedDeclarationInspectionBase.isSerializable(aClass, refClass);
    }

    private static boolean isWriteReplaceMethod(@NotNull PsiMethod method, RefClass refClass) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInspection/deadCode/UnusedDeclarationInspectionBase", "isWriteReplaceMethod"));
        }
        String name = method.getName();
        if (!"writeReplace".equals(name)) {
            return false;
        }
        PsiParameter[] parameters = method.getParameterList().getParameters();
        if (parameters.length != 0) {
            return false;
        }
        if (!method.getReturnType().equalsToText("java.lang.Object")) {
            return false;
        }
        if (method.hasModifierProperty("static")) {
            return false;
        }
        PsiClass aClass = method.getContainingClass();
        return aClass == null || UnusedDeclarationInspectionBase.isSerializable(aClass, refClass);
    }

    private static boolean isReadResolveMethod(@NotNull PsiMethod method, RefClass refClass) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInspection/deadCode/UnusedDeclarationInspectionBase", "isReadResolveMethod"));
        }
        String name = method.getName();
        if (!"readResolve".equals(name)) {
            return false;
        }
        PsiParameter[] parameters = method.getParameterList().getParameters();
        if (parameters.length != 0) {
            return false;
        }
        if (!method.getReturnType().equalsToText("java.lang.Object")) {
            return false;
        }
        if (method.hasModifierProperty("static")) {
            return false;
        }
        PsiClass aClass = method.getContainingClass();
        return aClass == null || UnusedDeclarationInspectionBase.isSerializable(aClass, refClass);
    }

    private static boolean isSerializable(PsiClass aClass, @Nullable RefClass refClass) {
        PsiClass serializableClass = JavaPsiFacade.getInstance((Project)aClass.getProject()).findClass("java.io.Serializable", aClass.getResolveScope());
        return serializableClass != null && UnusedDeclarationInspectionBase.isSerializable(aClass, refClass, serializableClass);
    }

    private static boolean isExternalizable(@NotNull PsiClass aClass, RefClass refClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/codeInspection/deadCode/UnusedDeclarationInspectionBase", "isExternalizable"));
        }
        GlobalSearchScope scope = aClass.getResolveScope();
        PsiClass externalizableClass = JavaPsiFacade.getInstance((Project)aClass.getProject()).findClass("java.io.Externalizable", scope);
        return externalizableClass != null && UnusedDeclarationInspectionBase.isSerializable(aClass, refClass, externalizableClass);
    }

    private static boolean isSerializable(PsiClass aClass, RefClass refClass, PsiClass serializableClass) {
        if (aClass == null) {
            return false;
        }
        if (aClass.isInheritor(serializableClass, true)) {
            return true;
        }
        if (refClass != null) {
            Set subClasses = refClass.getSubClasses();
            for (RefClass subClass : subClasses) {
                if (!UnusedDeclarationInspectionBase.isSerializable(subClass.getElement(), subClass, serializableClass)) continue;
                return true;
            }
        }
        return false;
    }

    public void runInspection(final @NotNull AnalysisScope scope, @NotNull InspectionManager manager, final @NotNull GlobalInspectionContext globalContext, @NotNull ProblemDescriptionsProcessor problemDescriptionsProcessor) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/codeInspection/deadCode/UnusedDeclarationInspectionBase", "runInspection"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/codeInspection/deadCode/UnusedDeclarationInspectionBase", "runInspection"));
        }
        if (globalContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "globalContext", "com/intellij/codeInspection/deadCode/UnusedDeclarationInspectionBase", "runInspection"));
        }
        if (problemDescriptionsProcessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "problemDescriptionsProcessor", "com/intellij/codeInspection/deadCode/UnusedDeclarationInspectionBase", "runInspection"));
        }
        globalContext.getRefManager().iterate((RefVisitor)new RefJavaVisitor(){

            public void visitElement(@NotNull RefEntity refEntity) {
                if (refEntity == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refEntity", "com/intellij/codeInspection/deadCode/UnusedDeclarationInspectionBase$2", "visitElement"));
                }
                if (refEntity instanceof RefJavaElement) {
                    RefElementImpl refElement = (RefElementImpl)refEntity;
                    if (!refElement.isSuspicious()) {
                        return;
                    }
                    PsiFile file2 = refElement.getContainingFile();
                    if (file2 == null) {
                        return;
                    }
                    boolean isSuppressed = refElement.isSuppressed(UnusedDeclarationInspectionBase.this.getShortName(), UnusedDeclarationInspectionBase.ALTERNATIVE_ID);
                    if (isSuppressed || !((GlobalInspectionContextBase)globalContext).isToCheckFile(file2, (InspectionProfileEntry)UnusedDeclarationInspectionBase.this)) {
                        if (isSuppressed || !scope.contains((PsiElement)file2)) {
                            UnusedDeclarationInspectionBase.this.getEntryPointsManager().addEntryPoint((RefElement)refElement, false);
                        }
                        return;
                    }
                    refElement.accept((RefVisitor)new RefJavaVisitor(){

                        public void visitMethod(@NotNull RefMethod method) {
                            if (method == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInspection/deadCode/UnusedDeclarationInspectionBase$2$1", "visitMethod"));
                            }
                            if (UnusedDeclarationInspectionBase.this.isAddMainsEnabled() && method.isAppMain()) {
                                UnusedDeclarationInspectionBase.this.getEntryPointsManager().addEntryPoint((RefElement)method, false);
                            }
                        }

                        public void visitClass(@NotNull RefClass aClass) {
                            if (aClass == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/codeInspection/deadCode/UnusedDeclarationInspectionBase$2$1", "visitClass"));
                            }
                            if (UnusedDeclarationInspectionBase.this.isAddAppletEnabled() && aClass.isApplet() || UnusedDeclarationInspectionBase.this.isAddServletEnabled() && aClass.isServlet()) {
                                UnusedDeclarationInspectionBase.this.getEntryPointsManager().addEntryPoint((RefElement)aClass, false);
                            }
                        }
                    });
                }
            }
        });
        if (this.isAddNonJavaUsedEnabled()) {
            this.checkForReachables(globalContext);
            final StrictUnreferencedFilter strictUnreferencedFilter = new StrictUnreferencedFilter(this, globalContext);
            ProgressManager.getInstance().runProcess(new Runnable(){

                @Override
                public void run() {
                    final RefManager refManager = globalContext.getRefManager();
                    final PsiSearchHelper helper = PsiSearchHelper.SERVICE.getInstance((Project)refManager.getProject());
                    refManager.iterate((RefVisitor)new RefJavaVisitor(){

                        public void visitElement(@NotNull RefEntity refEntity) {
                            RefMethod refMethod;
                            if (refEntity == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refEntity", "com/intellij/codeInspection/deadCode/UnusedDeclarationInspectionBase$3$1", "visitElement"));
                            }
                            if (refEntity instanceof RefClass && strictUnreferencedFilter.accepts((RefJavaElement)((RefClass)refEntity))) {
                                this.findExternalClassReferences((RefClass)refEntity);
                            } else if (refEntity instanceof RefMethod && (refMethod = (RefMethod)refEntity).isConstructor() && strictUnreferencedFilter.accepts((RefJavaElement)refMethod)) {
                                this.findExternalClassReferences(refMethod.getOwnerClass());
                            }
                        }

                        private void findExternalClassReferences(final RefClass refElement) {
                            PsiReference reference;
                            GlobalSearchScope projectScope;
                            DelegatingGlobalSearchScope globalSearchScope;
                            PsiNonJavaFileReferenceProcessor processor2;
                            String qualifiedName;
                            PsiClass psiClass = refElement.getElement();
                            String string = qualifiedName = psiClass != null ? psiClass.getQualifiedName() : null;
                            if (qualifiedName != null && helper.processUsagesInNonJavaFiles(qualifiedName, processor2 = new PsiNonJavaFileReferenceProcessor(){

                                public boolean process(PsiFile file2, int startOffset, int endOffset) {
                                    UnusedDeclarationInspectionBase.this.getEntryPointsManager().addEntryPoint((RefElement)refElement, false);
                                    return false;
                                }
                            }, (GlobalSearchScope)(globalSearchScope = new DelegatingGlobalSearchScope(projectScope = GlobalSearchScope.projectScope((Project)globalContext.getProject())){

                                public boolean contains(@NotNull VirtualFile file2) {
                                    if (file2 == null) {
                                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInspection/deadCode/UnusedDeclarationInspectionBase$3$1$2", "contains"));
                                    }
                                    return file2.getFileType() != JavaFileType.INSTANCE && super.contains(file2);
                                }
                            })) && (reference = (PsiReference)ReferencesSearch.search((PsiElement)psiClass, (SearchScope)globalSearchScope).findFirst()) != null) {
                                UnusedDeclarationInspectionBase.this.getEntryPointsManager().addEntryPoint((RefElement)refElement, false);
                                for (PsiMethod method : psiClass.getMethods()) {
                                    RefElement refMethod = refManager.getReference((PsiElement)method);
                                    if (refMethod == null) continue;
                                    UnusedDeclarationInspectionBase.this.getEntryPointsManager().addEntryPoint(refMethod, false);
                                }
                            }
                        }
                    });
                }
            }, null);
        }
        this.myProcessedSuspicious = new HashSet<RefElement>();
        this.myPhase = 1;
    }

    public boolean isEntryPoint(@NotNull RefElement owner) {
        EntryPointsManager entryPointsManager;
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/codeInspection/deadCode/UnusedDeclarationInspectionBase", "isEntryPoint"));
        }
        PsiElement element = owner.getElement();
        if (RefUtil.isImplicitUsage((PsiElement)element)) {
            return true;
        }
        if (element instanceof PsiModifierListOwner && (entryPointsManager = EntryPointsManager.getInstance((Project)element.getProject())).isEntryPoint(element)) {
            return true;
        }
        if (element != null) {
            for (EntryPoint extension : this.myExtensions) {
                if (!extension.isEntryPoint(owner, element)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isEntryPoint(@NotNull PsiElement element) {
        ImplicitUsageProvider[] implicitUsageProviders;
        Object entryPointsManager;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInspection/deadCode/UnusedDeclarationInspectionBase", "isEntryPoint"));
        }
        Project project = element.getProject();
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
        if (element instanceof PsiMethod && this.isAddMainsEnabled() && PsiClassImplUtil.isMainOrPremainMethod((PsiMethod)element)) {
            return true;
        }
        if (element instanceof PsiClass) {
            PsiClass aClass = (PsiClass)element;
            PsiClass applet = psiFacade.findClass("java.applet.Applet", GlobalSearchScope.allScope((Project)project));
            if (this.isAddAppletEnabled() && applet != null && aClass.isInheritor(applet, true)) {
                return true;
            }
            PsiClass servlet = psiFacade.findClass("javax.servlet.Servlet", GlobalSearchScope.allScope((Project)project));
            if (this.isAddServletEnabled() && servlet != null && aClass.isInheritor(servlet, true)) {
                return true;
            }
            if (this.isAddMainsEnabled() && PsiMethodUtil.hasMainMethod((PsiClass)aClass)) {
                return true;
            }
        }
        if (element instanceof PsiModifierListOwner && (entryPointsManager = EntryPointsManager.getInstance((Project)project)).isEntryPoint(element)) {
            return true;
        }
        for (EntryPoint extension : this.myExtensions) {
            if (!extension.isEntryPoint(element)) continue;
            return true;
        }
        for (ImplicitUsageProvider provider : implicitUsageProviders = (ImplicitUsageProvider[])Extensions.getExtensions((ExtensionPointName)ImplicitUsageProvider.EP_NAME)) {
            if (!provider.isImplicitUsage(element)) continue;
            return true;
        }
        return false;
    }

    public boolean isGlobalEnabledInEditor() {
        return this.myEnabledInEditor;
    }

    public boolean queryExternalUsagesRequests(@NotNull InspectionManager manager, @NotNull GlobalInspectionContext globalContext, @NotNull ProblemDescriptionsProcessor problemDescriptionsProcessor) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/codeInspection/deadCode/UnusedDeclarationInspectionBase", "queryExternalUsagesRequests"));
        }
        if (globalContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "globalContext", "com/intellij/codeInspection/deadCode/UnusedDeclarationInspectionBase", "queryExternalUsagesRequests"));
        }
        if (problemDescriptionsProcessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "problemDescriptionsProcessor", "com/intellij/codeInspection/deadCode/UnusedDeclarationInspectionBase", "queryExternalUsagesRequests"));
        }
        this.checkForReachables(globalContext);
        final RefUnreachableFilter filter = this.myPhase == 1 ? new StrictUnreferencedFilter(this, globalContext) : new RefUnreachableFilter(this, globalContext);
        final boolean[] requestAdded = new boolean[]{false};
        globalContext.getRefManager().iterate((RefVisitor)new RefJavaVisitor(){

            public void visitElement(@NotNull RefEntity refEntity) {
                if (refEntity == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refEntity", "com/intellij/codeInspection/deadCode/UnusedDeclarationInspectionBase$4", "visitElement"));
                }
                if (!(refEntity instanceof RefJavaElement)) {
                    return;
                }
                if (refEntity instanceof RefClass && ((RefClass)refEntity).isAnonymous()) {
                    return;
                }
                RefJavaElement refElement = (RefJavaElement)refEntity;
                if (filter.accepts(refElement) && !UnusedDeclarationInspectionBase.this.myProcessedSuspicious.contains(refElement)) {
                    refEntity.accept((RefVisitor)new RefJavaVisitor(){

                        public void visitField(final @NotNull RefField refField) {
                            if (refField == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refField", "com/intellij/codeInspection/deadCode/UnusedDeclarationInspectionBase$4$1", "visitField"));
                            }
                            UnusedDeclarationInspectionBase.this.myProcessedSuspicious.add(refField);
                            PsiField psiField = refField.getElement();
                            if (psiField != null && UnusedDeclarationInspectionBase.isSerializationImplicitlyUsedField(psiField)) {
                                UnusedDeclarationInspectionBase.this.getEntryPointsManager().addEntryPoint((RefElement)refField, false);
                            } else {
                                UnusedDeclarationInspectionBase.this.getJavaContext().enqueueFieldUsagesProcessor(refField, new GlobalJavaInspectionContext.UsagesProcessor(){

                                    public boolean process(PsiReference psiReference) {
                                        UnusedDeclarationInspectionBase.this.getEntryPointsManager().addEntryPoint((RefElement)refField, false);
                                        return false;
                                    }
                                });
                                requestAdded[0] = true;
                            }
                        }

                        public void visitMethod(@NotNull RefMethod refMethod) {
                            if (refMethod == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refMethod", "com/intellij/codeInspection/deadCode/UnusedDeclarationInspectionBase$4$1", "visitMethod"));
                            }
                            UnusedDeclarationInspectionBase.this.myProcessedSuspicious.add(refMethod);
                            if (refMethod instanceof RefImplicitConstructor) {
                                this.visitClass(refMethod.getOwnerClass());
                            } else {
                                PsiMethod psiMethod = (PsiMethod)refMethod.getElement();
                                if (psiMethod != null && UnusedDeclarationInspectionBase.isSerializablePatternMethod(psiMethod, refMethod.getOwnerClass())) {
                                    UnusedDeclarationInspectionBase.this.getEntryPointsManager().addEntryPoint((RefElement)refMethod, false);
                                } else if (!refMethod.isExternalOverride() && !"private".equals(refMethod.getAccessModifier())) {
                                    for (RefMethod derivedMethod : refMethod.getDerivedMethods()) {
                                        UnusedDeclarationInspectionBase.this.myProcessedSuspicious.add(derivedMethod);
                                    }
                                    UnusedDeclarationInspectionBase.this.enqueueMethodUsages(refMethod);
                                    requestAdded[0] = true;
                                }
                            }
                        }

                        public void visitClass(final @NotNull RefClass refClass) {
                            if (refClass == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refClass", "com/intellij/codeInspection/deadCode/UnusedDeclarationInspectionBase$4$1", "visitClass"));
                            }
                            UnusedDeclarationInspectionBase.this.myProcessedSuspicious.add(refClass);
                            if (!refClass.isAnonymous()) {
                                UnusedDeclarationInspectionBase.this.getJavaContext().enqueueDerivedClassesProcessor(refClass, new GlobalJavaInspectionContext.DerivedClassesProcessor(){

                                    public boolean process(PsiClass inheritor) {
                                        UnusedDeclarationInspectionBase.this.getEntryPointsManager().addEntryPoint((RefElement)refClass, false);
                                        return false;
                                    }
                                });
                                UnusedDeclarationInspectionBase.this.getJavaContext().enqueueClassUsagesProcessor(refClass, new GlobalJavaInspectionContext.UsagesProcessor(){

                                    public boolean process(PsiReference psiReference) {
                                        UnusedDeclarationInspectionBase.this.getEntryPointsManager().addEntryPoint((RefElement)refClass, false);
                                        return false;
                                    }
                                });
                                requestAdded[0] = true;
                            }
                        }
                    });
                }
            }
        });
        if (!requestAdded[0]) {
            if (this.myPhase == 2) {
                this.myProcessedSuspicious = null;
                return false;
            }
            this.myPhase = 2;
        }
        return true;
    }

    private static boolean isSerializablePatternMethod(@NotNull PsiMethod psiMethod, RefClass refClass) {
        if (psiMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiMethod", "com/intellij/codeInspection/deadCode/UnusedDeclarationInspectionBase", "isSerializablePatternMethod"));
        }
        return UnusedDeclarationInspectionBase.isReadObjectMethod(psiMethod, refClass) || UnusedDeclarationInspectionBase.isWriteObjectMethod(psiMethod, refClass) || UnusedDeclarationInspectionBase.isReadResolveMethod(psiMethod, refClass) || UnusedDeclarationInspectionBase.isWriteReplaceMethod(psiMethod, refClass) || UnusedDeclarationInspectionBase.isExternalizableNoParameterConstructor(psiMethod, refClass);
    }

    private void enqueueMethodUsages(final RefMethod refMethod) {
        if (refMethod.getSuperMethods().isEmpty()) {
            this.getJavaContext().enqueueMethodUsagesProcessor(refMethod, new GlobalJavaInspectionContext.UsagesProcessor(){

                public boolean process(PsiReference psiReference) {
                    UnusedDeclarationInspectionBase.this.getEntryPointsManager().addEntryPoint((RefElement)refMethod, false);
                    return false;
                }
            });
        } else {
            for (RefMethod refSuper : refMethod.getSuperMethods()) {
                this.enqueueMethodUsages(refSuper);
            }
        }
    }

    private GlobalJavaInspectionContext getJavaContext() {
        return (GlobalJavaInspectionContext)this.getContext().getExtension(GlobalJavaInspectionContext.CONTEXT);
    }

    @Nullable
    public JobDescriptor[] getAdditionalJobs() {
        return new JobDescriptor[]{this.getContext().getStdJobDescriptors().BUILD_GRAPH, this.getContext().getStdJobDescriptors().FIND_EXTERNAL_USAGES};
    }

    void checkForReachables(final @NotNull GlobalInspectionContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInspection/deadCode/UnusedDeclarationInspectionBase", "checkForReachables"));
        }
        CodeScanner codeScanner = new CodeScanner();
        context.getRefManager().iterate((RefVisitor)new RefJavaVisitor(){

            public void visitElement(@NotNull RefEntity refEntity) {
                if (refEntity == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refEntity", "com/intellij/codeInspection/deadCode/UnusedDeclarationInspectionBase$6", "visitElement"));
                }
                if (refEntity instanceof RefJavaElement) {
                    RefJavaElementImpl refElement = (RefJavaElementImpl)refEntity;
                    if (!((GlobalInspectionContextBase)context).isToCheckMember(refElement, (InspectionProfileEntry)UnusedDeclarationInspectionBase.this)) {
                        return;
                    }
                    refElement.setReachable(false);
                }
            }
        });
        for (RefElement entry : this.getEntryPointsManager().getEntryPoints()) {
            entry.accept((RefVisitor)codeScanner);
        }
        while (codeScanner.newlyInstantiatedClassesCount() != 0) {
            codeScanner.cleanInstantiatedClassesCount();
            codeScanner.processDelayedMethods();
        }
    }

    private EntryPointsManager getEntryPointsManager() {
        return this.getJavaContext().getEntryPointsManager(this.getContext().getRefManager());
    }

    public void initialize(@NotNull GlobalInspectionContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInspection/deadCode/UnusedDeclarationInspectionBase", "initialize"));
        }
        super.initialize(context);
        this.myContext = context;
        ExtensionPoint point = Extensions.getRootArea().getExtensionPoint("com.intellij.deadCode");
        point.addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<EntryPoint>(){

            public void extensionAdded(final @NotNull EntryPoint extension, @Nullable PluginDescriptor pluginDescriptor) {
                boolean alreadyAdded;
                if (extension == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extension", "com/intellij/codeInspection/deadCode/UnusedDeclarationInspectionBase$7", "extensionAdded"));
                }
                boolean bl = alreadyAdded = ContainerUtil.find(UnusedDeclarationInspectionBase.this.myExtensions, (Condition)new Condition<EntryPoint>(){

                    public boolean value(EntryPoint point) {
                        return point.getClass().equals(extension.getClass());
                    }
                }) != null;
                if (!alreadyAdded) {
                    try {
                        UnusedDeclarationInspectionBase.this.myExtensions.add(extension.clone());
                    }
                    catch (CloneNotSupportedException e) {
                        LOG.error((Throwable)e);
                    }
                }
            }

            public void extensionRemoved(final @NotNull EntryPoint extension, @Nullable PluginDescriptor pluginDescriptor) {
                if (extension == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extension", "com/intellij/codeInspection/deadCode/UnusedDeclarationInspectionBase$7", "extensionRemoved"));
                }
                ContainerUtil.retainAll(UnusedDeclarationInspectionBase.this.myExtensions, (Condition)new Condition<EntryPoint>(){

                    public boolean value(EntryPoint point) {
                        return !point.getClass().equals(extension.getClass());
                    }
                });
            }
        }, (Disposable)this.getEntryPointsManager());
    }

    public void cleanup(Project project) {
        super.cleanup(project);
        this.myContext = null;
    }

    public boolean isGraphNeeded() {
        return true;
    }

    private static class CodeScanner
    extends RefJavaVisitor {
        private final Map<RefClass, Set<RefMethod>> myClassIDtoMethods = new HashMap();
        private final Set<RefClass> myInstantiatedClasses = new HashSet<RefClass>();
        private int myInstantiatedClassesCount;
        private final Set<RefMethod> myProcessedMethods = new HashSet<RefMethod>();

        private CodeScanner() {
        }

        public void visitMethod(@NotNull RefMethod method) {
            if (method == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInspection/deadCode/UnusedDeclarationInspectionBase$CodeScanner", "visitMethod"));
            }
            if (!this.myProcessedMethods.contains(method)) {
                if (method.isStatic() || method.isConstructor()) {
                    if (method.isConstructor()) {
                        this.addInstantiatedClass(method.getOwnerClass());
                    } else {
                        ((RefClassImpl)method.getOwnerClass()).setReachable(true);
                    }
                    this.myProcessedMethods.add(method);
                    this.makeContentReachable((RefJavaElementImpl)method);
                    this.makeClassInitializersReachable(method.getOwnerClass());
                } else {
                    if (this.isClassInstantiated(method.getOwnerClass())) {
                        this.myProcessedMethods.add(method);
                        this.makeContentReachable((RefJavaElementImpl)method);
                    } else {
                        this.addDelayedMethod(method);
                    }
                    for (RefMethod refSub : method.getDerivedMethods()) {
                        this.visitMethod(refSub);
                    }
                }
            }
        }

        public void visitClass(@NotNull RefClass refClass) {
            if (refClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refClass", "com/intellij/codeInspection/deadCode/UnusedDeclarationInspectionBase$CodeScanner", "visitClass"));
            }
            boolean alreadyActive = refClass.isReachable();
            ((RefClassImpl)refClass).setReachable(true);
            if (!alreadyActive) {
                this.makeClassInitializersReachable(refClass);
            }
            this.addInstantiatedClass(refClass);
        }

        public void visitField(@NotNull RefField field) {
            if (field == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/intellij/codeInspection/deadCode/UnusedDeclarationInspectionBase$CodeScanner", "visitField"));
            }
            if (!field.isReachable()) {
                this.makeContentReachable((RefJavaElementImpl)field);
                this.makeClassInitializersReachable(field.getOwnerClass());
            }
        }

        private void addInstantiatedClass(RefClass refClass) {
            if (this.myInstantiatedClasses.add(refClass)) {
                ((RefClassImpl)refClass).setReachable(true);
                ++this.myInstantiatedClassesCount;
                List refMethods = refClass.getLibraryMethods();
                for (RefMethod refMethod : refMethods) {
                    refMethod.accept((RefVisitor)this);
                }
                for (RefClass baseClass : refClass.getBaseClasses()) {
                    this.addInstantiatedClass(baseClass);
                }
            }
        }

        private void makeContentReachable(RefJavaElementImpl refElement) {
            refElement.setReachable(true);
            for (RefElement refCallee : refElement.getOutReferences()) {
                refCallee.accept((RefVisitor)this);
            }
        }

        private void makeClassInitializersReachable(RefClass refClass) {
            for (RefElement refCallee : refClass.getOutReferences()) {
                refCallee.accept((RefVisitor)this);
            }
        }

        private void addDelayedMethod(RefMethod refMethod) {
            Set<RefMethod> methods = this.myClassIDtoMethods.get(refMethod.getOwnerClass());
            if (methods == null) {
                methods = new HashSet<RefMethod>();
                this.myClassIDtoMethods.put(refMethod.getOwnerClass(), methods);
            }
            methods.add(refMethod);
        }

        private boolean isClassInstantiated(RefClass refClass) {
            return this.myInstantiatedClasses.contains(refClass);
        }

        private int newlyInstantiatedClassesCount() {
            return this.myInstantiatedClassesCount;
        }

        private void cleanInstantiatedClassesCount() {
            this.myInstantiatedClassesCount = 0;
        }

        private void processDelayedMethods() {
            RefClass[] instClasses;
            for (RefClass refClass : instClasses = this.myInstantiatedClasses.toArray(new RefClass[this.myInstantiatedClasses.size()])) {
                RefMethod[] arMethods;
                Set<RefMethod> methods;
                if (!this.isClassInstantiated(refClass) || (methods = this.myClassIDtoMethods.get(refClass)) == null) continue;
                for (RefMethod arMethod : arMethods = methods.toArray(new RefMethod[methods.size()])) {
                    arMethod.accept((RefVisitor)this);
                }
            }
        }
    }

    private static class StrictUnreferencedFilter
    extends UnreferencedFilter {
        private StrictUnreferencedFilter(@NotNull UnusedDeclarationInspectionBase tool, @NotNull GlobalInspectionContext context) {
            if (tool == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tool", "com/intellij/codeInspection/deadCode/UnusedDeclarationInspectionBase$StrictUnreferencedFilter", "<init>"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInspection/deadCode/UnusedDeclarationInspectionBase$StrictUnreferencedFilter", "<init>"));
            }
            super(tool, context);
        }

        @Override
        public int getElementProblemCount(@NotNull RefJavaElement refElement) {
            if (refElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refElement", "com/intellij/codeInspection/deadCode/UnusedDeclarationInspectionBase$StrictUnreferencedFilter", "getElementProblemCount"));
            }
            int problemCount = super.getElementProblemCount(refElement);
            if (problemCount > -1) {
                return problemCount;
            }
            return refElement.isReferenced() ? 0 : 1;
        }
    }
}

