/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.configurationStore.ComponentStoreImplKt;
import com.intellij.configurationStore.StateMap;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SystemProperties;
import gnu.trove.THashMap;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicReferenceArray;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.iq80.snappy.SnappyInputStream;
import org.iq80.snappy.SnappyOutputStream;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0010$\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010%\n\u0002\b\u0002\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB%\b\u0002\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u000e\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00042\b\u0010\f\u001a\u0004\u0018\u00010\rJ$\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00002\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\u0011J\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u000b\u001a\u00020\u0004J&\u0010\u0013\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\u00042\u0016\b\u0002\u0010\u0014\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\r\u0018\u00010\u0015J\u001a\u0010\u0016\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000b\u001a\u00020\u00042\b\b\u0002\u0010\t\u001a\u00020\u0017J\u000e\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u000b\u001a\u00020\u0004J\u0006\u0010\u0019\u001a\u00020\u0017J\u0006\u0010\u001a\u001a\u00020\u0017J\u0011\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u001cJ\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\u001eR\u0016\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\bR\u0016\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/intellij/configurationStore/StateMap;", "", "names", "", "", "states", "Ljava/util/concurrent/atomic/AtomicReferenceArray;", "([Ljava/lang/String;Ljava/util/concurrent/atomic/AtomicReferenceArray;)V", "[Ljava/lang/String;", "archive", "", "key", "state", "Lorg/jdom/Element;", "compare", "newStates", "diffs", "", "get", "getElement", "newLiveStates", "", "getState", "", "hasState", "hasStates", "isEmpty", "keys", "()[Ljava/lang/String;", "toMutableMap", "", "Companion", "configuration-store-impl"})
public final class StateMap {
    private final String[] names;
    private final AtomicReferenceArray<Object> states;
    private static final Format XML_FORMAT;
    @NotNull
    private static final StateMap EMPTY;
    public static final Companion Companion;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<String, Object> toMutableMap() {
        int n;
        THashMap map = new THashMap(((Object[])this.names).length);
        IntRange intRange = ArraysKt.getIndices((Object[])this.names);
        int n2 = intRange.getFirst();
        if (n2 <= (n = intRange.getLast())) {
            while (true) {
                void i;
                map.put((Object)this.names[i], this.states.get((int)i));
                if (i == n) break;
                ++i;
            }
        }
        return (Map)map;
    }

    @NotNull
    public final String[] keys() {
        return this.names;
    }

    @Nullable
    public final Object get(@NotNull String key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        int index = Arrays.binarySearch(this.names, key);
        return index < 0 ? null : this.states.get(index);
    }

    @NotNull
    public final Element getElement(@NotNull String key, @Nullable Map<String, ? extends Element> newLiveStates) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        return Companion.stateToElement(key, this.get(key), newLiveStates);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ Element getElement$default(StateMap stateMap, String string, Map map, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getElement");
        }
        if ((n & 2) != 0) {
            map = null;
        }
        return stateMap.getElement(string, map);
    }

    public final boolean isEmpty() {
        Object[] $receiver$iv = this.names;
        return $receiver$iv.length == 0;
    }

    public final boolean hasState(@NotNull String key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        return this.get(key) instanceof Element;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean hasStates() {
        int n;
        if (this.isEmpty()) {
            return false;
        }
        IntRange intRange = ArraysKt.getIndices((Object[])this.names);
        int n2 = intRange.getFirst();
        if (n2 <= (n = intRange.getLast())) {
            while (true) {
                void i;
                if (this.states.get((int)i) instanceof Element) {
                    return true;
                }
                if (i == n) break;
                ++i;
            }
        }
        return false;
    }

    public final void compare(@NotNull String key, @NotNull StateMap newStates, @NotNull Set<String> diffs) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Intrinsics.checkParameterIsNotNull((Object)newStates, (String)"newStates");
        Intrinsics.checkParameterIsNotNull(diffs, (String)"diffs");
        Object oldState = this.get(key);
        Object newState = newStates.get(key);
        if (oldState instanceof Element) {
            if (!JDOMUtil.areElementsEqual((Element)((Element)oldState), (Element)((Element)newState))) {
                diffs.add(key);
            }
        } else {
            Object object = newState;
            if (object == null) {
                Intrinsics.throwNpe();
            }
            Object object2 = oldState;
            if (object2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.ByteArray");
            }
            if (Companion.getNewByteIfDiffers(key, object, (byte[])object2) != null) {
                diffs.add(key);
            }
        }
    }

    @Nullable
    public final Element getState(@NotNull String key, boolean archive) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        int index = Arrays.binarySearch(this.names, key);
        if (index < 0) {
            return null;
        }
        Object object = this.states.get(index);
        if (!(object instanceof Element)) {
            object = null;
        }
        Element element = (Element)object;
        if (element == null) {
            return null;
        }
        Element state = element;
        if (!archive) {
            return state;
        }
        return this.states.compareAndSet(index, state, StateMap.Companion.archiveState(state)) ? state : this.getState(key, true);
    }

    @Nullable
    public static /* bridge */ /* synthetic */ Element getState$default(StateMap stateMap, String string, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getState");
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        return stateMap.getState(string, bl);
    }

    public final void archive(@NotNull String key, @Nullable Element state) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        int index = Arrays.binarySearch(this.names, key);
        if (index < 0) {
            return;
        }
        Object currentState = this.states.get(index);
        ComponentStoreImplKt.getLOG().assertTrue(currentState instanceof Element);
        this.states.set(index, state == null ? (byte[])null : StateMap.Companion.archiveState(state));
    }

    private StateMap(String[] names, AtomicReferenceArray<Object> states) {
        this.names = names;
        this.states = states;
    }

    static {
        StateMap stateMap;
        Companion = new Companion(null);
        XML_FORMAT = Format.getRawFormat().setTextMode(Format.TextMode.TRIM).setOmitEncoding(true).setOmitDeclaration(true);
        StateMap stateMap2 = stateMap;
        StateMap stateMap3 = stateMap;
        Object[] objectArray = new String[0];
        stateMap2((String[])objectArray, new AtomicReferenceArray<Object>(0));
        EMPTY = stateMap3;
    }

    public /* synthetic */ StateMap(@NotNull String[] names, @NotNull AtomicReferenceArray states, DefaultConstructorMarker $constructor_marker) {
        this(names, states);
    }

    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u001a\u0010\u0010\u001a\u00020\u00042\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00010\u0012J \u0010\u0014\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00012\u0006\u0010\u0017\u001a\u00020\rJ0\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u00132\b\u0010\u000e\u001a\u0004\u0018\u00010\u00012\u0016\b\u0002\u0010\u0019\u001a\u0010\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u0012J\u0018\u0010\u001a\u001a\n \t*\u0004\u0018\u00010\u000f0\u000f2\u0006\u0010\u000e\u001a\u00020\rH\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001c\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001b"}, d2={"Lcom/intellij/configurationStore/StateMap$Companion;", "", "()V", "EMPTY", "Lcom/intellij/configurationStore/StateMap;", "getEMPTY", "()Lcom/intellij/configurationStore/StateMap;", "XML_FORMAT", "Lorg/jdom/output/Format;", "kotlin.jvm.PlatformType", "getXML_FORMAT", "()Lorg/jdom/output/Format;", "archiveState", "", "state", "Lorg/jdom/Element;", "fromMap", "map", "", "", "getNewByteIfDiffers", "key", "newState", "oldState", "stateToElement", "newLiveStates", "unarchiveState", "configuration-store-impl"})
    public static final class Companion {
        private final Format getXML_FORMAT() {
            return XML_FORMAT;
        }

        @NotNull
        public final StateMap getEMPTY() {
            return EMPTY;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final StateMap fromMap(@NotNull Map<String, ? extends Object> map) {
            int n;
            Intrinsics.checkParameterIsNotNull(map, (String)"map");
            if (map.isEmpty()) {
                return this.getEMPTY();
            }
            Collection $receiver$iv = map.keySet();
            Collection collection = $receiver$iv;
            if (collection == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
            }
            Collection thisCollection$iv22 = collection;
            String[] stringArray = thisCollection$iv22.toArray(new String[thisCollection$iv22.size()]);
            if (stringArray == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            String[] names = (String[])((Object[])stringArray);
            if (!(map instanceof TreeMap)) {
                Arrays.sort(names);
            }
            AtomicReferenceArray<Object> states = new AtomicReferenceArray<Object>(((Object[])names).length);
            IntRange intRange = ArraysKt.getIndices((Object[])names);
            int thisCollection$iv22 = intRange.getFirst();
            if (thisCollection$iv22 <= (n = intRange.getLast())) {
                while (true) {
                    void i;
                    states.set((int)i, map.get(names[i]));
                    if (i == n) break;
                    ++i;
                }
            }
            return new StateMap(names, states, null);
        }

        @NotNull
        public final Element stateToElement(@NotNull String key, @Nullable Object state, @Nullable Map<String, ? extends Element> newLiveStates) {
            Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
            if (state instanceof Element) {
                Element element = ((Element)state).clone();
                Intrinsics.checkExpressionValueIsNotNull((Object)element, (String)"state.clone()");
                return element;
            }
            Element element = newLiveStates;
            if (element == null || (element = element.get(key)) == null) {
                Object object = state;
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.ByteArray");
                }
                Element element2 = this.unarchiveState((byte[])object);
                element = element2;
                Intrinsics.checkExpressionValueIsNotNull((Object)element2, (String)"unarchiveState(state as ByteArray)");
            }
            return element;
        }

        @NotNull
        public static /* bridge */ /* synthetic */ Element stateToElement$default(Companion companion, String string, Object object, Map map, int n, Object object2) {
            if (object2 != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: stateToElement");
            }
            if ((n & 4) != 0) {
                map = null;
            }
            return companion.stateToElement(string, object, map);
        }

        @Nullable
        public final byte[] getNewByteIfDiffers(@NotNull String key, @NotNull Object newState, @NotNull byte[] oldState) {
            byte[] newBytes;
            byte[] byArray;
            Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
            Intrinsics.checkParameterIsNotNull((Object)newState, (String)"newState");
            Intrinsics.checkParameterIsNotNull((Object)oldState, (String)"oldState");
            if (newState instanceof Element) {
                byArray = this.archiveState((Element)newState);
            } else {
                Object object = newState;
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.ByteArray");
                }
                byArray = newBytes = (byte[])object;
            }
            if (Arrays.equals(newBytes, oldState)) {
                return null;
            }
            if (SystemProperties.getBooleanProperty((String)"idea.log.changed.components", (boolean)false)) {
                Object after;
                getNewByteIfDiffers.1 stateToString$ = getNewByteIfDiffers.1.INSTANCE;
                Object before = stateToString$.invoke(oldState);
                if (Intrinsics.areEqual((Object)before, (Object)(after = stateToString$.invoke(newState)))) {
                    ComponentStoreImplKt.getLOG().info("Serialization error: serialized are different, but unserialized are equal");
                } else {
                    ComponentStoreImplKt.getLOG().info(key + " " + StringUtil.repeat((String)"=", (int)(80 - key.length())) + "\n" + "Before:" + "\n" + (String)before + "\n" + "After:" + "\n" + (String)after);
                }
            }
            return newBytes;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final byte[] archiveState(Element state) {
            BufferExposingByteArrayOutputStream byteOut = new BufferExposingByteArrayOutputStream();
            Closeable $receiver$iv = new OutputStreamWriter((OutputStream)new SnappyOutputStream((OutputStream)byteOut), CharsetToolkit.UTF8_CHARSET);
            boolean closed$iv = false;
            try {
                OutputStreamWriter it = (OutputStreamWriter)$receiver$iv;
                JDOMUtil.MyXMLOutputter xmlOutputter = new JDOMUtil.MyXMLOutputter();
                xmlOutputter.setFormat(Companion.getXML_FORMAT());
                xmlOutputter.output(state, (Writer)it);
                it = Unit.INSTANCE;
            }
            catch (Exception e$iv) {
                closed$iv = true;
                try {
                    $receiver$iv.close();
                }
                catch (Exception closeException$iv) {
                    // empty catch block
                }
                throw (Throwable)e$iv;
            }
            finally {
                if (!closed$iv) {
                    $receiver$iv.close();
                }
            }
            byte[] byArray = ArrayUtil.realloc((byte[])byteOut.getInternalBuffer(), (int)byteOut.size());
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"ArrayUtil.realloc(byteOu\u2026alBuffer, byteOut.size())");
            return byArray;
        }

        private final Element unarchiveState(byte[] state) {
            return JDOMUtil.load((InputStream)((InputStream)new SnappyInputStream((InputStream)new ByteArrayInputStream(state))));
        }

        private Companion() {
        }

        public static final /* synthetic */ Element access$unarchiveState(Companion $this, @NotNull byte[] state) {
            return $this.unarchiveState(state);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

