/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.ActivityTracker;
import com.intellij.ide.ApplicationActivationStateManager;
import com.intellij.ide.CharToVKeyMap;
import com.intellij.ide.IdePopupManager;
import com.intellij.ide.ToolkitBugsProcessor;
import com.intellij.ide.dnd.DnDManager;
import com.intellij.ide.dnd.DnDManagerImpl;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.ui.UISettings;
import com.intellij.idea.IdeaApplication;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.diagnostic.FrequentEventDetector;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.keymap.KeyboardSettingsExternalizable;
import com.intellij.openapi.keymap.impl.IdeKeyEventDispatcher;
import com.intellij.openapi.keymap.impl.IdeMouseEventDispatcher;
import com.intellij.openapi.keymap.impl.KeyState;
import com.intellij.openapi.ui.JBPopupMenu;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ExpirableRunnable;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.openapi.wm.impl.FocusManagerImpl;
import com.intellij.util.Alarm;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashMap;
import com.intellij.util.ui.MouseEventAdapter;
import com.intellij.util.ui.UIUtil;
import java.awt.AWTEvent;
import java.awt.AWTException;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.InputEvent;
import java.awt.event.InputMethodEvent;
import java.awt.event.InvocationEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.ComboPopup;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IdeEventQueue
extends EventQueue {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.IdeEventQueue");
    private final Object myLock = new Object();
    private final List<Runnable> myIdleListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private final List<Runnable> myActivityListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private final Alarm myIdleRequestsAlarm = new Alarm();
    private final Alarm myIdleTimeCounterAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD);
    private long myIdleTime;
    private final Map<Runnable, MyFireIdleRequest> myListener2Request = new HashMap();
    private final IdeKeyEventDispatcher myKeyEventDispatcher = new IdeKeyEventDispatcher(this);
    private final IdeMouseEventDispatcher myMouseEventDispatcher = new IdeMouseEventDispatcher();
    private final IdePopupManager myPopupManager = new IdePopupManager();
    private final ToolkitBugsProcessor myToolkitBugsProcessor = new ToolkitBugsProcessor();
    private boolean mySuspendMode;
    private Component myFocusOwner;
    private final Runnable myExitSuspendModeRunnable = new ExitSuspendModeRunnable();
    private final Alarm mySuspendModeAlarm = new Alarm();
    private int myEventCount;
    private boolean myIsInInputEvent;
    private AWTEvent myCurrentEvent;
    private long myLastActiveTime;
    private WindowManagerEx myWindowManager;
    private final Set<EventDispatcher> myDispatchers = new LinkedHashSet<EventDispatcher>();
    private final Set<EventDispatcher> myPostProcessors = new LinkedHashSet<EventDispatcher>();
    private final Set<Runnable> myReady = ContainerUtil.newHashSet();
    private boolean myKeyboardBusy;
    private boolean myDispatchingFocusEvent;
    private int myInputMethodLock;
    private static boolean ourAppIsLoaded;
    private static int ctrlIsPressedCount;
    private static boolean leftAltIsPressed;
    private static final Field ourInvocationEventRunnableAccessor;
    private MouseEvent lastClickEvent;
    private long lastClickTime;
    private static Field ourStickyAltField;
    private final FrequentEventDetector myFrequentEventDetector = new FrequentEventDetector(1009, 100);
    private Boolean myTestMode;

    public static IdeEventQueue getInstance() {
        return IdeEventQueueHolder.INSTANCE;
    }

    private IdeEventQueue() {
        EventQueue systemEventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
        assert (!(systemEventQueue instanceof IdeEventQueue)) : systemEventQueue;
        systemEventQueue.push(this);
        this.addIdleTimeCounterRequest();
        final KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        keyboardFocusManager.addPropertyChangeListener("permanentFocusOwner", new PropertyChangeListener(){

            @Override
            public void propertyChange(@NotNull PropertyChangeEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/IdeEventQueue$1", "propertyChange"));
                }
                Application application = ApplicationManager.getApplication();
                if (application == null) {
                    return;
                }
                application.assertIsDispatchThread();
                Window focusedWindow = keyboardFocusManager.getFocusedWindow();
                Component focusOwner = keyboardFocusManager.getFocusOwner();
                if (IdeEventQueue.this.mySuspendMode && focusedWindow != null && focusOwner != null && focusOwner != IdeEventQueue.this.myFocusOwner && !(focusOwner instanceof Window)) {
                    IdeEventQueue.this.exitSuspendMode();
                }
            }
        });
        this.addDispatcher(new WindowsAltSuppressor(), null);
    }

    public void setWindowManager(WindowManagerEx windowManager) {
        this.myWindowManager = windowManager;
    }

    private void addIdleTimeCounterRequest() {
        if (this.isTestMode()) {
            return;
        }
        this.myIdleTimeCounterAlarm.cancelAllRequests();
        this.myLastActiveTime = System.currentTimeMillis();
        this.myIdleTimeCounterAlarm.addRequest(new Runnable(){

            @Override
            public void run() {
                IdeEventQueue.this.myIdleTime = IdeEventQueue.this.myIdleTime + (System.currentTimeMillis() - IdeEventQueue.this.myLastActiveTime);
                IdeEventQueue.this.addIdleTimeCounterRequest();
            }
        }, 20000, ModalityState.NON_MODAL);
    }

    public void stopIdleTimeCalculation() {
        this.myIdleTimeCounterAlarm.cancelAllRequests();
    }

    public boolean shouldNotTypeInEditor() {
        return this.myKeyEventDispatcher.isWaitingForSecondKeyStroke() || this.mySuspendMode;
    }

    private void enterSuspendMode() {
        this.mySuspendMode = true;
        this.myFocusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        this.mySuspendModeAlarm.cancelAllRequests();
        this.mySuspendModeAlarm.addRequest(this.myExitSuspendModeRunnable, 750);
    }

    private void exitSuspendMode() {
        if (this.shallEnterSuspendMode()) {
            this.mySuspendModeAlarm.cancelAllRequests();
            this.mySuspendModeAlarm.addRequest(this.myExitSuspendModeRunnable, 250);
        } else {
            this.mySuspendMode = false;
            this.myFocusOwner = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addIdleListener(@NotNull Runnable runnable2, int timeout) {
        if (runnable2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/ide/IdeEventQueue", "addIdleListener"));
        }
        LOG.assertTrue(timeout > 0);
        Object object = this.myLock;
        synchronized (object) {
            this.myIdleListeners.add(runnable2);
            MyFireIdleRequest request = new MyFireIdleRequest(runnable2, timeout);
            this.myListener2Request.put(runnable2, request);
            this.myIdleRequestsAlarm.addRequest((Runnable)request, timeout);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeIdleListener(@NotNull Runnable runnable2) {
        if (runnable2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/ide/IdeEventQueue", "removeIdleListener"));
        }
        Object object = this.myLock;
        synchronized (object) {
            MyFireIdleRequest request;
            boolean wasRemoved = this.myIdleListeners.remove(runnable2);
            if (!wasRemoved) {
                LOG.error("unknown runnable: " + runnable2);
            }
            LOG.assertTrue((request = this.myListener2Request.remove(runnable2)) != null);
            this.myIdleRequestsAlarm.cancelRequest((Runnable)request);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addActivityListener(@NotNull Runnable runnable2) {
        if (runnable2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/ide/IdeEventQueue", "addActivityListener"));
        }
        Object object = this.myLock;
        synchronized (object) {
            this.myActivityListeners.add(runnable2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addActivityListener(@NotNull Runnable runnable2, Disposable parentDisposable) {
        if (runnable2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/ide/IdeEventQueue", "addActivityListener"));
        }
        Object object = this.myLock;
        synchronized (object) {
            ContainerUtil.add((Object)runnable2, this.myActivityListeners, (Disposable)parentDisposable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeActivityListener(@NotNull Runnable runnable2) {
        if (runnable2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/ide/IdeEventQueue", "removeActivityListener"));
        }
        Object object = this.myLock;
        synchronized (object) {
            this.myActivityListeners.remove(runnable2);
        }
    }

    public void addDispatcher(EventDispatcher dispatcher, Disposable parent) {
        IdeEventQueue._addProcessor(dispatcher, parent, this.myDispatchers);
    }

    public void removeDispatcher(EventDispatcher dispatcher) {
        this.myDispatchers.remove(dispatcher);
    }

    public boolean containsDispatcher(EventDispatcher dispatcher) {
        return this.myDispatchers.contains(dispatcher);
    }

    public void addPostprocessor(EventDispatcher dispatcher, @Nullable Disposable parent) {
        IdeEventQueue._addProcessor(dispatcher, parent, this.myPostProcessors);
    }

    public void removePostprocessor(EventDispatcher dispatcher) {
        this.myPostProcessors.remove(dispatcher);
    }

    private static void _addProcessor(final EventDispatcher dispatcher, Disposable parent, final Set<EventDispatcher> set) {
        set.add(dispatcher);
        if (parent != null) {
            Disposer.register((Disposable)parent, (Disposable)new Disposable(){

                public void dispose() {
                    set.remove(dispatcher);
                }
            });
        }
    }

    public int getEventCount() {
        return this.myEventCount;
    }

    public void setEventCount(int evCount) {
        this.myEventCount = evCount;
    }

    public AWTEvent getTrueCurrentEvent() {
        return this.myCurrentEvent;
    }

    private static boolean appIsLoaded() {
        if (ourAppIsLoaded) {
            return true;
        }
        boolean loaded = IdeaApplication.isLoaded();
        if (loaded) {
            ourAppIsLoaded = true;
        }
        return loaded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispatchEvent(@NotNull AWTEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/IdeEventQueue", "dispatchEvent"));
        }
        if (!IdeEventQueue.appIsLoaded()) {
            try {
                super.dispatchEvent(e);
            }
            catch (Throwable t) {
                this.processException(t);
            }
            return;
        }
        e = InertialMouseRouter.changeSourceIfNeeded(e);
        e = IdeEventQueue.fixNonEnglishKeyboardLayouts(e);
        e = IdeEventQueue.mapEvent(e);
        boolean wasInputEvent = this.myIsInInputEvent;
        this.myIsInInputEvent = e instanceof InputEvent || e instanceof InputMethodEvent || e instanceof WindowEvent || e instanceof ActionEvent;
        AWTEvent oldEvent = this.myCurrentEvent;
        this.myCurrentEvent = e;
        try {
            this._dispatchEvent(e, false);
        }
        catch (Throwable t) {
            this.processException(t);
        }
        finally {
            this.myIsInInputEvent = wasInputEvent;
            this.myCurrentEvent = oldEvent;
            for (EventDispatcher each : this.myPostProcessors) {
                each.dispatch(e);
            }
            if (e instanceof KeyEvent) {
                this.maybeReady();
            }
        }
    }

    private void processException(Throwable t) {
        if (!this.myToolkitBugsProcessor.process(t)) {
            PluginManager.processException(t);
        }
    }

    private static AWTEvent fixNonEnglishKeyboardLayouts(AWTEvent e) {
        if (!(e instanceof KeyEvent)) {
            return e;
        }
        KeyboardSettingsExternalizable externalizable = KeyboardSettingsExternalizable.getInstance();
        if (externalizable == null || !externalizable.isNonEnglishKeyboardSupportEnabled()) {
            return e;
        }
        KeyEvent ke = (KeyEvent)e;
        Window sourceComponent = WindowManagerEx.getInstanceEx().getMostRecentFocusedWindow();
        if (ke.getID() == 401) {
            switch (ke.getKeyCode()) {
                case 17: {
                    if ((ke.getModifiersEx() & 0x280) == 640) break;
                    ++ctrlIsPressedCount;
                    break;
                }
                case 18: {
                    if (ke.getKeyLocation() != 2 || (ke.getModifiersEx() & 0x280) == 640) break;
                    leftAltIsPressed = true;
                }
            }
        } else if (ke.getID() == 402) {
            switch (ke.getKeyCode()) {
                case 17: {
                    --ctrlIsPressedCount;
                    break;
                }
                case 18: {
                    if (ke.getKeyLocation() != 2) break;
                    leftAltIsPressed = false;
                }
            }
        }
        if (!leftAltIsPressed && KeyboardSettingsExternalizable.getInstance().isUkrainianKeyboard((Component)sourceComponent) && ('\u0491' == ke.getKeyChar() || ke.getKeyCode() == 85)) {
            ke = new KeyEvent(ke.getComponent(), ke.getID(), ke.getWhen(), 0, 0, '\u0491', ke.getKeyLocation());
            ke.setKeyCode(85);
            ke.setKeyChar('\u0491');
            return ke;
        }
        Integer keyCodeFromChar = CharToVKeyMap.get(Character.valueOf(ke.getKeyChar()));
        if (keyCodeFromChar != null) {
            if (keyCodeFromChar.intValue() != ke.getKeyCode()) {
                ke.setKeyCode(keyCodeFromChar);
            }
            if (sourceComponent != null && KeyboardSettingsExternalizable.isSupportedKeyboardLayout((Component)sourceComponent) && (ke.getModifiersEx() & 0x280) != 0) {
                int modifiers = ke.getModifiersEx() ^ 0x200 ^ 0x80;
                if (ctrlIsPressedCount > 1) {
                    modifiers |= 0x80;
                }
                if (leftAltIsPressed) {
                    modifiers |= 8;
                }
                e = new KeyEvent(ke.getComponent(), ke.getID(), ke.getWhen(), modifiers, ke.getKeyCode(), ke.getKeyChar(), ke.getKeyLocation());
            }
        }
        return e;
    }

    private static AWTEvent mapEvent(AWTEvent e) {
        if (SystemInfo.isXWindow && e instanceof MouseEvent && ((MouseEvent)e).getButton() > 3) {
            MouseEvent src = (MouseEvent)e;
            e = src.getButton() < 6 ? new MouseWheelEvent(src.getComponent(), 507, src.getWhen(), src.getModifiers() | 0x40, src.getX(), src.getY(), 0, false, 0, src.getClickCount(), src.getButton() == 4 ? -1 : 1) : new MouseEvent(src.getComponent(), src.getID(), src.getWhen(), src.getModifiers() | 1 << 8 + src.getButton(), src.getX(), src.getY(), 1, src.isPopupTrigger(), src.getButton() - 2);
        }
        return e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _dispatchEvent(@NotNull AWTEvent e, boolean typeAheadFlushing) {
        Object selectedPath;
        DnDManagerImpl dndManager;
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/IdeEventQueue", "_dispatchEvent"));
        }
        if (e.getID() == 506 && (dndManager = (DnDManagerImpl)DnDManager.getInstance()) != null) {
            dndManager.setLastDropHandler(null);
        }
        ++this.myEventCount;
        IdeEventQueue.traceClipboardEvents(e);
        if (IdeEventQueue.processAppActivationEvents(e)) {
            return;
        }
        if (!typeAheadFlushing) {
            this.fixStickyFocusedComponents(e);
        }
        if (!this.myPopupManager.isPopupActive()) {
            this.enterSuspendModeIfNeeded(e);
        }
        boolean bl = this.myKeyboardBusy = e instanceof KeyEvent || this.peekEvent(401) != null || this.peekEvent(402) != null || this.peekEvent(400) != null;
        if (e instanceof KeyEvent && e.getID() == 402 && ((KeyEvent)e).getKeyCode() == 16) {
            this.myMouseEventDispatcher.resetHorScrollingTracker();
        }
        if (!typeAheadFlushing && IdeEventQueue.typeAheadDispatchToFocusManager(e)) {
            return;
        }
        if (e instanceof WindowEvent) {
            ActivityTracker.getInstance().inc();
        }
        if (e instanceof MouseWheelEvent && ((MenuElement[])(selectedPath = MenuSelectionManager.defaultManager().getSelectedPath())).length > 0 && !(selectedPath[0] instanceof ComboPopup)) {
            ((MouseWheelEvent)e).consume();
            Component component = selectedPath[0].getComponent();
            if (component instanceof JBPopupMenu) {
                ((JBPopupMenu)component).processMouseWheelEvent((MouseWheelEvent)e);
            }
            return;
        }
        if (e instanceof KeyEvent || e instanceof MouseEvent) {
            ActivityTracker.getInstance().inc();
            selectedPath = this.myLock;
            synchronized (selectedPath) {
                this.myIdleRequestsAlarm.cancelAllRequests();
                for (Runnable idleListener : this.myIdleListeners) {
                    MyFireIdleRequest request = this.myListener2Request.get(idleListener);
                    if (request == null) {
                        LOG.error("There is no request for " + idleListener);
                        continue;
                    }
                    this.myIdleRequestsAlarm.addRequest((Runnable)request, request.getTimeout(), ModalityState.NON_MODAL);
                }
                if (401 == e.getID() || 400 == e.getID() || 501 == e.getID() || 502 == e.getID() || 500 == e.getID()) {
                    this.addIdleTimeCounterRequest();
                    for (Runnable activityListener : this.myActivityListeners) {
                        activityListener.run();
                    }
                }
            }
        }
        if (this.myPopupManager.isPopupActive() && this.myPopupManager.dispatch(e)) {
            if (this.myKeyEventDispatcher.isWaitingForSecondKeyStroke()) {
                this.myKeyEventDispatcher.setState(KeyState.STATE_INIT);
            }
            return;
        }
        for (EventDispatcher eachDispatcher : this.myDispatchers) {
            if (!eachDispatcher.dispatch(e)) continue;
            return;
        }
        if (e instanceof InputMethodEvent && SystemInfo.isMac && this.myKeyEventDispatcher.isWaitingForSecondKeyStroke()) {
            return;
        }
        if (e instanceof ComponentEvent && this.myWindowManager != null) {
            this.myWindowManager.dispatchComponentEvent((ComponentEvent)e);
        }
        if (e instanceof KeyEvent) {
            if (this.mySuspendMode || !this.myKeyEventDispatcher.dispatchKeyEvent((KeyEvent)e)) {
                this.defaultDispatchEvent(e);
            } else {
                ((KeyEvent)e).consume();
                this.defaultDispatchEvent(e);
            }
        } else if (e instanceof MouseEvent) {
            MouseEvent me = (MouseEvent)e;
            if (IdeMouseEventDispatcher.patchClickCount(me) && me.getID() == 500) {
                final MouseEvent toDispatch = new MouseEvent(me.getComponent(), me.getID(), System.currentTimeMillis(), me.getModifiers(), me.getX(), me.getY(), 1, me.isPopupTrigger(), me.getButton());
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        IdeEventQueue.this.dispatchEvent(toDispatch);
                    }
                });
            }
            if (me.getButton() != 0) {
                this.setLastClickEvent(me);
            } else if (this.lastClickEvent != null && Math.abs(System.currentTimeMillis() - this.lastClickTime) > 200L) {
                this.setLastClickEvent(null);
            }
            if (!this.myMouseEventDispatcher.dispatchMouseEvent(me)) {
                this.defaultDispatchEvent(e);
            }
        } else {
            this.defaultDispatchEvent(e);
        }
    }

    private static void traceClipboardEvents(AWTEvent e) {
        if (ourInvocationEventRunnableAccessor != null && e instanceof InvocationEvent && e.getClass().getName().equals("sun.awt.PeerEvent")) {
            try {
                String className;
                Object r = ourInvocationEventRunnableAccessor.get(e);
                if (r != null && (className = r.getClass().getName()).contains("sun.awt.datatransfer.SunClipboard") && className.contains("Lambda")) {
                    LOG.info("Clipboard has been set by other application");
                }
            }
            catch (Exception ex) {
                LOG.warn("Error accessing java.awt.event.InvocationEvent.runnable field");
            }
        }
    }

    private void setLastClickEvent(@Nullable MouseEvent event) {
        this.lastClickEvent = event;
        this.lastClickTime = System.currentTimeMillis();
    }

    public boolean wasRootRecentlyClicked(Component component) {
        return component != null && this.lastClickEvent != null && this.lastClickEvent.getComponent() != null && SwingUtilities.getRoot(this.lastClickEvent.getComponent()) == SwingUtilities.getRoot(component);
    }

    private static void fixStickyWindow(KeyboardFocusManager mgr, Window wnd, String resetMethod) {
        if (wnd != null && !wnd.isShowing()) {
            Method setActive;
            Window showingWindow;
            for (showingWindow = wnd; showingWindow != null && !showingWindow.isShowing(); showingWindow = (Window)showingWindow.getParent()) {
            }
            if (showingWindow == null) {
                Frame[] allFrames;
                for (Frame each : allFrames = Frame.getFrames()) {
                    if (!each.isShowing()) continue;
                    showingWindow = each;
                    break;
                }
            }
            if (showingWindow != null && showingWindow != wnd && (setActive = ReflectionUtil.findMethod((Collection)ReflectionUtil.getClassDeclaredMethods(KeyboardFocusManager.class, (boolean)false), (String)resetMethod, (Class[])new Class[]{Window.class})) != null) {
                try {
                    setActive.invoke((Object)mgr, showingWindow);
                }
                catch (Exception exc) {
                    LOG.info((Throwable)exc);
                }
            }
        }
    }

    public void fixStickyFocusedComponents(@Nullable AWTEvent e) {
        Component focusOwner;
        if (e != null && !(e instanceof InputEvent)) {
            return;
        }
        final KeyboardFocusManager mgr = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        if (Registry.is((String)"actionSystem.fixStickyFocusedWindows")) {
            IdeEventQueue.fixStickyWindow(mgr, mgr.getActiveWindow(), "setGlobalActiveWindow");
            IdeEventQueue.fixStickyWindow(mgr, mgr.getFocusedWindow(), "setGlobalFocusedWindow");
        }
        if (Registry.is((String)"actionSystem.fixNullFocusedComponent") && ((focusOwner = mgr.getFocusOwner()) == null || !focusOwner.isShowing() || focusOwner instanceof JFrame || focusOwner instanceof JDialog)) {
            boolean okToFixFocus;
            Application app = ApplicationManager.getApplication();
            if (app instanceof ApplicationEx && !((ApplicationEx)app).isLoaded()) {
                return;
            }
            boolean mouseEventsAhead = IdeEventQueue.isMouseEventAhead(e);
            boolean focusTransferredNow = IdeFocusManager.getGlobalInstance().isFocusBeingTransferred();
            boolean bl = okToFixFocus = !mouseEventsAhead && !focusTransferredNow;
            if (okToFixFocus) {
                Method getNativeFocusOwner;
                Window showingWindow = mgr.getActiveWindow();
                if (showingWindow == null && (getNativeFocusOwner = ReflectionUtil.getDeclaredMethod(KeyboardFocusManager.class, (String)"getNativeFocusOwner", (Class[])new Class[0])) != null) {
                    try {
                        Object owner = getNativeFocusOwner.invoke((Object)mgr, new Object[0]);
                        if (owner instanceof Component) {
                            showingWindow = UIUtil.getWindow((Component)((Component)owner));
                        }
                    }
                    catch (Exception e1) {
                        LOG.debug((Throwable)e1);
                    }
                }
                if (showingWindow != null) {
                    final IdeFocusManager fm = IdeFocusManager.findInstanceByComponent((Component)showingWindow);
                    ExpirableRunnable maybeRequestDefaultFocus = new ExpirableRunnable(){

                        public void run() {
                            if (IdeEventQueue.this.getPopupManager().requestDefaultFocus(false)) {
                                return;
                            }
                            Application app = ApplicationManager.getApplication();
                            if (app != null && app.isActive()) {
                                fm.requestDefaultFocus(false);
                            }
                        }

                        public boolean isExpired() {
                            return !UIUtil.isMeaninglessFocusOwner((Component)mgr.getFocusOwner());
                        }
                    };
                    fm.revalidateFocus(maybeRequestDefaultFocus);
                }
            }
        }
    }

    public static boolean isMouseEventAhead(@Nullable AWTEvent e) {
        IdeEventQueue queue = IdeEventQueue.getInstance();
        return e instanceof MouseEvent || queue.peekEvent(501) != null || queue.peekEvent(502) != null || queue.peekEvent(500) != null;
    }

    private void enterSuspendModeIfNeeded(AWTEvent e) {
        if (e instanceof KeyEvent && !this.mySuspendMode && this.shallEnterSuspendMode()) {
            this.enterSuspendMode();
        }
    }

    private boolean shallEnterSuspendMode() {
        return this.peekEvent(200) != null;
    }

    private static boolean processAppActivationEvents(AWTEvent e) {
        if (e instanceof WindowEvent) {
            WindowEvent we = (WindowEvent)e;
            ApplicationActivationStateManager.get();
            ApplicationActivationStateManager.updateState(we);
            IdeEventQueue.storeLastFocusedComponent(we);
        }
        return false;
    }

    private static void storeLastFocusedComponent(WindowEvent we) {
        Window eventWindow = we.getWindow();
        if (we.getID() == 206 || we.getID() == 208) {
            Component frame = UIUtil.findUltimateParent((Component)eventWindow);
            Component focusOwnerInDeactivatedWindow = eventWindow.getMostRecentFocusOwner();
            IdeFrame[] allProjectFrames = WindowManager.getInstance().getAllProjectFrames();
            if (focusOwnerInDeactivatedWindow != null) {
                for (IdeFrame ideFrame : allProjectFrames) {
                    IdeFocusManager focusManager;
                    JFrame aFrame = WindowManager.getInstance().getFrame(ideFrame.getProject());
                    if (!aFrame.equals(frame) || !((focusManager = IdeFocusManager.getGlobalInstance()) instanceof FocusManagerImpl)) continue;
                    ((FocusManagerImpl)focusManager).setLastFocusedAtDeactivation(ideFrame, focusOwnerInDeactivatedWindow);
                }
            }
        }
    }

    private void defaultDispatchEvent(AWTEvent e) {
        try {
            this.myDispatchingFocusEvent = e instanceof FocusEvent;
            this.maybeReady();
            IdeEventQueue.fixStickyAlt(e);
            super.dispatchEvent(e);
        }
        catch (Throwable t) {
            this.processException(t);
        }
        finally {
            this.myDispatchingFocusEvent = false;
        }
    }

    private static void fixStickyAlt(AWTEvent e) {
        if (Registry.is((String)"actionSystem.win.suppressAlt.new")) {
            if (UIUtil.isUnderWindowsLookAndFeel() && e instanceof InputEvent && (((InputEvent)e).getModifiers() & 0x208) != 0 && (!(e instanceof KeyEvent) || ((KeyEvent)e).getKeyCode() != 18)) {
                try {
                    if (ourStickyAltField == null) {
                        Class<?> aClass = Class.forName("com.sun.java.swing.plaf.windows.WindowsRootPaneUI$AltProcessor");
                        ourStickyAltField = ReflectionUtil.getDeclaredField(aClass, (String)"menuCanceledOnPress");
                    }
                    if (ourStickyAltField != null) {
                        ourStickyAltField.set(null, true);
                    }
                }
                catch (Exception exception) {
                    LOG.error((Throwable)exception);
                }
            }
        } else if (SystemInfo.isWinXpOrNewer && !SystemInfo.isWinVistaOrNewer && e instanceof KeyEvent && ((KeyEvent)e).getKeyCode() == 18) {
            ((KeyEvent)e).consume();
        }
    }

    public boolean isDispatchingFocusEvent() {
        return this.myDispatchingFocusEvent;
    }

    private static boolean typeAheadDispatchToFocusManager(AWTEvent e) {
        KeyEvent event;
        if (e instanceof KeyEvent && !(event = (KeyEvent)e).isConsumed()) {
            IdeFocusManager focusManager = IdeFocusManager.findInstanceByComponent((Component)event.getComponent());
            return focusManager.dispatch(event);
        }
        return false;
    }

    public void flushQueue() {
        AWTEvent event;
        while ((event = this.peekEvent()) != null) {
            try {
                AWTEvent event1 = this.getNextEvent();
                this.dispatchEvent(event1);
                continue;
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
                continue;
            }
            break;
        }
        return;
    }

    public void pumpEventsForHierarchy(Component modalComponent, Condition<AWTEvent> exitCondition) {
        AWTEvent event;
        do {
            try {
                Object s;
                event = this.getNextEvent();
                boolean eventOk = true;
                if (event instanceof InputEvent && (s = event.getSource()) instanceof Component) {
                    Component c;
                    Window modalWindow;
                    Window window = modalWindow = modalComponent == null ? null : SwingUtilities.windowForComponent(modalComponent);
                    for (c = (Component)s; c != null && c != modalWindow; c = c.getParent()) {
                    }
                    if (c == null) {
                        eventOk = false;
                        ((InputEvent)event).consume();
                    }
                }
                if (!eventOk) continue;
                this.dispatchEvent(event);
            }
            catch (Throwable e) {
                LOG.error(e);
                event = null;
            }
        } while (!exitCondition.value((Object)event));
    }

    public long getIdleTime() {
        return this.myIdleTime;
    }

    public IdePopupManager getPopupManager() {
        return this.myPopupManager;
    }

    public IdeKeyEventDispatcher getKeyEventDispatcher() {
        return this.myKeyEventDispatcher;
    }

    public void blockNextEvents(MouseEvent e) {
        this.blockNextEvents(e, BlockMode.COMPLETE);
    }

    public void blockNextEvents(MouseEvent e, BlockMode blockMode) {
        this.myMouseEventDispatcher.blockNextEvents(e, blockMode);
    }

    public boolean isSuspendMode() {
        return this.mySuspendMode;
    }

    public boolean hasFocusEventsPending() {
        return this.peekEvent(1004) != null || this.peekEvent(1005) != null;
    }

    private boolean isReady() {
        return !this.myKeyboardBusy && this.myKeyEventDispatcher.isReady();
    }

    public void maybeReady() {
        this.flushReady();
    }

    private void flushReady() {
        if (this.myReady.isEmpty() || !this.isReady()) {
            return;
        }
        Runnable[] ready = this.myReady.toArray(new Runnable[this.myReady.size()]);
        this.myReady.clear();
        for (Runnable each : ready) {
            each.run();
        }
    }

    public void doWhenReady(final Runnable runnable2) {
        if (EventQueue.isDispatchThread()) {
            this.myReady.add(runnable2);
            this.maybeReady();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    IdeEventQueue.this.myReady.add(runnable2);
                    IdeEventQueue.this.maybeReady();
                }
            });
        }
    }

    public boolean isPopupActive() {
        return this.myPopupManager.isPopupActive();
    }

    public boolean isInputMethodEnabled() {
        return !SystemInfo.isMac || this.myInputMethodLock == 0;
    }

    public void disableInputMethods(Disposable parentDisposable) {
        ++this.myInputMethodLock;
        Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

            public void dispose() {
                IdeEventQueue.this.myInputMethodLock--;
            }
        });
    }

    @Override
    public void postEvent(@NotNull AWTEvent theEvent) {
        if (theEvent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "theEvent", "com/intellij/ide/IdeEventQueue", "postEvent"));
        }
        this.myFrequentEventDetector.eventHappened();
        super.postEvent(theEvent);
    }

    @Override
    public AWTEvent peekEvent() {
        AWTEvent event = super.peekEvent();
        if (event != null) {
            return event;
        }
        if (this.isTestMode() && LaterInvocator.ensureFlushRequested()) {
            return super.peekEvent();
        }
        return null;
    }

    private boolean isTestMode() {
        Boolean testMode = this.myTestMode;
        if (testMode != null) {
            return testMode;
        }
        Application application = ApplicationManager.getApplication();
        if (application == null) {
            return false;
        }
        this.myTestMode = testMode = Boolean.valueOf(application.isUnitTestMode());
        return testMode;
    }

    static {
        Field field = null;
        if (Registry.is((String)"trace.clipboard.events") && SystemInfo.isJavaVersionAtLeast((String)"1.8.0_60")) {
            try {
                field = InvocationEvent.class.getDeclaredField("runnable");
                field.setAccessible(true);
            }
            catch (Exception e) {
                LOG.warn("Error creating accessor for java.awt.event.InvocationEvent.runnable field", (Throwable)e);
            }
        }
        ourInvocationEventRunnableAccessor = field;
    }

    public static enum BlockMode {
        COMPLETE,
        ACTIONS;

    }

    private static class WindowsAltSuppressor
    implements EventDispatcher {
        private boolean myWaitingForAltRelease;
        private Robot myRobot;

        private WindowsAltSuppressor() {
        }

        @Override
        public boolean dispatch(AWTEvent e) {
            boolean dispatch = true;
            if (e instanceof KeyEvent) {
                boolean pureAlt;
                KeyEvent ke = (KeyEvent)e;
                final Component component = ke.getComponent();
                boolean bl = pureAlt = ke.getKeyCode() == 18 && (ke.getModifiers() | 8) == 8;
                if (!pureAlt) {
                    this.myWaitingForAltRelease = false;
                } else {
                    if (ApplicationManager.getApplication() == null || UISettings.getInstance() == null || !SystemInfo.isWindows || !Registry.is((String)"actionSystem.win.suppressAlt") || !UISettings.getInstance().HIDE_TOOL_STRIPES && !UISettings.getInstance().PRESENTATION_MODE) {
                        return false;
                    }
                    if (ke.getID() == 401) {
                        dispatch = !this.myWaitingForAltRelease;
                    } else if (ke.getID() == 402) {
                        if (this.myWaitingForAltRelease) {
                            this.myWaitingForAltRelease = false;
                            dispatch = false;
                        } else if (component != null) {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    try {
                                        Window window = UIUtil.getWindow((Component)component);
                                        if (window == null || !window.isActive()) {
                                            return;
                                        }
                                        WindowsAltSuppressor.this.myWaitingForAltRelease = true;
                                        if (WindowsAltSuppressor.this.myRobot == null) {
                                            WindowsAltSuppressor.this.myRobot = new Robot();
                                        }
                                        WindowsAltSuppressor.this.myRobot.keyPress(18);
                                        WindowsAltSuppressor.this.myRobot.keyRelease(18);
                                    }
                                    catch (AWTException e1) {
                                        LOG.debug((Throwable)e1);
                                    }
                                }
                            });
                        }
                    }
                }
            }
            return !dispatch;
        }
    }

    private final class ExitSuspendModeRunnable
    implements Runnable {
        private ExitSuspendModeRunnable() {
        }

        @Override
        public void run() {
            if (IdeEventQueue.this.mySuspendMode) {
                IdeEventQueue.this.exitSuspendMode();
            }
        }
    }

    private final class MyFireIdleRequest
    implements Runnable {
        private final Runnable myRunnable;
        private final int myTimeout;

        public MyFireIdleRequest(Runnable runnable2, int timeout) {
            if (runnable2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/ide/IdeEventQueue$MyFireIdleRequest", "<init>"));
            }
            this.myTimeout = timeout;
            this.myRunnable = runnable2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.myRunnable.run();
            Object object = IdeEventQueue.this.myLock;
            synchronized (object) {
                if (IdeEventQueue.this.myIdleListeners.contains(this.myRunnable)) {
                    IdeEventQueue.this.myIdleRequestsAlarm.addRequest((Runnable)this, this.myTimeout, ModalityState.NON_MODAL);
                }
            }
        }

        public int getTimeout() {
            return this.myTimeout;
        }
    }

    public static interface EventDispatcher {
        public boolean dispatch(AWTEvent var1);
    }

    private static class InertialMouseRouter {
        private static final int MOUSE_WHEEL_RESTART_THRESHOLD = 50;
        private static Component wheelDestinationComponent;
        private static long lastMouseWheel;

        private InertialMouseRouter() {
        }

        private static AWTEvent changeSourceIfNeeded(AWTEvent awtEvent) {
            if (SystemInfo.isMac && Registry.is((String)"ide.inertial.mouse.fix") && awtEvent instanceof MouseWheelEvent) {
                MouseWheelEvent mwe = (MouseWheelEvent)awtEvent;
                if (mwe.getWhen() - lastMouseWheel > 50L) {
                    wheelDestinationComponent = SwingUtilities.getDeepestComponentAt(mwe.getComponent(), mwe.getX(), mwe.getY());
                }
                lastMouseWheel = System.currentTimeMillis();
                int modifiers = mwe.getModifiers() | mwe.getModifiersEx();
                return MouseEventAdapter.convert((MouseWheelEvent)mwe, (Component)wheelDestinationComponent, (int)mwe.getID(), (long)lastMouseWheel, (int)modifiers, (int)mwe.getX(), (int)mwe.getY());
            }
            return awtEvent;
        }
    }

    private static class IdeEventQueueHolder {
        private static final IdeEventQueue INSTANCE = new IdeEventQueue();

        private IdeEventQueueHolder() {
        }
    }
}

