/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl;

import com.intellij.openapi.project.Project;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractUrl {
    protected final String url;
    protected final String moduleName;
    private final String myType;

    protected AbstractUrl(String url, String moduleName, @NonNls String type) {
        this.myType = type;
        this.url = url == null ? "" : url;
        this.moduleName = moduleName;
    }

    public void write(Element element) {
        element.setAttribute("url", this.url);
        if (this.moduleName != null) {
            element.setAttribute("module", this.moduleName);
        }
        element.setAttribute("type", this.myType);
    }

    @Nullable
    public abstract Object[] createPath(Project var1);

    public AbstractUrl createUrl(String type, String moduleName, String url) {
        if (type.equals(this.myType)) {
            return this.createUrl(moduleName, url);
        }
        return null;
    }

    protected abstract AbstractUrl createUrl(String var1, String var2);

    public abstract AbstractUrl createUrlByElement(Object var1);

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractUrl that = (AbstractUrl)o;
        if (this.moduleName != null ? !this.moduleName.equals(that.moduleName) : that.moduleName != null) {
            return false;
        }
        if (this.myType != null ? !this.myType.equals(that.myType) : that.myType != null) {
            return false;
        }
        return !(this.url != null ? !this.url.equals(that.url) : that.url != null);
    }

    public int hashCode() {
        int result2 = this.url != null ? this.url.hashCode() : 0;
        result2 = 29 * result2 + (this.moduleName != null ? this.moduleName.hashCode() : 0);
        result2 = 29 * result2 + (this.myType != null ? this.myType.hashCode() : 0);
        return result2;
    }
}

