/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor;

import com.intellij.codeInsight.editorActions.TextBlockTransferableData;
import java.awt.datatransfer.DataFlavor;

public class CaretStateTransferableData
implements TextBlockTransferableData {
    public static final DataFlavor FLAVOR = new DataFlavor(CaretStateTransferableData.class, "Caret state");
    public final int[] startOffsets;
    public final int[] endOffsets;

    public CaretStateTransferableData(int[] startOffsets, int[] endOffsets) {
        this.startOffsets = startOffsets;
        this.endOffsets = endOffsets;
    }

    @Override
    public DataFlavor getFlavor() {
        return FLAVOR;
    }

    @Override
    public int getOffsetCount() {
        return this.startOffsets.length + this.endOffsets.length;
    }

    @Override
    public int getOffsets(int[] offsets, int index) {
        System.arraycopy(this.startOffsets, 0, offsets, index, this.startOffsets.length);
        System.arraycopy(this.endOffsets, 0, offsets, index + this.startOffsets.length, this.endOffsets.length);
        return index + this.getOffsetCount();
    }

    @Override
    public int setOffsets(int[] offsets, int index) {
        System.arraycopy(offsets, index, this.startOffsets, 0, this.startOffsets.length);
        System.arraycopy(offsets, index + this.startOffsets.length, this.endOffsets, 0, this.endOffsets.length);
        return index + this.getOffsetCount();
    }
}

