/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.module.impl.scopes;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleSourceOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiBundle;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.NotNullFunction;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import gnu.trove.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModuleWithDependenciesScope
extends GlobalSearchScope {
    public static final int COMPILE = 1;
    public static final int LIBRARIES = 2;
    public static final int MODULES = 4;
    public static final int TESTS = 8;
    public static final int RUNTIME = 16;
    public static final int CONTENT = 32;
    private final Module myModule;
    @ScopeConstant
    private final int myOptions;
    private final ProjectFileIndex myProjectFileIndex;
    private final Set<Module> myModules;
    private final TObjectIntHashMap<VirtualFile> myRoots;

    public ModuleWithDependenciesScope(@NotNull Module module, @ScopeConstant int options) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/openapi/module/impl/scopes/ModuleWithDependenciesScope", "<init>"));
        }
        super(module.getProject());
        this.myRoots = new TObjectIntHashMap();
        this.myModule = module;
        this.myOptions = options;
        this.myProjectFileIndex = ProjectRootManager.getInstance((Project)module.getProject()).getFileIndex();
        OrderEnumerator en = ModuleRootManager.getInstance((Module)module).orderEntries();
        en.recursively();
        if (this.hasOption(1)) {
            en.exportedOnly().compileOnly();
        }
        if (this.hasOption(16)) {
            en.runtimeOnly();
        }
        if (!this.hasOption(2)) {
            en.withoutLibraries().withoutSdk();
        }
        if (!this.hasOption(4)) {
            en.withoutDepModules();
        }
        if (!this.hasOption(8)) {
            en.productionOnly();
        }
        final LinkedHashSet modules = ContainerUtil.newLinkedHashSet();
        en.forEach((Processor)new Processor<OrderEntry>(){

            public boolean process(OrderEntry each) {
                if (each instanceof ModuleOrderEntry) {
                    ContainerUtil.addIfNotNull((Collection)modules, (Object)((ModuleOrderEntry)each).getModule());
                } else if (each instanceof ModuleSourceOrderEntry) {
                    ContainerUtil.addIfNotNull((Collection)modules, (Object)each.getOwnerModule());
                }
                return true;
            }
        });
        this.myModules = new THashSet((Collection)modules);
        LinkedHashSet roots = ContainerUtil.newLinkedHashSet();
        if (this.hasOption(32)) {
            for (Module m : modules) {
                for (ContentEntry entry : ModuleRootManager.getInstance((Module)m).getContentEntries()) {
                    ContainerUtil.addIfNotNull((Object)entry.getFile(), (Collection)roots);
                }
            }
        } else {
            Collections.addAll(roots, en.roots((NotNullFunction)new NotNullFunction<OrderEntry, OrderRootType>(){

                @NotNull
                public OrderRootType fun(OrderEntry entry) {
                    if (entry instanceof ModuleOrderEntry || entry instanceof ModuleSourceOrderEntry) {
                        OrderRootType orderRootType = OrderRootType.SOURCES;
                        if (orderRootType == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/scopes/ModuleWithDependenciesScope$2", "fun"));
                        }
                        return orderRootType;
                    }
                    OrderRootType orderRootType = OrderRootType.CLASSES;
                    if (orderRootType == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/scopes/ModuleWithDependenciesScope$2", "fun"));
                    }
                    return orderRootType;
                }
            }).getRoots());
        }
        int i = 1;
        for (VirtualFile root : roots) {
            this.myRoots.put((Object)root, i++);
        }
    }

    @NotNull
    public Module getModule() {
        Module module = this.myModule;
        if (module == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/scopes/ModuleWithDependenciesScope", "getModule"));
        }
        return module;
    }

    private boolean hasOption(@ScopeConstant int option) {
        return (this.myOptions & option) != 0;
    }

    @NotNull
    public String getDisplayName() {
        String string = this.hasOption(1) ? PsiBundle.message((String)"search.scope.module", (Object[])new Object[]{this.myModule.getName()}) : PsiBundle.message((String)"search.scope.module.runtime", (Object[])new Object[]{this.myModule.getName()});
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/scopes/ModuleWithDependenciesScope", "getDisplayName"));
        }
        return string;
    }

    public boolean isSearchInModuleContent(@NotNull Module aModule) {
        if (aModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aModule", "com/intellij/openapi/module/impl/scopes/ModuleWithDependenciesScope", "isSearchInModuleContent"));
        }
        return this.myModules.contains(aModule);
    }

    public boolean isSearchInModuleContent(@NotNull Module aModule, boolean testSources) {
        if (aModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aModule", "com/intellij/openapi/module/impl/scopes/ModuleWithDependenciesScope", "isSearchInModuleContent"));
        }
        return this.isSearchInModuleContent(aModule) && (this.hasOption(8) || !testSources);
    }

    public boolean isSearchInLibraries() {
        return this.hasOption(2);
    }

    public boolean contains(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/module/impl/scopes/ModuleWithDependenciesScope", "contains"));
        }
        if (this.hasOption(32)) {
            return this.myRoots.contains((Object)this.myProjectFileIndex.getContentRootForFile(file2));
        }
        if (this.myProjectFileIndex.isInContent(file2) && this.myRoots.contains((Object)this.myProjectFileIndex.getSourceRootForFile(file2))) {
            return true;
        }
        return this.myRoots.contains((Object)this.myProjectFileIndex.getClassRootForFile(file2));
    }

    public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
        VirtualFile r2;
        if (file1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file1", "com/intellij/openapi/module/impl/scopes/ModuleWithDependenciesScope", "compare"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file2", "com/intellij/openapi/module/impl/scopes/ModuleWithDependenciesScope", "compare"));
        }
        VirtualFile r1 = this.getFileRoot(file1);
        if (Comparing.equal((Object)r1, (Object)(r2 = this.getFileRoot(file2)))) {
            return 0;
        }
        if (r1 == null) {
            return -1;
        }
        if (r2 == null) {
            return 1;
        }
        int i1 = this.myRoots.get((Object)r1);
        int i2 = this.myRoots.get((Object)r2);
        if (i1 == 0 && i2 == 0) {
            return 0;
        }
        if (i1 > 0 && i2 > 0) {
            return i2 - i1;
        }
        return i1 > 0 ? 1 : -1;
    }

    @Nullable
    private VirtualFile getFileRoot(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/module/impl/scopes/ModuleWithDependenciesScope", "getFileRoot"));
        }
        VirtualFile root = this.myProjectFileIndex.getClassRootForFile(file2);
        return root != null ? root : this.myProjectFileIndex.getSourceRootForFile(file2);
    }

    public Collection<VirtualFile> getRoots() {
        ArrayList result2 = ContainerUtil.newArrayList((Object[])this.myRoots.keys());
        Collections.sort(result2, new Comparator<VirtualFile>(){

            @Override
            public int compare(VirtualFile o1, VirtualFile o2) {
                return ModuleWithDependenciesScope.this.myRoots.get((Object)o1) - ModuleWithDependenciesScope.this.myRoots.get((Object)o2);
            }
        });
        return result2;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        ModuleWithDependenciesScope that = (ModuleWithDependenciesScope)((Object)o);
        return this.myOptions == that.myOptions && this.myModule.equals(that.myModule);
    }

    public int hashCode() {
        return 31 * this.myModule.hashCode() + this.myOptions;
    }

    public String toString() {
        return "Module with dependencies:" + this.myModule.getName() + " compile:" + this.hasOption(1) + " include libraries:" + this.hasOption(2) + " include other modules:" + this.hasOption(4) + " include tests:" + this.hasOption(8);
    }

    public static @interface ScopeConstant {
    }
}

