/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.localVcs.UpToDateLineNumberProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.ex.LineStatusTracker;
import com.intellij.openapi.vcs.ex.Range;
import com.intellij.openapi.vcs.impl.LineStatusTrackerManager;
import com.intellij.openapi.vcs.impl.LineStatusTrackerManagerI;
import java.util.List;

public class UpToDateLineNumberProviderImpl
implements UpToDateLineNumberProvider {
    private final Document myDocument;
    private final Project myProject;
    private final LineStatusTrackerManagerI myLineStatusTrackerManagerI;

    public UpToDateLineNumberProviderImpl(Document document, Project project) {
        this.myDocument = document;
        this.myProject = project;
        this.myLineStatusTrackerManagerI = LineStatusTrackerManager.getInstance(this.myProject);
    }

    public int getLineNumber(int currentNumber) {
        LineStatusTracker tracker = this.myLineStatusTrackerManagerI.getLineStatusTracker(this.myDocument);
        if (tracker == null) {
            return currentNumber;
        }
        return UpToDateLineNumberProviderImpl.calcLineNumber(tracker, currentNumber);
    }

    public boolean isRangeChanged(int start, int end) {
        LineStatusTracker tracker = LineStatusTrackerManager.getInstance(this.myProject).getLineStatusTracker(this.myDocument);
        if (tracker == null) {
            return false;
        }
        for (Range range : tracker.getRanges()) {
            if (UpToDateLineNumberProviderImpl.lineInRange(range, start) || UpToDateLineNumberProviderImpl.lineInRange(range, end)) {
                return true;
            }
            if (range.getLine1() <= start) continue;
            return range.getLine1() < end;
        }
        return false;
    }

    private static boolean lineInRange(Range range, int currentNumber) {
        return range.getLine1() <= currentNumber && range.getLine2() >= currentNumber;
    }

    public boolean isLineChanged(int currentNumber) {
        LineStatusTracker tracker = LineStatusTrackerManager.getInstance(this.myProject).getLineStatusTracker(this.myDocument);
        if (tracker == null) {
            return false;
        }
        for (Range range : tracker.getRanges()) {
            if (range.getLine1() > currentNumber || range.getLine2() < currentNumber) continue;
            return true;
        }
        return false;
    }

    private boolean endsWithSeparator(CharSequence string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        char latest = string.charAt(string.length() - 1);
        return '\n' == latest || '\r' == latest;
    }

    private String fixLatestLineSeparator(Document document, String content) {
        CharSequence documentSequence = document.getCharsSequence();
        if (this.endsWithSeparator(documentSequence) && !this.endsWithSeparator(content)) {
            char beforeLatest;
            int numCharsToCopy = 1;
            int docLen = documentSequence.length();
            if (docLen > 1 && ('\r' == (beforeLatest = documentSequence.charAt(docLen - 2)) || '\n' == beforeLatest)) {
                numCharsToCopy = 2;
            }
            return content + documentSequence.subSequence(docLen - numCharsToCopy, docLen);
        }
        return content;
    }

    private static int calcLineNumber(LineStatusTracker tracker, int currentNumber) {
        if (tracker == null) {
            return -1;
        }
        List<Range> ranges = tracker.getRanges();
        int result2 = currentNumber;
        for (Range range : ranges) {
            int startLine = range.getLine1();
            int endLine = range.getLine2();
            if (startLine <= currentNumber && endLine > currentNumber) {
                return -1;
            }
            if (endLine > currentNumber) {
                return result2;
            }
            int currentRangeLength = endLine - startLine;
            int vcsRangeLength = range.getVcsLine2() - range.getVcsLine1();
            result2 += vcsRangeLength - currentRangeLength;
        }
        return result2;
    }
}

