/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.artifacts;

import com.intellij.icons.AllIcons;
import com.intellij.packaging.artifacts.ArtifactTemplate;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.elements.PackagingElementFactory;
import com.intellij.packaging.elements.PackagingElementOutputKind;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.impl.artifacts.ArtifactUtil;
import com.intellij.packaging.impl.artifacts.JarFromModulesTemplate;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class JarArtifactType
extends ArtifactType {
    public JarArtifactType() {
        super("jar", "JAR");
    }

    public static JarArtifactType getInstance() {
        return (JarArtifactType)((Object)EP_NAME.findExtension(JarArtifactType.class));
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = AllIcons.Nodes.Artifact;
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/packaging/impl/artifacts/JarArtifactType", "getIcon"));
        }
        return icon;
    }

    public String getDefaultPathFor(@NotNull PackagingElementOutputKind kind) {
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/packaging/impl/artifacts/JarArtifactType", "getDefaultPathFor"));
        }
        return "/";
    }

    @NotNull
    public CompositePackagingElement<?> createRootElement(@NotNull String artifactName) {
        if (artifactName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifactName", "com/intellij/packaging/impl/artifacts/JarArtifactType", "createRootElement"));
        }
        CompositePackagingElement compositePackagingElement = PackagingElementFactory.getInstance().createArchive(ArtifactUtil.suggestArtifactFileName(artifactName) + ".jar");
        if (compositePackagingElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/packaging/impl/artifacts/JarArtifactType", "createRootElement"));
        }
        return compositePackagingElement;
    }

    @NotNull
    public List<? extends ArtifactTemplate> getNewArtifactTemplates(@NotNull PackagingElementResolvingContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/packaging/impl/artifacts/JarArtifactType", "getNewArtifactTemplates"));
        }
        List<JarFromModulesTemplate> list = Collections.singletonList(new JarFromModulesTemplate(context));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/packaging/impl/artifacts/JarArtifactType", "getNewArtifactTemplates"));
        }
        return list;
    }
}

