/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.ProjectTopics;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModuleRootAdapter;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.SmartList;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;

public class PackagePrefixIndex {
    private static final Object LOCK = new Object();
    private MultiMap<String, Module> myMap;
    private final Project myProject;

    public PackagePrefixIndex(Project project) {
        this.myProject = project;
        project.getMessageBus().connect((Disposable)project).subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void rootsChanged(ModuleRootEvent event) {
                Object object = LOCK;
                synchronized (object) {
                    PackagePrefixIndex.this.myMap = null;
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<String> getAllPackagePrefixes(@Nullable GlobalSearchScope scope) {
        MultiMap map = this.myMap;
        if (map != null) {
            return PackagePrefixIndex.getAllPackagePrefixes(scope, map);
        }
        map = new MultiMap();
        for (Module module : ModuleManager.getInstance((Project)this.myProject).getModules()) {
            for (ContentEntry entry : ModuleRootManager.getInstance((Module)module).getContentEntries()) {
                for (SourceFolder folder : entry.getSourceFolders(JavaModuleSourceRootTypes.SOURCES)) {
                    String prefix = folder.getPackagePrefix();
                    if (!StringUtil.isNotEmpty((String)prefix)) continue;
                    map.putValue((Object)prefix, (Object)module);
                }
            }
        }
        Object object = LOCK;
        synchronized (object) {
            if (this.myMap == null) {
                this.myMap = map;
            }
            return PackagePrefixIndex.getAllPackagePrefixes(scope, this.myMap);
        }
    }

    private static Collection<String> getAllPackagePrefixes(GlobalSearchScope scope, MultiMap<String, Module> map) {
        if (scope == null) {
            return map.keySet();
        }
        SmartList result2 = new SmartList();
        block0: for (String prefix : map.keySet()) {
            for (Module module : map.get((Object)prefix)) {
                if (!scope.isSearchInModuleContent(module)) continue;
                result2.add(prefix);
                continue block0;
            }
        }
        return result2;
    }
}

