/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.unscramble;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.unscramble.ThreadOperation;
import com.intellij.unscramble.ThreadState;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class ThreadDumpParser {
    private static final Pattern ourThreadStartPattern = Pattern.compile("^\\s*\"(.+)\".+(prio=\\d+ (?:os_prio=[^\\s]+ )?tid=[^\\s]+ nid=[^\\s]+|[Ii][Dd]=\\d+) ([^\\[]+)");
    private static final Pattern ourThreadStatePattern = Pattern.compile("java\\.lang\\.Thread\\.State: (.+) \\((.+)\\)");
    private static final Pattern ourThreadStatePattern2 = Pattern.compile("java\\.lang\\.Thread\\.State: (.+)");
    private static final Pattern ourWaitingForLockPattern = Pattern.compile("- waiting (on|to lock) <(.+)>");
    private static final Pattern ourParkingToWaitForLockPattern = Pattern.compile("- parking to wait for  <(.+)>");
    @NonNls
    private static final String PUMP_EVENT = "java.awt.EventDispatchThread.pumpOneEventForFilters";
    private static final Pattern ourIdleTimerThreadPattern = Pattern.compile("java.lang.Object.wait\\([^()]+\\)\\s+at java.util.TimerThread.mainLoop");
    private static final Pattern ourIdleSwingTimerThreadPattern = Pattern.compile("java.lang.Object.wait\\([^()]+\\)\\s+at javax.swing.TimerQueue.run");
    private static final String AT_JAVA_LANG_OBJECT_WAIT = "at java.lang.Object.wait(";

    private ThreadDumpParser() {
    }

    public static List<ThreadState> parse(String threadDump) {
        String line;
        ArrayList<ThreadState> result2 = new ArrayList<ThreadState>();
        StringBuilder lastThreadStack = new StringBuilder();
        ThreadState lastThreadState = null;
        boolean expectingThreadState = false;
        boolean haveNonEmptyStackTrace = false;
        Iterator<Object> iterator = StringUtil.tokenize((String)threadDump, (String)"\r\n").iterator();
        while (iterator.hasNext() && !(line = (String)iterator.next()).startsWith("============") && !line.contains("Java-level deadlock")) {
            ThreadState state = ThreadDumpParser.tryParseThreadStart(line);
            if (state != null) {
                if (lastThreadState != null) {
                    lastThreadState.setStackTrace(lastThreadStack.toString(), !haveNonEmptyStackTrace);
                }
                lastThreadState = state;
                result2.add(lastThreadState);
                lastThreadStack.setLength(0);
                haveNonEmptyStackTrace = false;
                lastThreadStack.append(line).append("\n");
                expectingThreadState = true;
                continue;
            }
            boolean parsedThreadState = false;
            if (expectingThreadState) {
                expectingThreadState = false;
                parsedThreadState = ThreadDumpParser.tryParseThreadState(line, lastThreadState);
            }
            lastThreadStack.append(line).append("\n");
            if (parsedThreadState || !line.trim().startsWith("at")) continue;
            haveNonEmptyStackTrace = true;
        }
        if (lastThreadState != null) {
            lastThreadState.setStackTrace(lastThreadStack.toString(), !haveNonEmptyStackTrace);
        }
        for (ThreadState threadState : result2) {
            ThreadDumpParser.inferThreadStateDetail(threadState);
            String lockId = ThreadDumpParser.findWaitingForLock(threadState.getStackTrace());
            ThreadState lockOwner = ThreadDumpParser.findLockOwner(result2, lockId, true);
            if (lockOwner == null) {
                lockOwner = ThreadDumpParser.findLockOwner(result2, lockId, false);
            }
            if (lockOwner == null) continue;
            if (threadState.isAwaitedBy(lockOwner)) {
                threadState.addDeadlockedThread(lockOwner);
                lockOwner.addDeadlockedThread(threadState);
            }
            lockOwner.addWaitingThread(threadState);
        }
        ThreadDumpParser.sortThreads(result2);
        return result2;
    }

    @Nullable
    private static ThreadState findLockOwner(List<ThreadState> result2, @Nullable String lockId, boolean ignoreWaiting) {
        if (lockId == null) {
            return null;
        }
        String marker = "- locked <" + lockId + ">";
        for (ThreadState lockOwner : result2) {
            String trace = lockOwner.getStackTrace();
            if (!trace.contains(marker) || ignoreWaiting && trace.contains(AT_JAVA_LANG_OBJECT_WAIT)) continue;
            return lockOwner;
        }
        return null;
    }

    public static void sortThreads(List<ThreadState> result2) {
        Collections.sort(result2, new Comparator<ThreadState>(){

            @Override
            public int compare(ThreadState o1, ThreadState o2) {
                return ThreadDumpParser.getInterestLevel(o2) - ThreadDumpParser.getInterestLevel(o1);
            }
        });
    }

    @Nullable
    private static String findWaitingForLock(String stackTrace) {
        Matcher m = ourWaitingForLockPattern.matcher(stackTrace);
        if (m.find()) {
            return m.group(2);
        }
        m = ourParkingToWaitForLockPattern.matcher(stackTrace);
        if (m.find()) {
            return m.group(1);
        }
        return null;
    }

    private static int getInterestLevel(ThreadState state) {
        if (state.isEmptyStackTrace()) {
            return -10;
        }
        if (ThreadDumpParser.isKnownJdkThread(state)) {
            return -5;
        }
        if (state.isSleeping()) {
            return -2;
        }
        if (state.getOperation() == ThreadOperation.Socket) {
            return -1;
        }
        return state.getStackTrace().split("\n").length;
    }

    public static boolean isKnownJdkThread(ThreadState state) {
        String stackTrace = state.getStackTrace();
        return stackTrace.contains("java.lang.ref.Reference$ReferenceHandler.run") || stackTrace.contains("java.lang.ref.Finalizer$FinalizerThread.run") || stackTrace.contains("sun.awt.AWTAutoShutdown.run") || stackTrace.contains("sun.java2d.Disposer.run") || stackTrace.contains("sun.awt.windows.WToolkit.eventLoop") || ourIdleTimerThreadPattern.matcher(stackTrace).find() || ourIdleSwingTimerThreadPattern.matcher(stackTrace).find();
    }

    public static void inferThreadStateDetail(ThreadState threadState) {
        String stackTrace = threadState.getStackTrace();
        if (stackTrace.contains("at java.net.PlainSocketImpl.socketAccept") || stackTrace.contains("at java.net.PlainDatagramSocketImpl.receive") || stackTrace.contains("at java.net.SocketInputStream.socketRead") || stackTrace.contains("at java.net.PlainSocketImpl.socketConnect")) {
            threadState.setOperation(ThreadOperation.Socket);
        } else if (stackTrace.contains("at java.io.FileInputStream.readBytes")) {
            threadState.setOperation(ThreadOperation.IO);
        } else if (stackTrace.contains("at java.lang.Thread.sleep")) {
            String javaThreadState = threadState.getJavaThreadState();
            if (!Thread.State.RUNNABLE.name().equals(javaThreadState)) {
                threadState.setThreadStateDetail("sleeping");
            }
        }
        if (threadState.isEDT()) {
            if (stackTrace.contains("java.awt.EventQueue.getNextEvent")) {
                threadState.setThreadStateDetail("idle");
            }
            int modality = 0;
            int pos = 0;
            while ((pos = stackTrace.indexOf(PUMP_EVENT, pos)) >= 0) {
                ++modality;
                pos += PUMP_EVENT.length();
            }
            threadState.setExtraState("modality level " + modality);
        }
    }

    @Nullable
    private static ThreadState tryParseThreadStart(String line) {
        Matcher m = ourThreadStartPattern.matcher(line);
        if (m.find()) {
            ThreadState state = new ThreadState(m.group(1), m.group(3));
            if (line.contains(" daemon ")) {
                state.setDaemon(true);
            }
            return state;
        }
        return null;
    }

    private static boolean tryParseThreadState(String line, ThreadState threadState) {
        Matcher m = ourThreadStatePattern.matcher(line);
        if (m.find()) {
            threadState.setJavaThreadState(m.group(1));
            threadState.setThreadStateDetail(m.group(2).trim());
            return true;
        }
        m = ourThreadStatePattern2.matcher(line);
        if (m.find()) {
            threadState.setJavaThreadState(m.group(1));
            return true;
        }
        return false;
    }
}

