/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.printer.idea;

import com.intellij.openapi.util.Pair;
import com.intellij.ui.JBColor;
import com.intellij.vcs.log.graph.EdgePrintElement;
import com.intellij.vcs.log.graph.NodePrintElement;
import com.intellij.vcs.log.graph.PrintElement;
import com.intellij.vcs.log.printer.idea.ColorGenerator;
import com.intellij.vcs.log.printer.idea.GraphCellPainter;
import com.intellij.vcs.log.printer.idea.PositionUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimpleGraphCellPainter
implements GraphCellPainter {
    private static final Color MARK_COLOR = JBColor.BLACK;
    private static final int ROW_HEIGHT = 24;
    private static final double ARROW_ANGLE_COS2 = 0.7;
    private static final double ARROW_LENGTH = 0.3;
    private final Stroke usual;
    private final Stroke hide;
    private final Stroke selectUsual;
    private final Stroke selectHide;
    private Graphics2D g2;
    @NotNull
    private final ColorGenerator myColorGenerator;

    public SimpleGraphCellPainter(@NotNull ColorGenerator colorGenerator) {
        if (colorGenerator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "colorGenerator", "com/intellij/vcs/log/printer/idea/SimpleGraphCellPainter", "<init>"));
        }
        this.usual = new BasicStroke(1.5f, 1, 2);
        this.hide = new BasicStroke(1.5f, 1, 2, 0.0f, new float[]{7.0f}, 0.0f);
        this.selectUsual = new BasicStroke(2.5f, 1, 2);
        this.selectHide = new BasicStroke(2.5f, 1, 2, 0.0f, new float[]{7.0f}, 0.0f);
        this.myColorGenerator = colorGenerator;
    }

    protected int getRowHeight() {
        return 24;
    }

    private void paintUpLine(int from, int to, Color color, boolean hasArrow) {
        if (from == to) {
            int x = 15 * from + 7;
            int y1 = this.getRowHeight() / 2 - 1;
            int y2 = 0;
            this.paintLine(color, hasArrow, x, y1, x, y2, x, y2);
        } else {
            int x1 = 15 * from + 7;
            int y1 = this.getRowHeight() / 2;
            int x2 = 15 * to + 7;
            int y2 = -this.getRowHeight() / 2;
            this.paintLine(color, hasArrow, x1, y1, x2, y2, (x1 + x2) / 2, (y1 + y2) / 2);
        }
    }

    private void paintDownLine(int from, int to, Color color, boolean hasArrow) {
        if (from == to) {
            int y2 = this.getRowHeight() - 1;
            int y1 = this.getRowHeight() / 2;
            int x = 15 * from + 7;
            this.paintLine(color, hasArrow, x, y1, x, y2, x, y2);
        } else {
            int x1 = 15 * from + 7;
            int y1 = this.getRowHeight() / 2;
            int x2 = 15 * to + 7;
            int y2 = this.getRowHeight() + this.getRowHeight() / 2;
            this.paintLine(color, hasArrow, x1, y1, x2, y2, (x1 + x2) / 2, (y1 + y2) / 2);
        }
    }

    private void paintLine(Color color, boolean hasArrow, int x1, int y1, int x2, int y2, int startArrowX, int startArrowY) {
        this.g2.setColor(color);
        this.g2.drawLine(x1, y1, x2, y2);
        if (hasArrow) {
            Pair<Integer, Integer> rotate1 = SimpleGraphCellPainter.rotate(x1, y1, startArrowX, startArrowY, Math.sqrt(0.7), Math.sqrt(0.30000000000000004), 0.3 * (double)this.getRowHeight());
            Pair<Integer, Integer> rotate2 = SimpleGraphCellPainter.rotate(x1, y1, startArrowX, startArrowY, Math.sqrt(0.7), -Math.sqrt(0.30000000000000004), 0.3 * (double)this.getRowHeight());
            this.g2.drawLine(startArrowX, startArrowY, (Integer)rotate1.first, (Integer)rotate1.second);
            this.g2.drawLine(startArrowX, startArrowY, (Integer)rotate2.first, (Integer)rotate2.second);
        }
    }

    @NotNull
    private static Pair<Integer, Integer> rotate(double x, double y, double centerX, double centerY, double cos, double sin, double arrowLength) {
        double translateX = x - centerX;
        double translateY = y - centerY;
        double d = Math.sqrt(translateX * translateX + translateY * translateY);
        double scaleX = arrowLength * translateX / d;
        double scaleY = arrowLength * translateY / d;
        double rotateX = scaleX * cos - scaleY * sin;
        double rotateY = scaleX * sin + scaleY * cos;
        Pair pair = Pair.create((Object)((int)Math.round(rotateX + centerX)), (Object)((int)Math.round(rotateY + centerY)));
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/printer/idea/SimpleGraphCellPainter", "rotate"));
        }
        return pair;
    }

    private void paintCircle(int position, Color color, boolean select) {
        int x0 = 15 * position + 7;
        int y0 = this.getRowHeight() / 2;
        int r = 4;
        if (select) {
            r = 5;
        }
        Ellipse2D.Double circle = new Ellipse2D.Double((double)(x0 - r) + 0.5, (double)(y0 - r) + 0.5, 2 * r, 2 * r);
        this.g2.setColor(color);
        this.g2.fill(circle);
    }

    private void setStroke(boolean usual, boolean select) {
        if (usual) {
            if (select) {
                this.g2.setStroke(this.selectUsual);
            } else {
                this.g2.setStroke(this.usual);
            }
        } else if (select) {
            this.g2.setStroke(this.selectHide);
        } else {
            this.g2.setStroke(this.hide);
        }
    }

    private void drawLogic(boolean isSelected, boolean isUsual, Color usualColor, LitePrinter printer) {
        if (isSelected) {
            this.setStroke(isUsual, true);
            printer.print(MARK_COLOR);
            this.setStroke(isUsual, false);
            printer.print(usualColor);
        } else {
            this.setStroke(isUsual, false);
            printer.print(usualColor);
        }
    }

    @NotNull
    private Color getColor(@NotNull PrintElement printElement) {
        if (printElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "printElement", "com/intellij/vcs/log/printer/idea/SimpleGraphCellPainter", "getColor"));
        }
        Color color = this.myColorGenerator.getColor(printElement.getColorId());
        if (color == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/printer/idea/SimpleGraphCellPainter", "getColor"));
        }
        return color;
    }

    private static boolean isUsual(PrintElement printElement) {
        if (!(printElement instanceof EdgePrintElement)) {
            return true;
        }
        EdgePrintElement.LineStyle lineStyle = ((EdgePrintElement)printElement).getLineStyle();
        return lineStyle == EdgePrintElement.LineStyle.SOLID;
    }

    @Override
    public void draw(@NotNull Graphics2D g2, @NotNull Collection<? extends PrintElement> printElements) {
        if (g2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g2", "com/intellij/vcs/log/printer/idea/SimpleGraphCellPainter", "draw"));
        }
        if (printElements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "printElements", "com/intellij/vcs/log/printer/idea/SimpleGraphCellPainter", "draw"));
        }
        this.g2 = g2;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        for (final PrintElement printElement : printElements) {
            LitePrinter printer = null;
            if (printElement instanceof EdgePrintElement) {
                printer = new LitePrinter(){

                    @Override
                    public void print(Color color) {
                        EdgePrintElement edgePrintElement = (EdgePrintElement)printElement;
                        int from = edgePrintElement.getPositionInCurrentRow();
                        int to = edgePrintElement.getPositionInOtherRow();
                        if (edgePrintElement.getType() == EdgePrintElement.Type.DOWN) {
                            SimpleGraphCellPainter.this.paintDownLine(from, to, color, edgePrintElement.hasArrow());
                        } else {
                            SimpleGraphCellPainter.this.paintUpLine(from, to, color, edgePrintElement.hasArrow());
                        }
                    }
                };
            }
            if (printElement instanceof NodePrintElement) {
                int position = printElement.getPositionInCurrentRow();
                if (printElement.isSelected()) {
                    this.paintCircle(position, MARK_COLOR, true);
                    this.paintCircle(position, this.getColor(printElement), false);
                } else {
                    this.paintCircle(position, this.getColor(printElement), false);
                }
            }
            if (printer == null) continue;
            this.drawLogic(printElement.isSelected(), SimpleGraphCellPainter.isUsual(printElement), this.getColor(printElement), printer);
        }
    }

    @Override
    @Nullable
    public PrintElement mouseOver(@NotNull Collection<? extends PrintElement> printElements, int x, int y) {
        if (printElements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "printElements", "com/intellij/vcs/log/printer/idea/SimpleGraphCellPainter", "mouseOver"));
        }
        for (PrintElement printElement : printElements) {
            if (!(printElement instanceof NodePrintElement) || !PositionUtil.overNode(printElement.getPositionInCurrentRow(), x, y, this.getRowHeight())) continue;
            return printElement;
        }
        for (PrintElement printElement : printElements) {
            EdgePrintElement edgePrintElement;
            if (!(printElement instanceof EdgePrintElement) || !((edgePrintElement = (EdgePrintElement)printElement).getType() == EdgePrintElement.Type.DOWN ? PositionUtil.overDownEdge(edgePrintElement.getPositionInCurrentRow(), edgePrintElement.getPositionInOtherRow(), x, y, this.getRowHeight()) : PositionUtil.overUpEdge(edgePrintElement.getPositionInOtherRow(), edgePrintElement.getPositionInCurrentRow(), x, y, this.getRowHeight()))) continue;
            return printElement;
        }
        return null;
    }

    private static interface LitePrinter {
        public void print(Color var1);
    }
}

