/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webcore.packaging;

import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.webcore.packaging.PackageManagementService;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PackagingErrorDialog
extends DialogWrapper {
    private JPanel myMainPanel;
    private JTextArea myCommandOutput;
    private JPanel myCommandOutputPanel;
    private JPanel myCommandPanel;
    private JTextPane myCommand;
    private JPanel mySolutionPanel;
    private JTextPane mySolution;
    private JPanel myDetailsPanel;
    private JTextArea myDetails;
    private JPanel myMessagePanel;
    private JBLabel myDetailsLabel;
    private JTextPane myMessage;
    private JBLabel myMessageIcon;

    public PackagingErrorDialog(@NotNull String title, @NotNull PackageManagementService.ErrorDescription errorDescription) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/webcore/packaging/PackagingErrorDialog", "<init>"));
        }
        if (errorDescription == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorDescription", "com/intellij/webcore/packaging/PackagingErrorDialog", "<init>"));
        }
        super(false);
        this.$$$setupUI$$$();
        this.init();
        this.setResizable(false);
        this.setTitle(title);
        String command = errorDescription.getCommand();
        String output = errorDescription.getOutput();
        String message = errorDescription.getMessage();
        String solution = errorDescription.getSolution();
        boolean extendedInfo = command != null || output != null || solution != null;
        this.myDetailsPanel.setVisible(!extendedInfo);
        this.myMessagePanel.setVisible(extendedInfo);
        this.myCommandPanel.setVisible(command != null);
        this.myCommandOutputPanel.setVisible(output != null);
        this.mySolutionPanel.setVisible(solution != null);
        if (extendedInfo) {
            this.myMessage.setText(message);
            this.myMessageIcon.setIcon(Messages.getErrorIcon());
        } else {
            this.myDetails.setText(message);
            this.myDetailsLabel.setIcon(Messages.getErrorIcon());
        }
        if (command != null) {
            this.myCommand.setText(command);
        }
        if (output != null) {
            this.myCommandOutput.setText(output);
        }
        if (solution != null) {
            this.mySolution.setText(solution);
        }
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextArea jTextArea;
        JBLabel jBLabel;
        JPanel jPanel;
        JTextPane jTextPane;
        JPanel jPanel2;
        JBLabel jBLabel2;
        JTextPane jTextPane2;
        JPanel jPanel3;
        JTextPane jTextPane3;
        JPanel jPanel4;
        JTextArea jTextArea2;
        JPanel jPanel5;
        JPanel jPanel6;
        this.myMainPanel = jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(6, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel6.add((Component)spacer, new GridConstraints(5, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myCommandOutputPanel = jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.add((Component)jPanel5, new GridConstraints(4, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JBLabel jBLabel3 = new JBLabel();
        jBLabel3.setText("Command output:");
        jPanel5.add((Component)jBLabel3, new GridConstraints(0, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel5.add((Component)jBScrollPane, new GridConstraints(1, 0, 1, 1, 9, 0, 3, 3, null, new Dimension(700, 300), new Dimension(700, 300), 2));
        this.myCommandOutput = jTextArea2 = new JTextArea();
        jTextArea2.setText("No output");
        jTextArea2.setEditable(false);
        jBScrollPane.setViewportView(jTextArea2);
        this.myCommandPanel = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.add((Component)jPanel4, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JBLabel jBLabel4 = new JBLabel();
        jBLabel4.setText("Executed command:");
        jPanel4.add((Component)jBLabel4, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myCommand = jTextPane3 = new JTextPane();
        jTextPane3.setText("None");
        ((Component)jTextPane3).setFont(UIManager.getFont("TextArea.font"));
        jTextPane3.setEditable(false);
        jPanel4.add((Component)jTextPane3, new GridConstraints(1, 0, 1, 1, 8, 2, 6, 6, null, new Dimension(700, 20), new Dimension(700, 100), 2));
        this.myMessagePanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.add((Component)jPanel3, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JBLabel jBLabel5 = new JBLabel();
        jBLabel5.setText("Error occurred:");
        jPanel3.add((Component)jBLabel5, new GridConstraints(0, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        this.myMessage = jTextPane2 = new JTextPane();
        jTextPane2.setText("Unknown reason");
        ((Component)jTextPane2).setForeground(new Color(-65536));
        ((Component)jTextPane2).setFont(UIManager.getFont("Label.font"));
        jTextPane2.setEditable(false);
        jPanel3.add((Component)jTextPane2, new GridConstraints(1, 1, 1, 1, 0, 1, 6, 6, null, new Dimension(150, 20), null));
        this.myMessageIcon = jBLabel2 = new JBLabel();
        jPanel3.add((Component)jBLabel2, new GridConstraints(1, 0, 1, 1, 0, 0, 0, 0, null, null, null, 2));
        this.mySolutionPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.add((Component)jPanel2, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JBLabel jBLabel6 = new JBLabel();
        jBLabel6.setText("Proposed solution:");
        jPanel2.add((Component)jBLabel6, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.mySolution = jTextPane = new JTextPane();
        jTextPane.setText("None");
        ((Component)jTextPane).setFont(UIManager.getFont("Label.font"));
        jTextPane.setEditable(false);
        jPanel2.add((Component)jTextPane, new GridConstraints(1, 0, 1, 1, 0, 3, 6, 6, null, new Dimension(150, 20), null, 2));
        this.myDetailsPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.add((Component)jPanel, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myDetailsLabel = jBLabel = new JBLabel();
        jBLabel.setText("Details:");
        jPanel.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JBScrollPane jBScrollPane2 = new JBScrollPane();
        jPanel.add((Component)jBScrollPane2, new GridConstraints(1, 0, 1, 1, 9, 0, 3, 3, null, new Dimension(700, 500), new Dimension(700, 500), 2));
        this.myDetails = jTextArea = new JTextArea();
        jTextArea.setText("No information");
        jTextArea.setEditable(false);
        jBScrollPane2.setViewportView(jTextArea);
        jBLabel3.setLabelFor((Component)jBScrollPane);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }
}

