/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.TypeConversionUtil;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeUtils {
    private static final Map<PsiType, Integer> typePrecisions = new HashMap<PsiType, Integer>(7);

    private TypeUtils() {
    }

    public static boolean typeEquals(@NonNls @NotNull String typeName, @Nullable PsiType targetType) {
        if (typeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeName", "com/siyeh/ig/psiutils/TypeUtils", "typeEquals"));
        }
        return targetType != null && targetType.equalsToText(typeName);
    }

    public static PsiClassType getType(@NotNull String fqName, @NotNull PsiElement context) {
        if (fqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "com/siyeh/ig/psiutils/TypeUtils", "getType"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/siyeh/ig/psiutils/TypeUtils", "getType"));
        }
        Project project = context.getProject();
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
        GlobalSearchScope scope = context.getResolveScope();
        return factory.createTypeByFQClassName(fqName, scope);
    }

    public static PsiClassType getType(@NotNull PsiClass aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/siyeh/ig/psiutils/TypeUtils", "getType"));
        }
        return JavaPsiFacade.getInstance((Project)aClass.getProject()).getElementFactory().createType(aClass);
    }

    public static PsiClassType getObjectType(@NotNull PsiElement context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/siyeh/ig/psiutils/TypeUtils", "getObjectType"));
        }
        return TypeUtils.getType("java.lang.Object", context);
    }

    public static PsiClassType getStringType(@NotNull PsiElement context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/siyeh/ig/psiutils/TypeUtils", "getStringType"));
        }
        return TypeUtils.getType("java.lang.String", context);
    }

    public static boolean isNarrowingConversion(@NotNull PsiType operandType, @NotNull PsiType castType) {
        if (operandType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operandType", "com/siyeh/ig/psiutils/TypeUtils", "isNarrowingConversion"));
        }
        if (castType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "castType", "com/siyeh/ig/psiutils/TypeUtils", "isNarrowingConversion"));
        }
        Integer operandPrecision = typePrecisions.get(operandType);
        Integer castPrecision = typePrecisions.get(castType);
        return operandPrecision != null && castPrecision != null && operandPrecision > castPrecision;
    }

    public static boolean isJavaLangObject(@Nullable PsiType targetType) {
        return TypeUtils.typeEquals("java.lang.Object", targetType);
    }

    public static boolean isJavaLangString(@Nullable PsiType targetType) {
        return TypeUtils.typeEquals("java.lang.String", targetType);
    }

    public static boolean isExpressionTypeAssignableWith(@NotNull PsiExpression expression, @NotNull Iterable<String> rhsTypeTexts) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/psiutils/TypeUtils", "isExpressionTypeAssignableWith"));
        }
        if (rhsTypeTexts == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rhsTypeTexts", "com/siyeh/ig/psiutils/TypeUtils", "isExpressionTypeAssignableWith"));
        }
        PsiType type = expression.getType();
        if (type == null) {
            return false;
        }
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)expression.getProject()).getElementFactory();
        for (String rhsTypeText : rhsTypeTexts) {
            PsiClassType rhsType = factory.createTypeByFQClassName(rhsTypeText, expression.getResolveScope());
            if (!type.isAssignableFrom((PsiType)rhsType)) continue;
            return true;
        }
        return false;
    }

    public static boolean expressionHasTypeOrSubtype(@Nullable PsiExpression expression, @NonNls @NotNull String typeName) {
        if (typeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeName", "com/siyeh/ig/psiutils/TypeUtils", "expressionHasTypeOrSubtype"));
        }
        return TypeUtils.expressionHasTypeOrSubtype(expression, new String[]{typeName}) != null;
    }

    public static String expressionHasTypeOrSubtype(@Nullable PsiExpression expression, String ... typeNames) {
        PsiType type;
        if (typeNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeNames", "com/siyeh/ig/psiutils/TypeUtils", "expressionHasTypeOrSubtype"));
        }
        if (expression == null) {
            return null;
        }
        PsiType psiType = type = expression instanceof PsiFunctionalExpression ? ((PsiFunctionalExpression)expression).getFunctionalInterfaceType() : expression.getType();
        if (type == null) {
            return null;
        }
        if (!(type instanceof PsiClassType)) {
            return null;
        }
        PsiClassType classType = (PsiClassType)type;
        PsiClass aClass = classType.resolve();
        if (aClass == null) {
            return null;
        }
        for (String typeName : typeNames) {
            if (!InheritanceUtil.isInheritor((PsiClass)aClass, (String)typeName)) continue;
            return typeName;
        }
        return null;
    }

    public static boolean expressionHasTypeOrSubtype(@Nullable PsiExpression expression, @NonNls @NotNull Iterable<String> typeNames) {
        if (typeNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeNames", "com/siyeh/ig/psiutils/TypeUtils", "expressionHasTypeOrSubtype"));
        }
        if (expression == null) {
            return false;
        }
        PsiType type = expression.getType();
        if (type == null) {
            return false;
        }
        if (!(type instanceof PsiClassType)) {
            return false;
        }
        PsiClassType classType = (PsiClassType)type;
        PsiClass aClass = classType.resolve();
        if (aClass == null) {
            return false;
        }
        for (String typeName : typeNames) {
            if (!InheritanceUtil.isInheritor((PsiClass)aClass, (String)typeName)) continue;
            return true;
        }
        return false;
    }

    public static boolean variableHasTypeOrSubtype(@Nullable PsiVariable variable, String ... typeNames) {
        if (typeNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeNames", "com/siyeh/ig/psiutils/TypeUtils", "variableHasTypeOrSubtype"));
        }
        if (variable == null) {
            return false;
        }
        PsiType type = variable.getType();
        if (!(type instanceof PsiClassType)) {
            return false;
        }
        PsiClassType classType = (PsiClassType)type;
        PsiClass aClass = classType.resolve();
        if (aClass == null) {
            return false;
        }
        for (String typeName : typeNames) {
            if (!InheritanceUtil.isInheritor((PsiClass)aClass, (String)typeName)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasFloatingPointType(@Nullable PsiExpression expression) {
        if (expression == null) {
            return false;
        }
        PsiType type = expression.getType();
        return type != null && (PsiType.FLOAT.equals((Object)type) || PsiType.DOUBLE.equals((Object)type));
    }

    public static boolean areConvertible(PsiType type1, PsiType type2) {
        if (TypeConversionUtil.areTypesConvertible((PsiType)type1, (PsiType)type2)) {
            return true;
        }
        PsiType comparedTypeErasure = TypeConversionUtil.erasure((PsiType)type1);
        PsiType comparisonTypeErasure = TypeConversionUtil.erasure((PsiType)type2);
        if (comparedTypeErasure == null || comparisonTypeErasure == null || TypeConversionUtil.areTypesConvertible((PsiType)comparedTypeErasure, (PsiType)comparisonTypeErasure)) {
            if (type1 instanceof PsiClassType && type2 instanceof PsiClassType) {
                PsiType[] parameters2;
                PsiClassType classType1 = (PsiClassType)type1;
                PsiClassType classType2 = (PsiClassType)type2;
                PsiType[] parameters1 = classType1.getParameters();
                if (parameters1.length != (parameters2 = classType2.getParameters()).length) {
                    return ((PsiClassType)type1).isRaw() || ((PsiClassType)type2).isRaw();
                }
                for (int i = 0; i < parameters1.length; ++i) {
                    if (TypeUtils.areConvertible(parameters1[i], parameters2[i])) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public static boolean isTypeParameter(PsiType type) {
        if (!(type instanceof PsiClassType)) {
            return false;
        }
        PsiClassType classType = (PsiClassType)type;
        PsiClass aClass = classType.resolve();
        return aClass != null && aClass instanceof PsiTypeParameter;
    }

    public static PsiType unaryNumericPromotion(PsiType type) {
        if (type == null) {
            return null;
        }
        if (type.equalsToText("java.lang.Byte") || type.equalsToText("java.lang.Short") || type.equalsToText("java.lang.Character") || type.equalsToText("java.lang.Integer") || type.equals(PsiType.BYTE) || type.equals(PsiType.SHORT) || type.equals(PsiType.CHAR)) {
            return PsiType.INT;
        }
        if (type.equalsToText("java.lang.Long")) {
            return PsiType.LONG;
        }
        if (type.equalsToText("java.lang.Float")) {
            return PsiType.FLOAT;
        }
        if (type.equalsToText("java.lang.Double")) {
            return PsiType.DOUBLE;
        }
        return type;
    }

    static {
        typePrecisions.put((PsiType)PsiType.BYTE, 1);
        typePrecisions.put((PsiType)PsiType.CHAR, 2);
        typePrecisions.put((PsiType)PsiType.SHORT, 2);
        typePrecisions.put((PsiType)PsiType.INT, 3);
        typePrecisions.put((PsiType)PsiType.LONG, 4);
        typePrecisions.put((PsiType)PsiType.FLOAT, 5);
        typePrecisions.put((PsiType)PsiType.DOUBLE, 6);
    }
}

