/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.asJava;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.impl.PsiModificationTrackerImpl;
import com.intellij.psi.impl.PsiTreeChangeEventImpl;
import com.intellij.psi.impl.PsiTreeChangePreprocessor;
import com.intellij.psi.util.PsiModificationTracker;
import java.util.Arrays;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"-\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\tA!A\u0003\u0002\u0019\u0005)\u0001!B\u0001\t\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005!!!B\u0001\r\u0003\u0015\u0001A\u0002\u0001\t\t3\u0005A\n!(\u0001\tC\u001bI1\u0001C\u0001\u000e\u0003a\r\u0011kA\u0001\t\u0005\u0015\u001aB!\u0001E\u0004\u001b\u0005AB!\u0007\u0003\t\n5\u0011A\u0012\u0001\r\u00063\u0011AY!\u0004\u0002\r\u0002a)\u0011\u0004\u0002\u0005\u0007\u001b\ta\t\u0001G\u0003&\u0011\u0011Y\u0001RB\u0007\u00021\u0011I2\u0001C\u0004\u000e\u0003a=\u0011f\u0002\u0003B\u0011!\u0015Q\"\u0001\r\u0004#\u000e\tQ\u0001\u0001"}, strings={"Lorg/jetbrains/kotlin/asJava/KotlinCodeBlockModificationListener;", "Lcom/intellij/psi/impl/PsiTreeChangePreprocessor;", "modificationTracker", "Lcom/intellij/psi/util/PsiModificationTracker;", "(Lcom/intellij/psi/util/PsiModificationTracker;)V", "myModificationTracker", "Lcom/intellij/psi/impl/PsiModificationTrackerImpl;", "processChange", "", "parent", "Lcom/intellij/psi/PsiElement;", "child1", "child2", "treeChanged", "event", "Lcom/intellij/psi/impl/PsiTreeChangeEventImpl;", "Companion"}, moduleName="kotlin-compiler")
public final class KotlinCodeBlockModificationListener
implements PsiTreeChangePreprocessor {
    private static final Logger LOG;
    private static final Class<? extends KtDeclaration>[] BLOCK_DECLARATION_TYPES;
    private final PsiModificationTrackerImpl myModificationTracker;
    public static final Companion Companion;

    static {
        Companion = org.jetbrains.kotlin.asJava.KotlinCodeBlockModificationListener$Companion.INSTANCE;
        LOG = Logger.getInstance("#org.jetbrains.kotlin.asJava.KotlinCodeBlockModificationListener");
        BLOCK_DECLARATION_TYPES = new Class[]{KtProperty.class, KtNamedFunction.class};
    }

    @Override
    public void treeChanged(@NotNull PsiTreeChangeEventImpl event) {
        Intrinsics.checkParameterIsNotNull(event, "event");
        if (!(event.getFile() instanceof KtFile)) {
            return;
        }
        PsiTreeChangeEventImpl.PsiEventType psiEventType = event.getCode();
        if (!(Intrinsics.areEqual((Object)psiEventType, (Object)PsiTreeChangeEventImpl.PsiEventType.BEFORE_CHILDREN_CHANGE) || Intrinsics.areEqual((Object)psiEventType, (Object)PsiTreeChangeEventImpl.PsiEventType.BEFORE_PROPERTY_CHANGE) || Intrinsics.areEqual((Object)psiEventType, (Object)PsiTreeChangeEventImpl.PsiEventType.BEFORE_CHILD_MOVEMENT) || Intrinsics.areEqual((Object)psiEventType, (Object)PsiTreeChangeEventImpl.PsiEventType.BEFORE_CHILD_REPLACEMENT) || Intrinsics.areEqual((Object)psiEventType, (Object)PsiTreeChangeEventImpl.PsiEventType.BEFORE_CHILD_ADDITION) || Intrinsics.areEqual((Object)psiEventType, (Object)PsiTreeChangeEventImpl.PsiEventType.BEFORE_CHILD_REMOVAL))) {
            if (Intrinsics.areEqual((Object)psiEventType, (Object)PsiTreeChangeEventImpl.PsiEventType.CHILD_ADDED) || Intrinsics.areEqual((Object)psiEventType, (Object)PsiTreeChangeEventImpl.PsiEventType.CHILD_REMOVED) || Intrinsics.areEqual((Object)psiEventType, (Object)PsiTreeChangeEventImpl.PsiEventType.CHILD_REPLACED)) {
                this.processChange(event.getParent(), event.getOldChild(), event.getChild());
            } else if (Intrinsics.areEqual((Object)psiEventType, (Object)PsiTreeChangeEventImpl.PsiEventType.CHILDREN_CHANGED)) {
                if (!event.isGenericChange()) {
                    this.processChange(event.getParent(), event.getParent(), null);
                }
            } else if (Intrinsics.areEqual((Object)psiEventType, (Object)PsiTreeChangeEventImpl.PsiEventType.CHILD_MOVED) || Intrinsics.areEqual((Object)psiEventType, (Object)PsiTreeChangeEventImpl.PsiEventType.PROPERTY_CHANGED)) {
                this.myModificationTracker.incCounter();
            } else {
                KotlinCodeBlockModificationListener.Companion.getLOG().error("Unknown code:" + (Object)((Object)event.getCode()));
            }
        }
    }

    private final void processChange(PsiElement parent2, PsiElement child1, PsiElement child2) {
        try {
            if (!Companion.isInsideCodeBlock(parent2)) {
                if (parent2 != null && parent2.getContainingFile() instanceof KtFile) {
                    this.myModificationTracker.incCounter();
                } else {
                    this.myModificationTracker.incOutOfCodeBlockModificationCounter();
                }
                return;
            }
            if (KotlinCodeBlockModificationListener.Companion.containsClassesInside(child1) || Intrinsics.areEqual(child2, child1) ^ true && KotlinCodeBlockModificationListener.Companion.containsClassesInside(child2)) {
                this.myModificationTracker.incCounter();
            }
        }
        catch (PsiInvalidElementAccessException e) {
            this.myModificationTracker.incCounter();
        }
    }

    public KotlinCodeBlockModificationListener(@NotNull PsiModificationTracker modificationTracker2) {
        Intrinsics.checkParameterIsNotNull(modificationTracker2, "modificationTracker");
        PsiModificationTracker psiModificationTracker = modificationTracker2;
        if (psiModificationTracker == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.psi.impl.PsiModificationTrackerImpl");
        }
        this.myModificationTracker = (PsiModificationTrackerImpl)psiModificationTracker;
    }

    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"3\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0011\u0001B\u0001\u0006\u0003!EQ!\u0001\u0007\u0002\u000b\u0005a\u0011!B\u0001\u0005\u0005\u0015\tA\"A\u0003\u0002\t\t)\u0011\u0001c\u0003\u0006\u0001\u0015\tA\"A\u0003\u0002\t\u0007!19\u0001\u0007\u00013\u0005A\n!i\u0002\u0005\u0003E\u001b\u0011\u0001C\u0001&\u0013\u0011\t\u0001rB\u0007\u00021!IB\u0001#\u0005\u000e\u00051\u0005\u0001$C\u0013\b\u0011'i\u0011\u0001\u0007\u0005\u001a\u0007!QQ\"\u0001\r\u0004K!A)\"D\u0001\u0019\u0011e!\u0001\u0012C\u0007\u0003\u0019\u0003A\u0012\"K\n\u0005\u0003\"A\u0019!\u0004\u0005\n\r%)\u0011b\u0001C\u0001\u0013\u0005A2\u0001'\u0002\u0019\u0005E\u001ba!\u0002\u0002\t\n1\u0005QB\u0001C\u0004\u0011\u0011Is\u0002B!\t\u0011\u0015iQ\u0001\u0005\u0004\u0016\u00051\u0005\u00014\u0002M\u0006#\u000e)Q!\u0001G\u0001\u001b\t!i\u0001C\u0004"}, strings={"Lorg/jetbrains/kotlin/asJava/KotlinCodeBlockModificationListener$Companion;", "", "()V", "BLOCK_DECLARATION_TYPES", "", "Ljava/lang/Class;", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "getBLOCK_DECLARATION_TYPES", "()[Ljava/lang/Class;", "[Ljava/lang/Class;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "kotlin.jvm.PlatformType", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "containsClassesInside", "", "element", "Lcom/intellij/psi/PsiElement;", "isBlockDeclaration", "declaration", "isInsideCodeBlock"}, moduleName="kotlin-compiler")
    public static final class Companion {
        public static final Companion INSTANCE;

        private final Logger getLOG() {
            return LOG;
        }

        private final boolean containsClassesInside(PsiElement element) {
            if (element == null) {
                return false;
            }
            if (element instanceof PsiClass) {
                return true;
            }
            for (PsiElement child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (!this.containsClassesInside(child)) continue;
                return true;
            }
            return false;
        }

        public final boolean isInsideCodeBlock(@Nullable PsiElement element) {
            PsiElement blockDeclaration;
            if (element instanceof PsiFileSystemItem) {
                return false;
            }
            if (element == null || element.getParent() == null) {
                return true;
            }
            Class<? extends KtDeclaration>[] classArray = this.getBLOCK_DECLARATION_TYPES();
            PsiElement psiElement2 = KtPsiUtil.getTopmostParentOfTypes(element, Arrays.copyOf(classArray, classArray.length));
            if (psiElement2 == null) {
                return false;
            }
            PsiElement psiElement3 = blockDeclaration = psiElement2;
            if (psiElement3 instanceof KtNamedFunction) {
                if (((KtNamedFunction)blockDeclaration).hasBlockBody()) {
                    return PsiUtilsKt.isAncestor$default(((KtNamedFunction)blockDeclaration).getBodyExpression(), element, false, 2);
                }
                if (((KtNamedFunction)blockDeclaration).hasDeclaredReturnType()) {
                    return PsiUtilsKt.isAncestor$default(((KtNamedFunction)blockDeclaration).getInitializer(), element, false, 2);
                }
            } else if (psiElement3 instanceof KtProperty) {
                for (KtPropertyAccessor accessor : ((KtProperty)blockDeclaration).getAccessors()) {
                    if (!PsiUtilsKt.isAncestor$default(accessor.getInitializer(), element, false, 2) && !PsiUtilsKt.isAncestor$default(accessor.getBodyExpression(), element, false, 2)) continue;
                    return true;
                }
            } else {
                throw (Throwable)new IllegalStateException();
            }
            return false;
        }

        public final boolean isBlockDeclaration(@NotNull KtDeclaration declaration) {
            boolean bl;
            block1: {
                Intrinsics.checkParameterIsNotNull(declaration, "declaration");
                Object[] $receiver = this.getBLOCK_DECLARATION_TYPES();
                for (int i = 0; i < $receiver.length; ++i) {
                    Object element = $receiver[i];
                    Class it = (Class)element;
                    if (!it.isInstance(declaration)) continue;
                    bl = true;
                    break block1;
                }
                bl = false;
            }
            return bl;
        }

        private final Class<? extends KtDeclaration>[] getBLOCK_DECLARATION_TYPES() {
            return BLOCK_DECLARATION_TYPES;
        }

        static {
            new Companion();
        }

        private Companion() {
            INSTANCE = this;
        }
    }
}

