/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.xslt.impl;

import com.intellij.ide.FileIconPatcher;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import gnu.trove.TIntObjectHashMap;
import javax.swing.Icon;
import org.intellij.lang.xpath.xslt.XsltSupport;

public class XsltIconProvider
implements FileIconPatcher {
    private static final Key<TIntObjectHashMap<Icon>> ICON_KEY = Key.create((String)"XSLT_ICON");

    public Icon patchIcon(Icon baseIcon, VirtualFile file, int flags, Project project) {
        Icon icon;
        if (project == null) {
            return baseIcon;
        }
        TIntObjectHashMap icons = (TIntObjectHashMap)file.getUserData(ICON_KEY);
        if (icons != null && (icon = (Icon)icons.get(flags)) != null) {
            return icon;
        }
        PsiFile element = PsiManager.getInstance((Project)project).findFile(file);
        if (element != null && XsltSupport.isXsltFile(element)) {
            return XsltIconProvider.cacheIcon(file, flags, (TIntObjectHashMap<Icon>)icons, XsltSupport.createXsltIcon(baseIcon));
        }
        return baseIcon;
    }

    private static Icon cacheIcon(VirtualFile file, int flags, TIntObjectHashMap<Icon> icons, Icon icon) {
        if (icons == null) {
            icons = new TIntObjectHashMap(3);
            file.putUserData(ICON_KEY, (Object)icons);
        }
        icons.put(flags, (Object)icon);
        return icon;
    }
}

