/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.settingsRepository.git;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.vcs.merge.MergeData;
import com.intellij.openapi.vcs.merge.MergeProvider2;
import com.intellij.openapi.vcs.merge.MergeSession;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.ColumnInfo;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.util.List;
import java.util.Map;
import kotlin.MapsKt;
import kotlin.TypeCastException;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.eclipse.jgit.lib.Repository;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jgit.dirCache.DirCacheEditorKt;
import org.jetbrains.settingsRepository.RepositoryVirtualFile;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"[\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011!\u0002\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0011I)\u0011\u0001C\u0004\u0006\u0001\u0015\tA\"A\u0003\u0002\u0011\u0011)\u0011\u0001C\u0005\u0006\u00031\tQ!\u0001\u0003\u0002\u000b\u0005A\u0011!B\u0001\u0005\u0003\u0015\tA\"A\u0003\u0002\t\u0007)\u0011\u0001D\u0001\u0006\u0001\u0015\t\u0001\u0002E\u0003\u0002\t\u000b)\u0011\u0001c\u0003\u0006\u0001\u0015\tA\"A\u0003\u0001\u0019\u0001)\"\u0001\u0002\u0001\t\u0002e\t\u0001$AO\u0001\"\u0005R\u0013b\u0001E\u0002\u001b\u0005A\"!C\u0005\t\u000659\u0011BA\u0005\u00021\u000fI!!C\u0001\u001d\u0001a\u0019\u0011\u0012\u0007\u0005\u0005\u001b[I\u0001\"C\u0004\n\u0005%\t\u0001tA\u0005\u0003\u0013\u0005a\u0002\u0001G\u0002\n\u0005%\t\u0001tA\u0005\u0003\u0013\u0005AR!C\u0002\n\u00051\u0005\u00014\u0002M\u0005#\u000e\tAAB)\u0004\u0003!5Q%\u0005\u0003\u0002\u0011\u001di\u0011\u0001g\u0004\u001a\u0007!AQ\"\u0001M\u00063\rA\t\"D\u0001\u0019\u0013e!A!\u0001E\n\u001b\u0005AR!\n\u0005\u0005\u0017!QQ\"\u0001M\b3\rA\t\"D\u0001\u0019\u0013\u0015ZAa\u0003E\u000b\u001b\u0005A2\"\u0007\u0004\t\u00185!\u0011BA\u0005\u00021%AB\"\n\t\u0005\u0003!eQ\"\u0002\t\u000e+\ta\t\u0001g\u0003\u0019\fe\u0019\u00012D\u0007\u00021\u000fI2\u0001\u0003\b\u000e\u0003a)Q\u0005\u0003\u0003\f\u0011;i\u0011\u0001G\b\u001a\u0007!EQ\"\u0001\r\nK!!1\u0002c\b\u000e\u0003a\u0001\u0012d\u0001E\t\u001b\u0005A\u0012\"K\u0007\u0005\u0003\"A)!D\u0004\n\u0005%\t\u0001tA\u0005\u0003\u0013\u0005a\u0002\u0001G\u0002R\u0007\u0005)\u0001!+\u000f\u0005\u0003\"AA!$\f\n\u0011%9\u0011BA\u0005\u00021\u000fI!!C\u0001\u001d\u0001a\u0019\u0011BA\u0005\u00021\u000fI!!C\u0001\u0019\u000b%\u0019\u0011B\u0001G\u00011\u0017AJ!U\u0002\u0002\t\u0019\t6!A\u0003\u0001S\u001d!\u0011\t\u0003E\u0002\u001b\u0005A\"!U\u0002\u0002\u000b\u0001\u0001"}, strings={"Lorg/jetbrains/settingsRepository/git/JGitMergeProvider;", "T", "Lcom/intellij/openapi/vcs/merge/MergeProvider2;", "repository", "Lorg/eclipse/jgit/lib/Repository;", "conflicts", "", "", "pathToContent", "Lkotlin/Function3;", "", "", "Lkotlin/Extension;", "(Lorg/eclipse/jgit/lib/Repository;Ljava/util/Map;Lkotlin/jvm/functions/Function3;)V", "addFile", "", "bytes", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "size", "conflictResolvedForFile", "createMergeSession", "Lorg/jetbrains/settingsRepository/git/JGitMergeProvider$JGitMergeSession;", "files", "", "getContentOrEmpty", "kotlin.jvm.PlatformType", "path", "index", "isBinary", "", "loadRevisions", "Lcom/intellij/openapi/vcs/merge/MergeData;", "JGitMergeSession"}, moduleName="settings-repository")
public final class JGitMergeProvider<T>
implements MergeProvider2 {
    private final Repository repository;
    private final Map<String, ? extends T> conflicts;
    private final Function3<? super Map<String, ? extends T>, ? super String, ? super Integer, ? extends byte[]> pathToContent;

    @NotNull
    public JGitMergeSession createMergeSession(@NotNull List<? extends VirtualFile> files2) {
        Intrinsics.checkParameterIsNotNull(files2, (String)"files");
        return new JGitMergeSession();
    }

    public void conflictResolvedForFile(@NotNull VirtualFile file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        VirtualFile virtualFile = file;
        if (virtualFile == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.settingsRepository.RepositoryVirtualFile");
        }
        byte[] bytes = ((RepositoryVirtualFile)virtualFile).getContent();
        if (bytes == null) {
            Document document = FileDocumentManager.getInstance().getCachedDocument(file);
            if (document == null) {
                Intrinsics.throwNpe();
            }
            CharSequence chars = document.getImmutableCharSequence();
            ByteBuffer byteBuffer = CharsetToolkit.UTF8_CHARSET.encode(CharBuffer.wrap(chars));
            byte[] byArray = byteBuffer.array();
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"byteBuffer.array()");
            this.addFile(byArray, file, byteBuffer.remaining());
        } else {
            JGitMergeProvider.addFile$default(this, bytes, file, 0, 4);
        }
    }

    private final void addFile(byte[] bytes, VirtualFile file, int size) {
        String string = file.getPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"file.path");
        DirCacheEditorKt.writePath(this.repository, string, bytes, size);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void addFile$default(JGitMergeProvider jGitMergeProvider, byte[] byArray, VirtualFile virtualFile, int n, int n2) {
        JGitMergeProvider jGitMergeProvider2 = jGitMergeProvider;
        byte[] byArray2 = byArray;
        VirtualFile virtualFile2 = virtualFile;
        if ((n2 & 4) != 0) {
            void $receiver;
            byte[] byArray3 = byArray;
            VirtualFile virtualFile3 = virtualFile2;
            byte[] byArray4 = byArray2;
            JGitMergeProvider jGitMergeProvider3 = jGitMergeProvider2;
            int n3 = ((void)$receiver).length;
            jGitMergeProvider2 = jGitMergeProvider3;
            byArray2 = byArray4;
            virtualFile2 = virtualFile3;
            n = n3;
        }
        jGitMergeProvider2.addFile(byArray2, virtualFile2, n);
    }

    public boolean isBinary(@NotNull VirtualFile file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        return file.getFileType().isBinary();
    }

    @NotNull
    public MergeData loadRevisions(@NotNull VirtualFile file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        String path = file.getPath();
        MergeData mergeData = new MergeData();
        String string = path;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"path");
        mergeData.ORIGINAL = this.getContentOrEmpty(string, 0);
        String string2 = path;
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"path");
        mergeData.CURRENT = this.getContentOrEmpty(string2, 1);
        String string3 = path;
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"path");
        mergeData.LAST = this.getContentOrEmpty(string3, 2);
        return mergeData;
    }

    private final byte[] getContentOrEmpty(String path, int index) {
        byte[] byArray = (byte[])this.pathToContent.invoke(this.conflicts, (Object)path, (Object)index);
        if (byArray == null) {
            byArray = ArrayUtil.EMPTY_BYTE_ARRAY;
        }
        return byArray;
    }

    public JGitMergeProvider(@NotNull Repository repository2, @NotNull Map<String, ? extends T> conflicts, @NotNull Function3<? super Map<String, ? extends T>, ? super String, ? super Integer, ? extends byte[]> pathToContent) {
        Intrinsics.checkParameterIsNotNull((Object)repository2, (String)"repository");
        Intrinsics.checkParameterIsNotNull(conflicts, (String)"conflicts");
        Intrinsics.checkParameterIsNotNull(pathToContent, (String)"pathToContent");
        this.repository = repository2;
        this.conflicts = conflicts;
        this.pathToContent = pathToContent;
    }

    public static final /* synthetic */ void access$addFile(JGitMergeProvider<T> $this, @NotNull byte[] bytes, @NotNull VirtualFile file, int size) {
        super.addFile(bytes, file, size);
    }

    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"=\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u0003!-Q\u0001A\u0003\u0002\u0019\u0005)\u0001!B\u0001\t\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001C\u0005\u0006\u0003\u0011\tQ!\u0001E\t\u000b\u0005a\u0011!B\u0001\t\u0001\u0015\tA!\u0001\u0003B\u00051\u0001\u0011$\u0001M\u0001;\u0003M\u0011UA)\u0004\u0003!\tQ\u0005\u0003\u0003\f\u0011\u0007i\u0011\u0001\u0007\u0002\u001a\u0007!\u0015Q\"\u0001\r\u0004K1!1\u0002c\u0002\u000e\u0003a!\u0011d\u0001E\u0003\u001b\u0005A2!G\u0002\t\n5\t\u0001$B\u0013\u000e\t\u0005AY!\u0004\u0002\r\u0002a1\u0011d\u0001E\u0003\u001b\u0005A2!G\u0002\t\u000e5\t\u0001DAS\u0014\t-Aq!\u0004\b\n\u0019%Y\u0011\u0002\u0002C\u0001\u0013\ta\t\u0001'\u0005\n\t\u0011\u0005\u0011B\u0001G\u00011#A\u0002\u0002g\u0004R\u0007\u0005A\u0011\u0002"}, strings={"Lorg/jetbrains/settingsRepository/git/JGitMergeProvider$JGitMergeSession;", "Lcom/intellij/openapi/vcs/merge/MergeSession;", "(Lorg/jetbrains/settingsRepository/git/JGitMergeProvider;)V", "canMerge", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "conflictResolvedForFile", "", "resolution", "Lcom/intellij/openapi/vcs/merge/MergeSession$Resolution;", "getContent", "", "isTheirs", "getMergeInfoColumns", "", "Lcom/intellij/util/ui/ColumnInfo;", "", "()[Lcom/intellij/util/ui/ColumnInfo;", "StatusColumn"}, moduleName="settings-repository")
    private final class JGitMergeSession
    implements MergeSession {
        @NotNull
        public ColumnInfo<? extends Object, ? extends Object>[] getMergeInfoColumns() {
            return new ColumnInfo[]{new StatusColumn(false), new StatusColumn(true)};
        }

        public boolean canMerge(@NotNull VirtualFile file) {
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            Map map = JGitMergeProvider.this.conflicts;
            String string = file.getPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"file.path");
            return MapsKt.contains(map, (Object)string);
        }

        public void conflictResolvedForFile(@NotNull VirtualFile file, @NotNull MergeSession.Resolution resolution) {
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            Intrinsics.checkParameterIsNotNull((Object)resolution, (String)"resolution");
            if (Intrinsics.areEqual((Object)resolution, (Object)MergeSession.Resolution.Merged)) {
                JGitMergeProvider.this.conflictResolvedForFile(file);
            } else {
                byte[] content = this.getContent(file, Intrinsics.areEqual((Object)resolution, (Object)MergeSession.Resolution.AcceptedTheirs));
                if (content == null) {
                    Repository repository2 = JGitMergeProvider.this.repository;
                    String string = file.getPath();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"file.path");
                    DirCacheEditorKt.deletePath$default(repository2, string, false, false, 6);
                } else {
                    JGitMergeProvider.addFile$default(JGitMergeProvider.this, content, file, 0, 4);
                }
            }
        }

        private final byte[] getContent(VirtualFile file, boolean isTheirs) {
            Function3 function3 = JGitMergeProvider.this.pathToContent;
            Map map = JGitMergeProvider.this.conflicts;
            String string = file.getPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"file.path");
            return (byte[])function3.invoke(map, (Object)string, (Object)(isTheirs ? 2 : 1));
        }

        @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"#\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001D\u0001\u0006\u0003!9Q\u0001A\u0003\u0002\u0011\u0017)\u0011\u0001B\u0001\u0006\u0003!!Q!\u0001C\u0002\t\r\u0013A\u0002A\r\b\u0013\tI\u0011\u0001G\u0001\n\u0005%\t\u00014\u0001M\u0001C!II\u0001\u0003\u0002\u000e\u0003a\u0015\u0001k!\u0001R\u0007\u0005A1!\n\u0003\u0005\u0017!\u001dQ\"\u0001\r\u0005K\u0011!1\u0002#\u0003\u000e\u0003a\rQ%\u0003\u0003\f\u0011\u0015i\u0011\u0001g\u0001\u001a\t!-QB\u0001G\u00011\u0005Is\u0001B!\t\u0011\ti\u0011\u0001'\u0002R\u0007\u0005)\u0001\u0001"}, strings={"Lorg/jetbrains/settingsRepository/git/JGitMergeProvider$JGitMergeSession$StatusColumn;", "Lcom/intellij/util/ui/ColumnInfo;", "Lcom/intellij/openapi/vfs/VirtualFile;", "", "isTheirs", "", "(Lorg/jetbrains/settingsRepository/git/JGitMergeProvider$JGitMergeSession;Z)V", "getAdditionalWidth", "", "getMaxStringValue", "valueOf", "file"}, moduleName="settings-repository")
        public final class StatusColumn
        extends ColumnInfo<VirtualFile, String> {
            private final boolean isTheirs;

            @NotNull
            public String valueOf(@Nullable VirtualFile file) {
                VirtualFile virtualFile = file;
                if (virtualFile == null) {
                    Intrinsics.throwNpe();
                }
                return JGitMergeSession.this.getContent(virtualFile, this.isTheirs) == null ? "Deleted" : "Modified";
            }

            @NotNull
            public String getMaxStringValue() {
                return "Modified";
            }

            public int getAdditionalWidth() {
                return 10;
            }

            public StatusColumn(boolean isTheirs) {
                super(isTheirs ? "Theirs" : "Yours");
                this.isTheirs = isTheirs;
            }
        }
    }
}

