/*
 * Decompiled with CFR 0.152.
 */
package git4idea.history.wholeTree;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.NamedRunnable;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentManager;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.vcs.log.VcsLog;
import com.intellij.vcs.log.impl.VcsLogContentProvider;
import com.intellij.vcs.log.impl.VcsLogManager;
import com.intellij.vcs.log.ui.VcsLogUiImpl;
import git4idea.i18n.GitBundle;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SelectRevisionInGitLogAction
extends DumbAwareAction {
    private static final Logger LOG = Logger.getInstance(SelectRevisionInGitLogAction.class);

    public SelectRevisionInGitLogAction() {
        super(GitBundle.getString("vcs.history.action.gitlog"), GitBundle.getString("vcs.history.action.gitlog"), null);
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        VcsLog log;
        Content[] contents;
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "git4idea/history/wholeTree/SelectRevisionInGitLogAction", "actionPerformed"));
        }
        final Project project = (Project)event.getRequiredData(CommonDataKeys.PROJECT);
        final VcsRevisionNumber revision = SelectRevisionInGitLogAction.getRevisionNumber(event);
        if (revision == null) {
            return;
        }
        boolean logReady = SelectRevisionInGitLogAction.findLog(project) != null;
        final ToolWindow window = ToolWindowManager.getInstance((Project)project).getToolWindow(ChangesViewContentManager.TOOLWINDOW_ID);
        ContentManager cm = window.getContentManager();
        for (Content content : contents = cm.getContents()) {
            if (!"Log".equals(content.getDisplayName())) continue;
            cm.setSelectedContent(content);
            break;
        }
        if ((log = SelectRevisionInGitLogAction.findLog(project)) == null) {
            SelectRevisionInGitLogAction.showLogNotReadyMessage(project);
            return;
        }
        Runnable selectAndOpenLog = new Runnable(){

            @Override
            public void run() {
                Runnable selectCommit = new Runnable(){

                    @Override
                    public void run() {
                        SelectRevisionInGitLogAction.jumpToRevisionUnderProgress(project, log, revision);
                    }
                };
                if (!window.isVisible()) {
                    window.activate(selectCommit, true);
                } else {
                    selectCommit.run();
                }
            }
        };
        if (logReady) {
            selectAndOpenLog.run();
            return;
        }
        VcsLogManager logManager = VcsLogContentProvider.findLogManager((Project)project);
        if (logManager == null) {
            SelectRevisionInGitLogAction.showLogNotReadyMessage(project);
            return;
        }
        VcsLogUiImpl logUi = logManager.getLogUi();
        if (logUi == null) {
            SelectRevisionInGitLogAction.showLogNotReadyMessage(project);
            return;
        }
        logUi.invokeOnChange(selectAndOpenLog);
    }

    private static void showLogNotReadyMessage(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/history/wholeTree/SelectRevisionInGitLogAction", "showLogNotReadyMessage"));
        }
        VcsBalloonProblemNotifier.showOverChangesView((Project)project, (String)GitBundle.getString("vcs.history.action.gitlog.error"), (MessageType)MessageType.WARNING, (NamedRunnable[])new NamedRunnable[0]);
    }

    @Nullable
    private static VcsRevisionNumber getRevisionNumber(@NotNull AnActionEvent event) {
        VcsFileRevision fileRevision;
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "git4idea/history/wholeTree/SelectRevisionInGitLogAction", "getRevisionNumber"));
        }
        VcsRevisionNumber revision = (VcsRevisionNumber)event.getData(VcsDataKeys.VCS_REVISION_NUMBER);
        if (revision == null && (fileRevision = (VcsFileRevision)event.getData(VcsDataKeys.VCS_FILE_REVISION)) != null) {
            revision = fileRevision.getRevisionNumber();
        }
        return revision;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "git4idea/history/wholeTree/SelectRevisionInGitLogAction", "update"));
        }
        super.update(e);
        e.getPresentation().setEnabled(e.getProject() != null && VcsLogContentProvider.findLogManager((Project)e.getProject()) != null && (e.getData(VcsDataKeys.VCS_FILE_REVISION) != null || e.getData(VcsDataKeys.VCS_REVISION_NUMBER) != null));
    }

    @Nullable
    private static VcsLog findLog(@NotNull Project project) {
        VcsLogUiImpl ui;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/history/wholeTree/SelectRevisionInGitLogAction", "findLog"));
        }
        VcsLogManager manager = VcsLogContentProvider.findLogManager((Project)project);
        if (manager != null && (ui = manager.getLogUi()) != null) {
            return ui.getVcsLog();
        }
        return null;
    }

    private static void jumpToRevisionUnderProgress(@NotNull Project project, @NotNull VcsLog log, @NotNull VcsRevisionNumber revision) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/history/wholeTree/SelectRevisionInGitLogAction", "jumpToRevisionUnderProgress"));
        }
        if (log == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "log", "git4idea/history/wholeTree/SelectRevisionInGitLogAction", "jumpToRevisionUnderProgress"));
        }
        if (revision == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "revision", "git4idea/history/wholeTree/SelectRevisionInGitLogAction", "jumpToRevisionUnderProgress"));
        }
        final Future future = log.jumpToReference(revision.asString());
        if (!future.isDone()) {
            ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, "Searching for revision " + revision.asString(), false, PerformInBackgroundOption.ALWAYS_BACKGROUND){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/history/wholeTree/SelectRevisionInGitLogAction$2", "run"));
                    }
                    try {
                        future.get();
                    }
                    catch (CancellationException cancellationException) {
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    catch (ExecutionException e) {
                        LOG.error((Throwable)e);
                    }
                }
            });
        }
    }
}

