/*
 * Decompiled with CFR 0.152.
 */
package git4idea.repo;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileCopyEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.util.messages.MessageBusConnection;
import git4idea.GitUtil;
import git4idea.commands.Git;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryFiles;
import git4idea.repo.GitRepositoryManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitUntrackedFilesHolder
implements Disposable,
BulkFileListener {
    private static final Logger LOG = Logger.getInstance(GitUntrackedFilesHolder.class);
    private final Project myProject;
    private final VirtualFile myRoot;
    private final ChangeListManager myChangeListManager;
    private final VcsDirtyScopeManager myDirtyScopeManager;
    private final ProjectLevelVcsManager myVcsManager;
    private final GitRepositoryFiles myRepositoryFiles;
    private final Git myGit;
    private final Set<VirtualFile> myDefinitelyUntrackedFiles;
    private final Set<VirtualFile> myPossiblyUntrackedFiles;
    private boolean myReady;
    private final Object LOCK;
    private final GitRepositoryManager myRepositoryManager;

    GitUntrackedFilesHolder(@NotNull GitRepository repository) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "git4idea/repo/GitUntrackedFilesHolder", "<init>"));
        }
        this.myDefinitelyUntrackedFiles = new HashSet<VirtualFile>();
        this.myPossiblyUntrackedFiles = new HashSet<VirtualFile>();
        this.LOCK = new Object();
        this.myProject = repository.getProject();
        this.myRoot = repository.getRoot();
        this.myChangeListManager = ChangeListManager.getInstance((Project)this.myProject);
        this.myDirtyScopeManager = VcsDirtyScopeManager.getInstance((Project)this.myProject);
        this.myGit = (Git)ServiceManager.getService(Git.class);
        this.myVcsManager = ProjectLevelVcsManager.getInstance((Project)this.myProject);
        this.myRepositoryManager = GitUtil.getRepositoryManager(this.myProject);
        this.myRepositoryFiles = GitRepositoryFiles.getInstance(repository.getGitDir());
    }

    void setupVfsListener(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/repo/GitUntrackedFilesHolder", "setupVfsListener"));
        }
        if (!project.isDisposed()) {
            MessageBusConnection connection = project.getMessageBus().connect((Disposable)this);
            connection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Object object = this.myDefinitelyUntrackedFiles;
        synchronized (object) {
            this.myDefinitelyUntrackedFiles.clear();
        }
        object = this.LOCK;
        synchronized (object) {
            this.myPossiblyUntrackedFiles.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "git4idea/repo/GitUntrackedFilesHolder", "add"));
        }
        Set<VirtualFile> set = this.myDefinitelyUntrackedFiles;
        synchronized (set) {
            this.myDefinitelyUntrackedFiles.add(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(@NotNull Collection<VirtualFile> files) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "git4idea/repo/GitUntrackedFilesHolder", "add"));
        }
        Set<VirtualFile> set = this.myDefinitelyUntrackedFiles;
        synchronized (set) {
            this.myDefinitelyUntrackedFiles.addAll(files);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(@NotNull Collection<VirtualFile> files) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "git4idea/repo/GitUntrackedFilesHolder", "remove"));
        }
        Set<VirtualFile> set = this.myDefinitelyUntrackedFiles;
        synchronized (set) {
            this.myDefinitelyUntrackedFiles.removeAll(files);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public Collection<VirtualFile> retrieveUntrackedFiles() throws VcsException {
        if (this.isReady()) {
            this.verifyPossiblyUntrackedFiles();
        } else {
            this.rescanAll();
        }
        Set<VirtualFile> set = this.myDefinitelyUntrackedFiles;
        // MONITORENTER : set
        ArrayList<VirtualFile> arrayList = new ArrayList<VirtualFile>(this.myDefinitelyUntrackedFiles);
        // MONITOREXIT : set
        if (arrayList != null) return arrayList;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/repo/GitUntrackedFilesHolder", "retrieveUntrackedFiles"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidate() {
        Object object = this.LOCK;
        synchronized (object) {
            this.myReady = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rescanAll() throws VcsException {
        Set<VirtualFile> untrackedFiles = this.myGit.untrackedFiles(this.myProject, this.myRoot, null);
        Object object = this.myDefinitelyUntrackedFiles;
        synchronized (object) {
            this.myDefinitelyUntrackedFiles.clear();
            this.myDefinitelyUntrackedFiles.addAll(untrackedFiles);
        }
        object = this.LOCK;
        synchronized (object) {
            this.myPossiblyUntrackedFiles.clear();
            this.myReady = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isReady() {
        Object object = this.LOCK;
        synchronized (object) {
            return this.myReady;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyPossiblyUntrackedFiles() throws VcsException {
        HashSet<VirtualFile> suspiciousFiles = new HashSet<VirtualFile>();
        Set<VirtualFile> set = this.LOCK;
        synchronized (set) {
            suspiciousFiles.addAll(this.myPossiblyUntrackedFiles);
            this.myPossiblyUntrackedFiles.clear();
        }
        set = this.myDefinitelyUntrackedFiles;
        synchronized (set) {
            Set<VirtualFile> untrackedFiles = this.myGit.untrackedFiles(this.myProject, this.myRoot, suspiciousFiles);
            suspiciousFiles.removeAll(untrackedFiles);
            HashSet<VirtualFile> trackedFiles = suspiciousFiles;
            this.myDefinitelyUntrackedFiles.addAll(untrackedFiles);
            this.myDefinitelyUntrackedFiles.removeAll(trackedFiles);
        }
    }

    public void before(@NotNull List<? extends VFileEvent> events) {
        if (events == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "git4idea/repo/GitUntrackedFilesHolder", "before"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void after(@NotNull List<? extends VFileEvent> events) {
        Object object;
        if (events == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "git4idea/repo/GitUntrackedFilesHolder", "after"));
        }
        boolean allChanged = false;
        HashSet<VirtualFile> filesToRefresh = new HashSet<VirtualFile>();
        for (VFileEvent vFileEvent : events) {
            if (allChanged) break;
            String path = vFileEvent.getPath();
            if (this.totalRefreshNeeded(path)) {
                allChanged = true;
                continue;
            }
            VirtualFile affectedFile = GitUntrackedFilesHolder.getAffectedFile(vFileEvent);
            if (!this.notIgnored(affectedFile)) continue;
            filesToRefresh.add(affectedFile);
        }
        if (allChanged) {
            LOG.debug(String.format("GitUntrackedFilesHolder: Index has changed, marking %s recursively dirty", this.myRoot));
            this.myDirtyScopeManager.dirDirtyRecursively(this.myRoot);
            object = this.LOCK;
            synchronized (object) {
                this.myReady = false;
            }
        }
        object = this.LOCK;
        synchronized (object) {
            this.myPossiblyUntrackedFiles.addAll(filesToRefresh);
        }
    }

    private boolean totalRefreshNeeded(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "git4idea/repo/GitUntrackedFilesHolder", "totalRefreshNeeded"));
        }
        return this.indexChanged(path) || this.externallyCommitted(path) || this.gitignoreChanged(path);
    }

    private boolean indexChanged(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "git4idea/repo/GitUntrackedFilesHolder", "indexChanged"));
        }
        return this.myRepositoryFiles.isIndexFile(path);
    }

    private boolean externallyCommitted(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "git4idea/repo/GitUntrackedFilesHolder", "externallyCommitted"));
        }
        return this.myRepositoryFiles.isCommitMessageFile(path);
    }

    private boolean gitignoreChanged(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "git4idea/repo/GitUntrackedFilesHolder", "gitignoreChanged"));
        }
        return path.endsWith(".gitignore") || this.myRepositoryFiles.isExclude(path);
    }

    @Nullable
    private static VirtualFile getAffectedFile(@NotNull VFileEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "git4idea/repo/GitUntrackedFilesHolder", "getAffectedFile"));
        }
        if (event instanceof VFileCreateEvent || event instanceof VFileDeleteEvent || event instanceof VFileMoveEvent || GitUntrackedFilesHolder.isRename(event)) {
            return event.getFile();
        }
        if (event instanceof VFileCopyEvent) {
            VFileCopyEvent copyEvent = (VFileCopyEvent)event;
            return copyEvent.getNewParent().findChild(copyEvent.getNewChildName());
        }
        return null;
    }

    private static boolean isRename(@NotNull VFileEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "git4idea/repo/GitUntrackedFilesHolder", "isRename"));
        }
        return event instanceof VFilePropertyChangeEvent && ((VFilePropertyChangeEvent)event).getPropertyName().equals("name");
    }

    private boolean notIgnored(@Nullable VirtualFile file) {
        return file != null && this.belongsToThisRepository(file) && !this.myChangeListManager.isIgnoredFile(file);
    }

    private boolean belongsToThisRepository(VirtualFile file) {
        GitRepository repository = (GitRepository)this.myRepositoryManager.getRepositoryForRootQuick(this.myVcsManager.getVcsRootFor(file));
        return repository != null && repository.getRoot().equals(this.myRoot);
    }
}

