/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.actions;

import com.intellij.codeInsight.actions.FileInEditorProcessor;
import com.intellij.codeInsight.actions.LayoutCodeDialog;
import com.intellij.lang.LanguageFormatting;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NonNls;

public class ShowReformatFileDialog
extends AnAction
implements DumbAware {
    @NonNls
    private static final String HELP_ID = "editing.codeReformatting";

    public void update(AnActionEvent event) {
        Presentation presentation = event.getPresentation();
        DataContext dataContext = event.getDataContext();
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        if (project == null || editor == null) {
            presentation.setEnabled(false);
            return;
        }
        PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
        if (file == null || file.getVirtualFile() == null) {
            presentation.setEnabled(false);
            return;
        }
        if (LanguageFormatting.INSTANCE.forContext((PsiElement)file) != null) {
            presentation.setEnabled(true);
        }
    }

    public void actionPerformed(AnActionEvent event) {
        Presentation presentation = event.getPresentation();
        DataContext dataContext = event.getDataContext();
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        if (project == null || editor == null) {
            presentation.setEnabled(false);
            return;
        }
        PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
        if (file == null || file.getVirtualFile() == null) {
            presentation.setEnabled(false);
            return;
        }
        boolean hasSelection = editor.getSelectionModel().hasSelection();
        LayoutCodeDialog dialog = new LayoutCodeDialog(project, file, hasSelection, HELP_ID);
        dialog.show();
        if (dialog.isOK()) {
            new FileInEditorProcessor(file, editor, dialog.getRunOptions()).processCode();
        }
    }
}

