/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.AutoCompletionContext;
import com.intellij.codeInsight.completion.AutoCompletionDecision;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.JavaChainLookupElement;
import com.intellij.codeInsight.completion.JavaCompletionUtil;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.util.ObjectUtils;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaMethodMergingContributor
extends CompletionContributor {
    public AutoCompletionDecision handleAutoCompletionPossibility(@NotNull AutoCompletionContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInsight/completion/JavaMethodMergingContributor", "handleAutoCompletionPossibility"));
        }
        CompletionParameters parameters = context.getParameters();
        if (parameters.getCompletionType() != CompletionType.SMART && parameters.getCompletionType() != CompletionType.BASIC) {
            return null;
        }
        LookupElement[] items = context.getItems();
        if (items.length > 1) {
            String commonName = null;
            ArrayList<PsiMethod> allMethods = new ArrayList<PsiMethod>();
            for (LookupElement item : items) {
                PsiElement o = item.getPsiElement();
                if (item.getUserData(JavaCompletionUtil.FORCE_SHOW_SIGNATURE_ATTR) != null || !(o instanceof PsiMethod)) {
                    return AutoCompletionDecision.SHOW_LOOKUP;
                }
                PsiMethod method = (PsiMethod)o;
                JavaChainLookupElement chain = (JavaChainLookupElement)item.as(JavaChainLookupElement.CLASS_CONDITION_KEY);
                String name = method.getName() + "#" + (chain == null ? "" : chain.getQualifier().getLookupString());
                if (commonName != null && !commonName.equals(name)) {
                    return AutoCompletionDecision.SHOW_LOOKUP;
                }
                commonName = name;
                allMethods.add(method);
            }
            for (LookupElement item : items) {
                JavaCompletionUtil.putAllMethods(item, allMethods);
            }
            return AutoCompletionDecision.insertItem((LookupElement)JavaMethodMergingContributor.findBestOverload(items));
        }
        return super.handleAutoCompletionPossibility(context);
    }

    public static LookupElement findBestOverload(LookupElement[] items) {
        LookupElement best = items[0];
        for (int i = 1; i < items.length; ++i) {
            LookupElement item = items[i];
            if (JavaMethodMergingContributor.getPriority(best) >= JavaMethodMergingContributor.getPriority(item)) continue;
            best = item;
        }
        return best;
    }

    private static int getPriority(LookupElement element) {
        PsiMethod method = (PsiMethod)ObjectUtils.assertNotNull((Object)JavaMethodMergingContributor.getItemMethod(element));
        return (method.getReturnType() == PsiType.VOID ? 0 : 1) + (method.getParameterList().getParametersCount() > 0 ? 2 : 0);
    }

    @Nullable
    private static PsiMethod getItemMethod(LookupElement item) {
        PsiElement o = item.getPsiElement();
        return o instanceof PsiMethod ? (PsiMethod)o : null;
    }
}

