/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl.config;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.IntentionManager;
import com.intellij.codeInsight.intention.impl.config.IntentionActionMetaData;
import com.intellij.codeInsight.intention.impl.config.IntentionActionWrapper;
import com.intellij.codeInsight.intention.impl.config.IntentionSettingsConfigurable;
import com.intellij.codeInsight.intention.impl.config.TextDescriptor;
import com.intellij.ide.ui.search.SearchableOptionsRegistrar;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Alarm;
import com.intellij.util.containers.StringInterner;
import com.intellij.util.containers.WeakStringInterner;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

@State(name="IntentionManagerSettings", storages={@Storage(file="$APP_CONFIG$/intentionSettings.xml")})
public class IntentionManagerSettings
implements PersistentStateComponent<Element> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.intention.impl.config.IntentionManagerSettings");
    private static final Alarm ourRegisterMetaDataAlarm = new Alarm(Alarm.ThreadToUse.SHARED_THREAD);
    private final Set<String> myIgnoredActions = new LinkedHashSet<String>();
    private final Map<MetaDataKey, IntentionActionMetaData> myMetaData = new LinkedHashMap<MetaDataKey, IntentionActionMetaData>();
    @NonNls
    private static final String IGNORE_ACTION_TAG = "ignoreAction";
    @NonNls
    private static final String NAME_ATT = "name";
    private static final Pattern HTML_PATTERN = Pattern.compile("<[^<>]*>");

    public static IntentionManagerSettings getInstance() {
        return (IntentionManagerSettings)ServiceManager.getService(IntentionManagerSettings.class);
    }

    public void registerIntentionMetaData(@NotNull IntentionAction intentionAction, @NotNull String[] category, @NotNull String descriptionDirectoryName) {
        if (intentionAction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "intentionAction", "com/intellij/codeInsight/intention/impl/config/IntentionManagerSettings", "registerIntentionMetaData"));
        }
        if (category == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "category", "com/intellij/codeInsight/intention/impl/config/IntentionManagerSettings", "registerIntentionMetaData"));
        }
        if (descriptionDirectoryName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptionDirectoryName", "com/intellij/codeInsight/intention/impl/config/IntentionManagerSettings", "registerIntentionMetaData"));
        }
        this.registerMetaData(new IntentionActionMetaData(intentionAction, IntentionManagerSettings.getClassLoader(intentionAction), category, descriptionDirectoryName));
    }

    private static ClassLoader getClassLoader(@NotNull IntentionAction intentionAction) {
        if (intentionAction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "intentionAction", "com/intellij/codeInsight/intention/impl/config/IntentionManagerSettings", "getClassLoader"));
        }
        return intentionAction instanceof IntentionActionWrapper ? ((IntentionActionWrapper)intentionAction).getImplementationClassLoader() : intentionAction.getClass().getClassLoader();
    }

    public void registerIntentionMetaData(@NotNull IntentionAction intentionAction, @NotNull String[] category, @NotNull String descriptionDirectoryName, ClassLoader classLoader) {
        if (intentionAction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "intentionAction", "com/intellij/codeInsight/intention/impl/config/IntentionManagerSettings", "registerIntentionMetaData"));
        }
        if (category == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "category", "com/intellij/codeInsight/intention/impl/config/IntentionManagerSettings", "registerIntentionMetaData"));
        }
        if (descriptionDirectoryName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptionDirectoryName", "com/intellij/codeInsight/intention/impl/config/IntentionManagerSettings", "registerIntentionMetaData"));
        }
        this.registerMetaData(new IntentionActionMetaData(intentionAction, classLoader, category, descriptionDirectoryName));
    }

    public synchronized boolean isShowLightBulb(@NotNull IntentionAction action) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/codeInsight/intention/impl/config/IntentionManagerSettings", "isShowLightBulb"));
        }
        return !this.myIgnoredActions.contains(action.getFamilyName());
    }

    public void loadState(Element element) {
        this.myIgnoredActions.clear();
        List children = element.getChildren(IGNORE_ACTION_TAG);
        for (Object aChildren : children) {
            Element e = (Element)aChildren;
            this.myIgnoredActions.add(e.getAttributeValue(NAME_ATT));
        }
    }

    public Element getState() {
        Element element = new Element("state");
        for (String name : this.myIgnoredActions) {
            element.addContent(new Element(IGNORE_ACTION_TAG).setAttribute(NAME_ATT, name));
        }
        return element;
    }

    @NotNull
    public synchronized List<IntentionActionMetaData> getMetaData() {
        IntentionManager.getInstance();
        ArrayList<IntentionActionMetaData> arrayList = new ArrayList<IntentionActionMetaData>(this.myMetaData.values());
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/config/IntentionManagerSettings", "getMetaData"));
        }
        return arrayList;
    }

    public synchronized boolean isEnabled(@NotNull IntentionActionMetaData metaData) {
        if (metaData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "metaData", "com/intellij/codeInsight/intention/impl/config/IntentionManagerSettings", "isEnabled"));
        }
        return !this.myIgnoredActions.contains(IntentionManagerSettings.getFamilyName(metaData));
    }

    private static String getFamilyName(@NotNull IntentionActionMetaData metaData) {
        if (metaData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "metaData", "com/intellij/codeInsight/intention/impl/config/IntentionManagerSettings", "getFamilyName"));
        }
        return StringUtil.join((String[])metaData.myCategory, (String)"/") + "/" + metaData.getFamily();
    }

    private static String getFamilyName(@NotNull IntentionAction action) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/codeInsight/intention/impl/config/IntentionManagerSettings", "getFamilyName"));
        }
        return action instanceof IntentionActionWrapper ? ((IntentionActionWrapper)action).getFullFamilyName() : action.getFamilyName();
    }

    public synchronized void setEnabled(@NotNull IntentionActionMetaData metaData, boolean enabled) {
        if (metaData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "metaData", "com/intellij/codeInsight/intention/impl/config/IntentionManagerSettings", "setEnabled"));
        }
        if (enabled) {
            this.myIgnoredActions.remove(IntentionManagerSettings.getFamilyName(metaData));
        } else {
            this.myIgnoredActions.add(IntentionManagerSettings.getFamilyName(metaData));
        }
    }

    public synchronized boolean isEnabled(@NotNull IntentionAction action) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/codeInsight/intention/impl/config/IntentionManagerSettings", "isEnabled"));
        }
        return !this.myIgnoredActions.contains(IntentionManagerSettings.getFamilyName(action));
    }

    public synchronized void setEnabled(@NotNull IntentionAction action, boolean enabled) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/codeInsight/intention/impl/config/IntentionManagerSettings", "setEnabled"));
        }
        if (enabled) {
            this.myIgnoredActions.remove(IntentionManagerSettings.getFamilyName(action));
        } else {
            this.myIgnoredActions.add(IntentionManagerSettings.getFamilyName(action));
        }
    }

    public synchronized void registerMetaData(@NotNull IntentionActionMetaData metaData) {
        if (metaData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "metaData", "com/intellij/codeInsight/intention/impl/config/IntentionManagerSettings", "registerMetaData"));
        }
        MetaDataKey key = new MetaDataKey(metaData.myCategory, metaData.getFamily());
        if (!this.myMetaData.containsKey((Object)key)) {
            IntentionManagerSettings.processMetaData(metaData);
        }
        this.myMetaData.put(key, metaData);
    }

    private static synchronized void processMetaData(final @NotNull IntentionActionMetaData metaData) {
        if (metaData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "metaData", "com/intellij/codeInsight/intention/impl/config/IntentionManagerSettings", "processMetaData"));
        }
        Application app = ApplicationManager.getApplication();
        if (app.isUnitTestMode() || app.isHeadlessEnvironment()) {
            return;
        }
        final TextDescriptor description = metaData.getDescription();
        ourRegisterMetaDataAlarm.addRequest(new Runnable(){

            @Override
            public void run() {
                try {
                    SearchableOptionsRegistrar registrar = SearchableOptionsRegistrar.getInstance();
                    if (registrar == null) {
                        return;
                    }
                    String descriptionText = description.getText().toLowerCase();
                    descriptionText = HTML_PATTERN.matcher(descriptionText).replaceAll(" ");
                    Set words = registrar.getProcessedWordsWithoutStemming(descriptionText);
                    words.addAll(registrar.getProcessedWords(metaData.getFamily()));
                    for (String word : words) {
                        registrar.addOption(word, metaData.getFamily(), metaData.getFamily(), "preferences.intentionPowerPack", IntentionSettingsConfigurable.DISPLAY_NAME);
                    }
                }
                catch (IOException e) {
                    LOG.error((Throwable)e);
                }
            }
        }, 0);
    }

    public synchronized void unregisterMetaData(@NotNull IntentionAction intentionAction) {
        if (intentionAction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "intentionAction", "com/intellij/codeInsight/intention/impl/config/IntentionManagerSettings", "unregisterMetaData"));
        }
        for (Map.Entry<MetaDataKey, IntentionActionMetaData> entry : this.myMetaData.entrySet()) {
            if (entry.getValue().getAction() != intentionAction) continue;
            this.myMetaData.remove((Object)entry.getKey());
            break;
        }
    }

    private static class MetaDataKey
    extends Pair<String, String> {
        private static final StringInterner ourInterner = new WeakStringInterner();

        private MetaDataKey(@NotNull String[] categoryNames, @NotNull String familyName) {
            if (categoryNames == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "categoryNames", "com/intellij/codeInsight/intention/impl/config/IntentionManagerSettings$MetaDataKey", "<init>"));
            }
            if (familyName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "familyName", "com/intellij/codeInsight/intention/impl/config/IntentionManagerSettings$MetaDataKey", "<init>"));
            }
            super((Object)StringUtil.join((String[])categoryNames, (String)":"), ourInterner.intern((Object)familyName));
        }
    }
}

