/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.emmet.nodes;

import com.intellij.codeInsight.template.CustomTemplateCallback;
import com.intellij.codeInsight.template.emmet.nodes.GenerationNode;
import com.intellij.codeInsight.template.emmet.nodes.ZenCodingNode;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class AddOperationNode
extends ZenCodingNode {
    private final ZenCodingNode myLeftOperand;
    private final ZenCodingNode myRightOperand;

    public AddOperationNode(@NotNull ZenCodingNode leftOperand, @NotNull ZenCodingNode rightOperand) {
        if (leftOperand == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "leftOperand", "com/intellij/codeInsight/template/emmet/nodes/AddOperationNode", "<init>"));
        }
        if (rightOperand == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rightOperand", "com/intellij/codeInsight/template/emmet/nodes/AddOperationNode", "<init>"));
        }
        this.myLeftOperand = leftOperand;
        this.myRightOperand = rightOperand;
    }

    public ZenCodingNode getLeftOperand() {
        return this.myLeftOperand;
    }

    public ZenCodingNode getRightOperand() {
        return this.myRightOperand;
    }

    @Override
    @NotNull
    public List<ZenCodingNode> getChildren() {
        LinkedList linkedList = ContainerUtil.newLinkedList((Object[])new ZenCodingNode[]{this.myLeftOperand, this.myRightOperand});
        if (linkedList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/emmet/nodes/AddOperationNode", "getChildren"));
        }
        return linkedList;
    }

    @Override
    @NotNull
    public List<GenerationNode> expand(int numberInIteration, int totalIterations, String surroundedText, CustomTemplateCallback callback, boolean insertSurroundedTextAtTheEnd, GenerationNode parent) {
        ArrayList<GenerationNode> result2 = new ArrayList<GenerationNode>();
        List<GenerationNode> leftNodes = this.myLeftOperand.expand(numberInIteration, totalIterations, surroundedText, callback, false, parent);
        result2.addAll(leftNodes);
        result2.addAll(this.myRightOperand.expand(numberInIteration, totalIterations, surroundedText, callback, insertSurroundedTextAtTheEnd, parent));
        ArrayList<GenerationNode> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/emmet/nodes/AddOperationNode", "expand"));
        }
        return arrayList;
    }

    public String toString() {
        return "+";
    }

    @Override
    public int getApproximateOutputLength(CustomTemplateCallback callback) {
        return this.myLeftOperand.getApproximateOutputLength(callback) + this.myRightOperand.getApproximateOutputLength(callback);
    }
}

