/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInspection.BaseJavaBatchLocalInspectionTool;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CollectionAddAllCanBeReplacedWithConstructorInspection
extends BaseJavaBatchLocalInspectionTool {
    private static final Logger LOG = Logger.getInstance(CollectionAddAllCanBeReplacedWithConstructorInspection.class);

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/CollectionAddAllCanBeReplacedWithConstructorInspection", "buildVisitor"));
        }
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/codeInspection/CollectionAddAllCanBeReplacedWithConstructorInspection", "buildVisitor"));
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void visitMethodCallExpression(PsiMethodCallExpression expression) {
                String methodName = expression.getMethodExpression().getReferenceName();
                if (!"addAll".equals(methodName)) return;
                if (expression.getArgumentList().getExpressions().length != 1) {
                    return;
                }
                PsiExpression qualifierExpression = expression.getMethodExpression().getQualifierExpression();
                if (!(qualifierExpression instanceof PsiReferenceExpression)) {
                    return;
                }
                PsiElement resolvedReference = ((PsiReferenceExpression)qualifierExpression).resolve();
                if (!(resolvedReference instanceof PsiLocalVariable)) {
                    return;
                }
                PsiLocalVariable variable = (PsiLocalVariable)resolvedReference;
                PsiType variableType = variable.getType();
                if (!(variableType instanceof PsiClassType)) {
                    return;
                }
                PsiClass variableClass = ((PsiClassType)variableType).resolve();
                if (variableClass == null || !InheritanceUtil.isInheritor((PsiClass)variableClass, (String)"java.util.Collection")) {
                    return;
                }
                Pair pair = CollectionAddAllCanBeReplacedWithConstructorInspection.isProperAssignmentStatementFound(variable, expression);
                if (!((Boolean)pair.getFirst()).booleanValue()) return;
                PsiNewExpression assignmentExpression = (PsiNewExpression)pair.getSecond();
                if (assignmentExpression == null) {
                    if (!CollectionAddAllCanBeReplacedWithConstructorInspection.checkLocalVariableAssignmentOrInitializer(variable.getInitializer())) return;
                    assignmentExpression = (PsiNewExpression)variable.getInitializer();
                }
                if (!CollectionAddAllCanBeReplacedWithConstructorInspection.checkUsages(variable, expression, assignmentExpression)) {
                    return;
                }
                PsiMethod method = expression.resolveMethod();
                if (method == null) return;
                holder.registerProblem((PsiElement)expression, QuickFixBundle.message("collection.addall.can.be.replaced.with.constructor.fix.description", new Object[0]), new LocalQuickFix[]{new ReplaceAddAllWithConstructorFix(assignmentExpression, expression)});
            }
        };
        if (javaElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/CollectionAddAllCanBeReplacedWithConstructorInspection", "buildVisitor"));
        }
        return javaElementVisitor;
    }

    private static boolean checkLocalVariableAssignmentOrInitializer(PsiExpression initializer) {
        if (!(initializer instanceof PsiNewExpression)) {
            return false;
        }
        PsiNewExpression newExpression = (PsiNewExpression)initializer;
        PsiJavaCodeReferenceElement classReference = newExpression.getClassReference();
        if (classReference == null) {
            return false;
        }
        PsiClass initializerClass = (PsiClass)classReference.resolve();
        if (initializerClass == null || !CollectionAddAllCanBeReplacedWithConstructorInspection.hasProperConstructor(initializerClass)) {
            return false;
        }
        PsiExpressionList argumentList = newExpression.getArgumentList();
        return argumentList != null && argumentList.getExpressions().length == 0;
    }

    private static boolean hasProperConstructor(PsiClass psiClass) {
        for (PsiMethod psiMethod : psiClass.getConstructors()) {
            PsiType type;
            PsiParameter parameter;
            PsiTypeElement typeElement;
            PsiParameterList parameterList = psiMethod.getParameterList();
            if (parameterList.getParametersCount() != 1 || (typeElement = (parameter = parameterList.getParameters()[0]).getTypeElement()) == null || !InheritanceUtil.isInheritor((PsiType)(type = typeElement.getType()), (String)"java.util.Collection")) continue;
            return true;
        }
        return false;
    }

    private static Pair<Boolean, PsiNewExpression> isProperAssignmentStatementFound(PsiLocalVariable localVariable, PsiMethodCallExpression addAllExpression) {
        PsiStatement currentStatement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)addAllExpression, PsiStatement.class);
        PsiStatement localVariableDefinitionStatement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)localVariable, PsiStatement.class);
        while (currentStatement != null) {
            if ((currentStatement = (PsiStatement)PsiTreeUtil.getPrevSiblingOfType((PsiElement)currentStatement, PsiStatement.class)) == localVariableDefinitionStatement) {
                return Pair.create((Object)true, null);
            }
            for (PsiAssignmentExpression expression : PsiTreeUtil.findChildrenOfType((PsiElement)currentStatement, PsiAssignmentExpression.class)) {
                PsiExpression lExpression = expression.getLExpression();
                if (!(lExpression instanceof PsiReferenceExpression) || !((PsiReferenceExpression)lExpression).isReferenceTo((PsiElement)localVariable)) continue;
                PsiExpression rExpression = expression.getRExpression();
                boolean isValid = CollectionAddAllCanBeReplacedWithConstructorInspection.checkLocalVariableAssignmentOrInitializer(rExpression);
                return Pair.create((Object)isValid, (Object)(isValid ? (PsiNewExpression)rExpression : null));
            }
        }
        return Pair.create((Object)true, null);
    }

    private static List<PsiElement> extractReferencedElementsFromParameter(PsiMethodCallExpression expression) {
        PsiExpression psiExpression = expression.getArgumentList().getExpressions()[0];
        ArrayList<PsiReferenceExpression> references = new ArrayList<PsiReferenceExpression>(PsiTreeUtil.findChildrenOfType((PsiElement)psiExpression, PsiReferenceExpression.class));
        if (psiExpression instanceof PsiReferenceExpression) {
            references.add((PsiReferenceExpression)psiExpression);
        }
        return ContainerUtil.mapNotNull(references, (Function)new NullableFunction<PsiReferenceExpression, PsiElement>(){

            @Nullable
            public PsiElement fun(PsiReferenceExpression expression) {
                return expression.resolve();
            }
        });
    }

    private static boolean isReferenceToOneOf(PsiReferenceExpression reference, List<PsiElement> elements) {
        for (PsiElement element : elements) {
            if (!reference.isReferenceTo(element)) continue;
            return true;
        }
        return false;
    }

    private static boolean checkUsages(PsiLocalVariable variable, PsiMethodCallExpression methodCallExpression, PsiNewExpression variableAssignmentExpression) {
        PsiCodeBlock variableAssignmentBlock = (PsiCodeBlock)PsiTreeUtil.getParentOfType((PsiElement)variableAssignmentExpression, PsiCodeBlock.class);
        PsiCodeBlock methodCallBlock = (PsiCodeBlock)PsiTreeUtil.getParentOfType((PsiElement)methodCallExpression, PsiCodeBlock.class);
        if (variableAssignmentBlock == null || variableAssignmentBlock != methodCallBlock) {
            return false;
        }
        PsiStatement variableDeclarationStatement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)variableAssignmentExpression, PsiStatement.class);
        PsiStatement methodCallStatement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)methodCallExpression, PsiStatement.class);
        if (variableDeclarationStatement == null || methodCallStatement == null || variableDeclarationStatement.getParent() != methodCallStatement.getParent()) {
            return false;
        }
        PsiStatement nextStatement = variableDeclarationStatement;
        List<PsiElement> referencedElementsFromParameter = CollectionAddAllCanBeReplacedWithConstructorInspection.extractReferencedElementsFromParameter(methodCallExpression);
        while (nextStatement != null) {
            if ((nextStatement = PsiTreeUtil.getNextSiblingOfType((PsiElement)nextStatement, PsiStatement.class)) == methodCallStatement) {
                return true;
            }
            for (PsiReferenceExpression referenceExpression : PsiTreeUtil.findChildrenOfType((PsiElement)nextStatement, PsiReferenceExpression.class)) {
                if (!referenceExpression.isReferenceTo((PsiElement)variable) && !CollectionAddAllCanBeReplacedWithConstructorInspection.isReferenceToOneOf(referenceExpression, referencedElementsFromParameter)) continue;
                return false;
            }
            for (PsiLocalVariable localVariable : PsiTreeUtil.findChildrenOfType((PsiElement)nextStatement, PsiLocalVariable.class)) {
                if (!referencedElementsFromParameter.contains(localVariable)) continue;
                return false;
            }
        }
        return false;
    }

    private static class ReplaceAddAllWithConstructorFix
    implements LocalQuickFix {
        private final SmartPsiElementPointer<PsiMethodCallExpression> myMethodCallExpression;
        private final SmartPsiElementPointer<PsiNewExpression> myAssignmentExpression;

        private ReplaceAddAllWithConstructorFix(PsiNewExpression assignmentExpression, PsiMethodCallExpression expression) {
            SmartPointerManager smartPointerManager = SmartPointerManager.getInstance((Project)assignmentExpression.getProject());
            this.myMethodCallExpression = smartPointerManager.createSmartPsiElementPointer((PsiElement)expression);
            this.myAssignmentExpression = smartPointerManager.createSmartPsiElementPointer((PsiElement)assignmentExpression);
        }

        @Nls
        @NotNull
        public String getName() {
            String string = this.getFamilyName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/CollectionAddAllCanBeReplacedWithConstructorInspection$ReplaceAddAllWithConstructorFix", "getName"));
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = QuickFixBundle.message("collection.addall.can.be.replaced.with.constructor.fix.title", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/CollectionAddAllCanBeReplacedWithConstructorInspection$ReplaceAddAllWithConstructorFix", "getFamilyName"));
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/CollectionAddAllCanBeReplacedWithConstructorInspection$ReplaceAddAllWithConstructorFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/CollectionAddAllCanBeReplacedWithConstructorInspection$ReplaceAddAllWithConstructorFix", "applyFix"));
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)this.myMethodCallExpression.getElement();
            LOG.assertTrue(methodCallExpression != null);
            PsiElement parameter = methodCallExpression.getArgumentList().getExpressions()[0].copy();
            PsiNewExpression element = (PsiNewExpression)this.myAssignmentExpression.getElement();
            LOG.assertTrue(element != null);
            PsiExpressionList constructorArguments = element.getArgumentList();
            LOG.assertTrue(constructorArguments != null);
            constructorArguments.add(parameter);
            methodCallExpression.delete();
        }
    }
}

