/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.settings;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.ui.tree.render.ArrayRenderer;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.ui.Messages;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class ArrayRendererConfigurable
implements UnnamedConfigurable,
Configurable.NoScroll {
    private JTextField myEntriesLimit;
    private JTextField myStartIndex;
    private JTextField myEndIndex;
    private boolean myEntriesLimitUpdateEnabled = true;
    private boolean myIndexUpdateEnabled = true;
    private final ArrayRenderer myRenderer;
    private JComponent myPanel;

    public ArrayRendererConfigurable(ArrayRenderer renderer) {
        this.myRenderer = renderer;
    }

    public ArrayRenderer getRenderer() {
        return this.myRenderer;
    }

    public void reset() {
        this.myStartIndex.setText(String.valueOf(this.myRenderer.START_INDEX));
        this.myEndIndex.setText(String.valueOf(this.myRenderer.END_INDEX));
        this.myEntriesLimit.setText(String.valueOf(this.myRenderer.ENTRIES_LIMIT));
    }

    public void apply() throws ConfigurationException {
        this.applyTo(this.myRenderer, true);
    }

    private void applyTo(ArrayRenderer renderer, boolean showBigRangeWarning) throws ConfigurationException {
        int newStartIndex = ArrayRendererConfigurable.getInt(this.myStartIndex);
        int newEndIndex = ArrayRendererConfigurable.getInt(this.myEndIndex);
        int newLimit = ArrayRendererConfigurable.getInt(this.myEntriesLimit);
        if (newStartIndex < 0) {
            throw new ConfigurationException(DebuggerBundle.message((String)"error.array.renderer.configurable.start.index.less.than.zero", (Object[])new Object[0]));
        }
        if (newEndIndex < newStartIndex) {
            throw new ConfigurationException(DebuggerBundle.message((String)"error.array.renderer.configurable.end.index.less.than.start", (Object[])new Object[0]));
        }
        if (newStartIndex >= 0 && newEndIndex >= 0) {
            int answer;
            if (newStartIndex > newEndIndex) {
                int currentStartIndex = renderer.START_INDEX;
                int currentEndIndex = renderer.END_INDEX;
                newEndIndex = newStartIndex + (currentEndIndex - currentStartIndex);
            }
            if (newLimit <= 0) {
                newLimit = 1;
            }
            if (showBigRangeWarning && newEndIndex - newStartIndex > 10000 && (answer = Messages.showOkCancelDialog((Component)this.myPanel.getRootPane(), (String)DebuggerBundle.message((String)"warning.range.too.big", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getProductName()}), (String)DebuggerBundle.message((String)"title.range.too.big", (Object[])new Object[0]), (Icon)Messages.getWarningIcon())) != 0) {
                return;
            }
        }
        renderer.START_INDEX = newStartIndex;
        renderer.END_INDEX = newEndIndex;
        renderer.ENTRIES_LIMIT = newLimit;
    }

    public JComponent createComponent() {
        this.myPanel = new JPanel(new GridBagLayout());
        this.myStartIndex = new JTextField(5);
        this.myEndIndex = new JTextField(5);
        this.myEntriesLimit = new JTextField(5);
        FontMetrics fontMetrics = this.myStartIndex.getFontMetrics(this.myStartIndex.getFont());
        Dimension minSize = new Dimension(this.myStartIndex.getPreferredSize());
        minSize.width = fontMetrics.stringWidth("AAAAA");
        this.myStartIndex.setMinimumSize(minSize);
        this.myEndIndex.setMinimumSize(minSize);
        this.myEntriesLimit.setMinimumSize(minSize);
        JLabel startIndexLabel = new JLabel(DebuggerBundle.message((String)"label.array.renderer.configurable.start.index", (Object[])new Object[0]));
        startIndexLabel.setLabelFor(this.myStartIndex);
        JLabel endIndexLabel = new JLabel(DebuggerBundle.message((String)"label.array.renderer.configurable.end.index", (Object[])new Object[0]));
        endIndexLabel.setLabelFor(this.myEndIndex);
        JLabel entriesLimitLabel = new JLabel(DebuggerBundle.message((String)"label.array.renderer.configurable.max.count1", (Object[])new Object[0]));
        entriesLimitLabel.setLabelFor(this.myEntriesLimit);
        this.myPanel.add((Component)startIndexLabel, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 8), 0, 0));
        this.myPanel.add((Component)this.myStartIndex, new GridBagConstraints(1, -1, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 8), 0, 0));
        this.myPanel.add((Component)endIndexLabel, new GridBagConstraints(2, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 8), 0, 0));
        this.myPanel.add((Component)this.myEndIndex, new GridBagConstraints(3, -1, 1, 1, 1.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.myPanel.add((Component)entriesLimitLabel, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(4, 0, 0, 8), 0, 0));
        this.myPanel.add((Component)this.myEntriesLimit, new GridBagConstraints(1, -1, 1, 1, 0.0, 0.0, 18, 0, new Insets(4, 0, 0, 8), 0, 0));
        this.myPanel.add((Component)new JLabel(DebuggerBundle.message((String)"label.array.renderer.configurable.max.count2", (Object[])new Object[0])), new GridBagConstraints(2, -1, 2, 1, 0.0, 0.0, 17, 0, new Insets(4, 0, 0, 0), 0, 0));
        this.myPanel.add((Component)new JLabel(), new GridBagConstraints(0, -1, 1, 1, 0.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        DocumentListener listener = new DocumentListener(){

            private void updateEntriesLimit() {
                boolean state = ArrayRendererConfigurable.this.myIndexUpdateEnabled;
                ArrayRendererConfigurable.this.myIndexUpdateEnabled = false;
                try {
                    if (ArrayRendererConfigurable.this.myEntriesLimitUpdateEnabled) {
                        ArrayRendererConfigurable.this.myEntriesLimit.setText(String.valueOf(ArrayRendererConfigurable.getInt(ArrayRendererConfigurable.this.myEndIndex) - ArrayRendererConfigurable.getInt(ArrayRendererConfigurable.this.myStartIndex) + 1));
                    }
                }
                finally {
                    ArrayRendererConfigurable.this.myIndexUpdateEnabled = state;
                }
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.updateEntriesLimit();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.updateEntriesLimit();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.updateEntriesLimit();
            }
        };
        this.myStartIndex.getDocument().addDocumentListener(listener);
        this.myEndIndex.getDocument().addDocumentListener(listener);
        this.myEntriesLimit.getDocument().addDocumentListener(new DocumentListener(){

            private void updateEndIndex() {
                boolean state = ArrayRendererConfigurable.this.myEntriesLimitUpdateEnabled;
                ArrayRendererConfigurable.this.myEntriesLimitUpdateEnabled = false;
                try {
                    if (ArrayRendererConfigurable.this.myIndexUpdateEnabled) {
                        ArrayRendererConfigurable.this.myEndIndex.setText(String.valueOf(ArrayRendererConfigurable.getInt(ArrayRendererConfigurable.this.myEntriesLimit) + ArrayRendererConfigurable.getInt(ArrayRendererConfigurable.this.myStartIndex) - 1));
                    }
                }
                finally {
                    ArrayRendererConfigurable.this.myEntriesLimitUpdateEnabled = state;
                }
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.updateEndIndex();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.updateEndIndex();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.updateEndIndex();
            }
        });
        return this.myPanel;
    }

    private static int getInt(JTextField textField) {
        int newEndIndex = 0;
        try {
            newEndIndex = Integer.parseInt(textField.getText().trim());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return newEndIndex;
    }

    public boolean isModified() {
        ArrayRenderer cloneRenderer = this.myRenderer.clone();
        try {
            this.applyTo(cloneRenderer, false);
        }
        catch (ConfigurationException e) {
            return true;
        }
        boolean valuesEqual = this.myRenderer.END_INDEX == cloneRenderer.END_INDEX && this.myRenderer.START_INDEX == cloneRenderer.START_INDEX && this.myRenderer.ENTRIES_LIMIT == cloneRenderer.ENTRIES_LIMIT;
        return !valuesEqual;
    }

    public void disposeUIResources() {
    }
}

